/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.atomdata;

import org.jmol.constant.EnumVdw;

public class RadiusData {
    public String info;
    public EnumType factorType = EnumType.ABSOLUTE;
    public EnumVdw vdwType = EnumVdw.AUTO;
    public float value = Float.NaN;
    public float valueExtended = 0.0f;
    public float[] values;

    public RadiusData() {
    }

    public RadiusData(float f, EnumType enumType, EnumVdw enumVdw) {
        this.factorType = enumType;
        this.value = f;
        if (enumVdw != null) {
            this.vdwType = enumVdw;
        }
    }

    public RadiusData(float[] fArray) {
        this.values = fArray;
        this.value = 2.1474836E9f;
    }

    public String toString() {
        if (Float.isNaN(this.value)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("");
        switch (this.factorType) {
            case ABSOLUTE: {
                stringBuffer.append(this.value);
                break;
            }
            case OFFSET: {
                stringBuffer.append(this.value > 0.0f ? "+" : "").append(this.value);
                break;
            }
            case FACTOR: {
                stringBuffer.append((int)(this.value * 100.0f)).append("%");
                if (this.vdwType == EnumVdw.AUTO) break;
                stringBuffer.append(this.vdwType.getVdwLabel());
                break;
            }
            case SCREEN: {
                stringBuffer.append((int)this.value);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumType {
        ABSOLUTE,
        OFFSET,
        FACTOR,
        SCREEN;

    }
}

