/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class CastepReader
extends AtomSetCollectionReader {
    private String[] tokens;
    private boolean isPhonon;
    private boolean isOutput;
    private boolean isCell;
    private float a;
    private float b;
    private float c;
    private float alpha;
    private float beta;
    private float gamma;
    private Vector3f[] abc = new Vector3f[3];
    private int atomCount;
    private Point3f[] atomPts;
    private boolean havePhonons = false;
    private String lastQPt;
    private int qpt2;
    private Vector3f desiredQpt;
    private String desiredQ;
    private static final String[] lengthUnitIds = new String[]{"bohr", "m", "cm", "nm", "ang", "a0"};
    private static final float[] lengthUnitFactors = new float[]{0.5291772f, 1.0E10f, 1.0E8f, 10.0f, 1.0f, 0.5291772f};
    private static final double TWOPI = Math.PI * 2;

    public void initializeReader() throws Exception {
        if (this.filter != null) {
            this.filter = this.filter.replace('(', '{').replace(')', '}');
            this.filter = TextFormat.simpleReplace(this.filter, "  ", " ");
            if (this.filter.indexOf("{") >= 0) {
                this.setDesiredQpt(this.filter.substring(this.filter.indexOf("{")));
            }
            this.filter = TextFormat.simpleReplace(this.filter, "-PT", "");
        }
        this.continuing = this.readFileData();
    }

    private void setDesiredQpt(String string) {
        this.desiredQpt = new Vector3f();
        this.desiredQ = "";
        float f = 1.0f;
        float f2 = 1.0f;
        int n = 0;
        int n2 = 0;
        boolean bl = string.indexOf(44) < 0;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '{': {
                    n = i + 1;
                    f = 1.0f;
                    f2 = 1.0f;
                    continue block10;
                }
                case '/': {
                    f = this.parseFloat(string.substring(n, i));
                    n = i + 1;
                    f2 = 0.0f;
                    continue block10;
                }
                case ' ': 
                case ',': 
                case '}': {
                    if (c == '}') {
                        this.desiredQ = string.substring(0, i + 1);
                    } else if (c == ' ' != bl) continue block10;
                    if (f2 == 0.0f) {
                        f2 = this.parseFloat(string.substring(n, i));
                    } else {
                        f = this.parseFloat(string.substring(n, i));
                    }
                    f /= f2;
                    switch (n2++) {
                        case 0: {
                            this.desiredQpt.x = f;
                            break;
                        }
                        case 1: {
                            this.desiredQpt.y = f;
                            break;
                        }
                        case 2: {
                            this.desiredQpt.z = f;
                        }
                    }
                    f2 = 1.0f;
                    if (c == '}') {
                        i = string.length();
                    }
                    n = i + 1;
                }
            }
        }
        Logger.info("Looking for q-pt=" + this.desiredQpt);
    }

    private boolean readFileData() throws Exception {
        while (this.tokenizeCastepCell() > 0) {
            if (this.tokens.length < 2 || !this.tokens[0].equalsIgnoreCase("%BLOCK")) continue;
            Logger.info(this.line);
            if (this.tokens[1].equalsIgnoreCase("LATTICE_ABC")) {
                this.readLatticeAbc();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("LATTICE_CART")) {
                this.readLatticeCart();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("POSITIONS_FRAC")) {
                this.setFractionalCoordinates(true);
                this.readPositionsFrac();
                continue;
            }
            if (!this.tokens[1].equalsIgnoreCase("POSITIONS_ABS")) continue;
            this.setFractionalCoordinates(false);
            this.readPositionsAbs();
        }
        if (this.isPhonon || this.isOutput) {
            if (this.isPhonon) {
                this.isTrajectory = true;
                this.atomSetCollection.allowMultiple = false;
            }
            return true;
        }
        return false;
    }

    protected boolean checkLine() throws Exception {
        if (this.isOutput) {
            if (this.line.contains("Real Lattice(A)")) {
                this.readOutputUnitCell();
            } else if (this.line.contains("Fractional coordinates of atoms")) {
                if (this.doGetModel(++this.modelNumber)) {
                    this.readOutputAtoms();
                }
            } else if (this.doProcessLines && this.line.contains("Atomic Populations (Mulliken)")) {
                this.readOutputCharges();
            }
            return true;
        }
        if (this.line.contains("<-- E")) {
            this.readPhononTrajectories();
            return true;
        }
        if (this.line.indexOf("Unit cell vectors") == 1) {
            this.readPhononUnitCell();
            return true;
        }
        if (this.line.indexOf("Fractional Co-ordinates") >= 0) {
            this.readPhononFractionalCoord();
            return true;
        }
        if (this.line.indexOf("q-pt") >= 0) {
            this.readPhononFrequencies();
            return true;
        }
        return true;
    }

    private void readOutputUnitCell() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
        this.setFractionalCoordinates(true);
        this.abc = this.read3Vectors(false);
        this.setLatticeVectors();
    }

    private void readOutputAtoms() throws Exception {
        this.readLines(2);
        while (this.readLine().indexOf("xxx") < 0) {
            Atom atom = this.atomSetCollection.addNewAtom();
            this.tokens = this.getTokens();
            atom.elementSymbol = this.tokens[1];
            this.setAtomCoord(atom, this.parseFloat(this.tokens[3]), this.parseFloat(this.tokens[4]), this.parseFloat(this.tokens[5]));
        }
    }

    private void readOutputCharges() throws Exception {
        this.readLines(3);
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = this.atomSetCollection.getLastAtomSetAtomIndex(); i < n; ++i) {
            this.tokens = CastepReader.getTokens(this.readLine());
            atomArray[i].partialCharge = this.parseFloat(this.tokens[7]);
        }
    }

    private void readPhononTrajectories() throws Exception {
        this.isTrajectory = true;
        this.doApplySymmetry = true;
        while (this.line != null && this.line.contains("<-- E")) {
            this.atomSetCollection.newAtomSet();
            this.discardLinesUntilContains("<-- h");
            this.setSpaceGroupName("P1");
            this.abc = this.read3Vectors(true);
            this.setLatticeVectors();
            this.setFractionalCoordinates(false);
            this.discardLinesUntilContains("<-- R");
            while (this.line != null && this.line.contains("<-- R")) {
                String[] stringArray = this.getTokens();
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.elementSymbol = stringArray[0];
                this.setAtomCoord(atom, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f, this.parseFloat(stringArray[4]) * 0.5291772f);
                this.readLine();
            }
            this.applySymmetryAndSetTrajectory();
            this.discardLinesUntilContains("<-- E");
        }
    }

    protected void finalizeReader() throws Exception {
        if (this.isPhonon || this.isOutput) {
            this.isTrajectory = false;
            super.finalizeReader();
            return;
        }
        this.doApplySymmetry = true;
        this.setLatticeVectors();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            this.setAtomCoord(this.atomSetCollection.getAtom(i));
        }
        super.finalizeReader();
    }

    private void setLatticeVectors() {
        if (this.abc[0] == null) {
            this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
            return;
        }
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            this.abc[i].get(fArray);
            this.addPrimitiveLatticeVector(i, fArray, 0);
        }
    }

    private void readLatticeAbc() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        if (this.tokens.length < 3) {
            Logger.warn("error reading a,b,c in %BLOCK LATTICE_ABC in CASTEP .cell file");
            return;
        }
        this.a = this.parseFloat(this.tokens[0]) * f;
        this.b = this.parseFloat(this.tokens[1]) * f;
        this.c = this.parseFloat(this.tokens[2]) * f;
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        if (this.tokens.length >= 3) {
            this.alpha = this.parseFloat(this.tokens[0]);
            this.beta = this.parseFloat(this.tokens[1]);
            this.gamma = this.parseFloat(this.tokens[2]);
        } else {
            Logger.warn("error reading alpha,beta,gamma in %BLOCK LATTICE_ABC in CASTEP .cell file");
        }
    }

    private void readLatticeCart() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        for (int i = 0; i < 3; ++i) {
            if (this.tokens.length < 3) {
                Logger.warn("error reading coordinates of lattice vector " + Integer.toString(i + 1) + " in %BLOCK LATTICE_CART in CASTEP .cell file");
                return;
            }
            float f2 = this.parseFloat(this.tokens[0]) * f;
            float f3 = this.parseFloat(this.tokens[1]) * f;
            float f4 = this.parseFloat(this.tokens[2]) * f;
            this.abc[i] = new Vector3f(f2, f3, f4);
            if (this.tokenizeCastepCell() != 0) continue;
            return;
        }
        this.a = this.abc[0].length();
        this.b = this.abc[1].length();
        this.c = this.abc[2].length();
        this.alpha = (float)Math.toDegrees(this.abc[1].angle(this.abc[2]));
        this.beta = (float)Math.toDegrees(this.abc[2].angle(this.abc[0]));
        this.gamma = (float)Math.toDegrees(this.abc[0].angle(this.abc[1]));
    }

    private void readPositionsFrac() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        this.readAtomData(1.0f);
    }

    private void readPositionsAbs() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        this.readAtomData(f);
    }

    private float readLengthUnit(String string) throws Exception {
        float f = 1.0f;
        for (int i = 0; i < lengthUnitIds.length; ++i) {
            if (!string.equalsIgnoreCase(lengthUnitIds[i])) continue;
            f = lengthUnitFactors[i];
            this.tokenizeCastepCell();
            break;
        }
        return f;
    }

    private void readAtomData(float f) throws Exception {
        do {
            if (this.tokens.length >= 4) {
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.elementSymbol = this.tokens[0];
                atom.set(this.parseFloat(this.tokens[1]), this.parseFloat(this.tokens[2]), this.parseFloat(this.tokens[3]));
                atom.scale(f);
                continue;
            }
            Logger.warn("cannot read line with CASTEP atom data: " + this.line);
        } while (this.tokenizeCastepCell() > 0 && !this.tokens[0].equalsIgnoreCase("%ENDBLOCK"));
    }

    private int tokenizeCastepCell() throws Exception {
        int n;
        while (this.readLine() != null) {
            this.line = this.line.trim();
            if (this.line.length() == 0 || this.line.startsWith("#") || this.line.startsWith("!")) continue;
            if (this.isCell) break;
            if (this.line.startsWith("%")) {
                this.isCell = true;
                break;
            }
            if (this.line.startsWith("BEGIN header")) {
                this.isPhonon = true;
                Logger.info("reading CASTEP .phonon file");
                return -1;
            }
            if (!this.line.contains("CASTEP")) break;
            this.isOutput = true;
            Logger.info("reading CASTEP .castep file");
            return -1;
        }
        if (this.line == null) {
            n = 0;
        } else {
            this.tokens = this.getTokens();
            n = this.tokens.length;
        }
        return n;
    }

    private void readPhononUnitCell() throws Exception {
        this.abc = this.read3Vectors(this.line.indexOf("bohr") >= 0);
        this.setSpaceGroupName("P1");
        this.setLatticeVectors();
    }

    private void readPhononFractionalCoord() throws Exception {
        Object[] objectArray;
        this.setFractionalCoordinates(true);
        while (this.readLine() != null && this.line.indexOf("END") < 0) {
            objectArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            this.setAtomCoord(atom, this.parseFloat((String)objectArray[1]), this.parseFloat((String)objectArray[2]), this.parseFloat((String)objectArray[3]));
            atom.elementSymbol = objectArray[4];
            atom.bfactor = this.parseFloat((String)objectArray[5]);
        }
        this.atomCount = this.atomSetCollection.getAtomCount();
        this.atomPts = new Point3f[this.atomCount];
        objectArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomPts[i] = new Point3f((Point3f)objectArray[i]);
        }
    }

    private void readPhononFrequencies() throws Exception {
        String[] stringArray = this.getTokens();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f(this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
        String string = this.getFractionalCoord(vector3f2);
        String string2 = "{" + stringArray[2] + " " + stringArray[3] + " " + stringArray[4] + "}";
        string = string == null ? string2 : "{" + string + "}";
        boolean bl = false;
        boolean bl2 = stringArray[1].equals(this.lastQPt);
        this.qpt2 = bl2 ? this.qpt2 + 1 : 1;
        this.lastQPt = stringArray[1];
        if (this.filter != null && this.checkFilter("Q=")) {
            if (this.desiredQpt != null) {
                vector3f.sub(this.desiredQpt, vector3f2);
                if (vector3f.length() < 0.001f) {
                    string = this.desiredQ;
                }
            }
            boolean bl3 = bl = this.checkFilter("Q=" + string + "." + this.qpt2 + ";") || this.checkFilter("Q=" + this.lastQPt + "." + this.qpt2 + ";") || !bl2 && this.checkFilter("Q=" + string + ";") || !bl2 && this.checkFilter("Q=" + this.lastQPt + ";");
            if (!bl) {
                return;
            }
        }
        boolean bl4 = vector3f2.length() == 0.0f;
        float[] fArray = this.supercell == null || !this.supercell.startsWith("=") ? null : this.atomSetCollection.setSuperCell(this.supercell.substring(1), new float[16]);
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (fArray != null && !bl && !bl2) {
            f = fArray[0];
            float f4 = (vector3f2.x == 0.0f ? 1.0f : vector3f2.x) * f;
            f2 = fArray[5];
            float f5 = (vector3f2.y == 0.0f ? 1.0f : vector3f2.y) * f2;
            f3 = fArray[10];
            float f6 = (vector3f2.z == 0.0f ? 1.0f : vector3f2.z) * f3;
            if ((double)Math.abs(f4 - 1.0f) > 0.001 || (double)Math.abs(f5 - 1.0f) > 0.001 || (double)Math.abs(f6 - 1.0f) > 0.001) {
                return;
            }
            bl = true;
        }
        if (fArray == null || !this.havePhonons) {
            this.appendLoadNote(this.line);
        }
        if (!bl && bl2) {
            return;
        }
        if (!bl && fArray == null == !bl4) {
            return;
        }
        if (this.havePhonons) {
            return;
        }
        this.havePhonons = true;
        String string3 = "q=" + this.lastQPt + " " + string;
        this.applySymmetryAndSetTrajectory();
        if (bl4) {
            vector3f2 = null;
        }
        ArrayList<Float> arrayList = new ArrayList<Float>();
        while (this.readLine() != null && this.line.indexOf("Phonon") < 0) {
            stringArray = this.getTokens();
            arrayList.add(Float.valueOf(this.parseFloat(stringArray[1])));
        }
        this.readLine();
        int n = arrayList.size();
        float[] fArray2 = new float[8];
        Vector3f vector3f3 = new Vector3f();
        this.atomSetCollection.setCollectionName(string3);
        for (int i = 0; i < n; ++i) {
            int n2;
            if (!this.doGetVibration(++this.vibrationNumber)) {
                for (n2 = 0; n2 < this.atomCount; ++n2) {
                    this.readLine();
                }
                continue;
            }
            if (this.desiredVibrationNumber <= 0 && !this.isTrajectory) {
                this.cloneLastAtomSet(this.atomCount, this.atomPts);
                this.applySymmetryAndSetTrajectory();
            }
            this.symmetry = this.atomSetCollection.getSymmetry();
            n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
            float f7 = ((Float)arrayList.get(i)).floatValue();
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n3 = this.atomSetCollection.getAtomCount();
            for (int j = 0; j < this.atomCount; ++j) {
                this.fillFloatArray(null, 0, fArray2);
                for (int k = n2++; k < n3; ++k) {
                    if (atomArray[k].atomSite != j) continue;
                    vector3f3.sub(atomArray[k], atomArray[atomArray[k].atomSite]);
                    vector3f3.x *= f;
                    vector3f3.y *= f2;
                    vector3f3.z *= f3;
                    this.setPhononVector(fArray2, atomArray[k], vector3f3, vector3f2, vector3f);
                    this.atomSetCollection.addVibrationVector(k, vector3f.x, vector3f.y, vector3f.z, true);
                }
            }
            if (this.isTrajectory) {
                this.atomSetCollection.setTrajectory();
            }
            this.atomSetCollection.setAtomSetFrequency(null, null, "" + f7, null);
            this.atomSetCollection.setAtomSetName(TextFormat.formatDecimal(f7, 2) + " cm-1 " + string3);
        }
    }

    private String getFractionalCoord(Vector3f vector3f) {
        return CastepReader.isInt(vector3f.x * 12.0f) && CastepReader.isInt(vector3f.y * 12.0f) && CastepReader.isInt(vector3f.z * 12.0f) ? this.getSymmetry().fcoord(vector3f) : null;
    }

    private static boolean isInt(float f) {
        return Math.abs(f - (float)((int)f)) < 0.001f;
    }

    private void setPhononVector(float[] fArray, Atom atom, Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3) {
        if (vector3f2 == null) {
            vector3f3.set(fArray[2], fArray[4], fArray[6]);
        } else {
            double d = vector3f2.dot(vector3f);
            double d2 = Math.cos(Math.PI * 2 * d);
            double d3 = Math.sin(Math.PI * 2 * d);
            vector3f3.x = (float)(d2 * (double)fArray[2] - d3 * (double)fArray[3]);
            vector3f3.y = (float)(d2 * (double)fArray[4] - d3 * (double)fArray[5]);
            vector3f3.z = (float)(d2 * (double)fArray[6] - d3 * (double)fArray[7]);
        }
        vector3f3.scale((float)Math.sqrt(1.0f / atom.bfactor));
    }
}

