/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class CubeReader
extends AtomSetCollectionReader {
    private int atomCount;
    private boolean isAngstroms = false;

    public void initializeReader() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.readTitleLines();
        this.readAtomCountAndOrigin();
        this.readLines(3);
        this.readAtoms();
        this.applySymmetryAndSetTrajectory();
        this.continuing = false;
    }

    private void readTitleLines() throws Exception {
        if (this.readLine().indexOf("#JVXL") == 0) {
            while (this.readLine().indexOf("#") == 0) {
            }
        }
        this.checkLineForScript();
        String string = this.line.trim();
        this.readLine();
        this.checkLineForScript();
        this.atomSetCollection.setAtomSetName(string + " - " + this.line.trim());
    }

    private void readAtomCountAndOrigin() throws Exception {
        this.readLine();
        this.isAngstroms = this.line.indexOf("ANGSTROMS") >= 0;
        String[] stringArray = this.getTokens();
        if (stringArray[0].charAt(0) == '+') {
            stringArray[0] = stringArray[0].substring(1);
        }
        this.atomCount = Math.abs(this.parseInt(stringArray[0]));
    }

    private void readAtoms() throws Exception {
        float f = this.isAngstroms ? 1.0f : 0.5291772f;
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)this.parseInt(this.line);
            atom.partialCharge = this.parseFloat();
            this.setAtomCoord(atom, this.parseFloat() * f, this.parseFloat() * f, this.parseFloat() * f);
        }
    }
}

