/*
 * Decompiled with CFR 0.152.
 */
package naga.packetwriter;

import java.nio.ByteBuffer;
import naga.NIOUtils;
import naga.PacketWriter;

public class RegularPacketWriter
implements PacketWriter {
    private ByteBuffer m_header;
    private ByteBuffer m_content;
    private final boolean m_bigEndian;
    private final int m_headerSize;

    public RegularPacketWriter(int n, boolean bl) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Header must be between 1 and 4 bytes long.");
        }
        this.m_bigEndian = bl;
        this.m_headerSize = n;
        this.m_header = ByteBuffer.allocate(0);
        this.m_content = ByteBuffer.allocate(0);
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.m_header.hasRemaining() ? this.m_header : this.m_content;
    }

    @Override
    public boolean isEmpty() {
        return !this.m_header.hasRemaining() && !this.m_content.hasRemaining();
    }

    @Override
    public void setPacket(byte[] byArray) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Attempted to add new packet before the previous was sent.");
        }
        this.m_header = NIOUtils.getByteBufferFromPacketSize(this.m_headerSize, byArray.length, this.m_bigEndian);
        this.m_content = ByteBuffer.wrap(byArray);
    }
}

