/*
 * Decompiled with CFR 0.152.
 */
package naga.packetreader;

import java.nio.ByteBuffer;
import naga.PacketReader;
import naga.exception.ProtocolViolationException;

public class RawPacketReader
implements PacketReader {
    public static final int DEFAULT_BUFFER_SIZE = 256;
    private final ByteBuffer m_buffer;

    public RawPacketReader(int n) {
        this.m_buffer = ByteBuffer.allocate(n);
    }

    public RawPacketReader() {
        this(256);
    }

    @Override
    public ByteBuffer getBuffer() {
        return this.m_buffer;
    }

    @Override
    public byte[] getNextPacket() throws ProtocolViolationException {
        if (this.m_buffer.position() == 0) {
            return null;
        }
        this.m_buffer.flip();
        byte[] byArray = new byte[this.m_buffer.remaining()];
        this.m_buffer.get(byArray);
        this.m_buffer.clear();
        return byArray;
    }
}

