/*
 * Decompiled with CFR 0.152.
 */
package naga;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import naga.ChannelResponder;
import naga.ConnectionAcceptor;
import naga.NIOServerSocket;
import naga.NIOService;
import naga.NIOUtils;
import naga.ServerSocketObserver;

class ServerSocketChannelResponder
extends ChannelResponder
implements NIOServerSocket {
    private long m_totalRefusedConnections;
    private long m_totalAcceptedConnections;
    private long m_totalFailedConnections;
    private long m_totalConnections;
    private volatile ConnectionAcceptor m_connectionAcceptor;
    private ServerSocketObserver m_observer = null;

    public ServerSocketChannelResponder(NIOService nIOService, ServerSocketChannel serverSocketChannel, InetSocketAddress inetSocketAddress) throws IOException {
        super(nIOService, serverSocketChannel, inetSocketAddress);
        this.setConnectionAcceptor(ConnectionAcceptor.ALLOW);
        this.m_totalRefusedConnections = 0L;
        this.m_totalAcceptedConnections = 0L;
        this.m_totalFailedConnections = 0L;
        this.m_totalConnections = 0L;
    }

    @Override
    public void keyInitialized() {
    }

    @Override
    public ServerSocketChannel getChannel() {
        return (ServerSocketChannel)super.getChannel();
    }

    @Override
    public void socketReadyForAccept() {
        ++this.m_totalConnections;
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.getChannel().accept();
            if (socketChannel == null) {
                --this.m_totalConnections;
                return;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
            if (!this.m_connectionAcceptor.acceptConnection(inetSocketAddress)) {
                ++this.m_totalRefusedConnections;
                NIOUtils.closeChannelSilently(socketChannel);
                return;
            }
            this.m_observer.newConnection(this.getNIOService().registerSocketChannel(socketChannel, inetSocketAddress));
            ++this.m_totalAcceptedConnections;
        }
        catch (IOException iOException) {
            NIOUtils.closeChannelSilently(socketChannel);
            ++this.m_totalFailedConnections;
            this.m_observer.acceptFailed(iOException);
        }
    }

    public void notifyWasCancelled() {
        this.close();
    }

    @Override
    public long getTotalRefusedConnections() {
        return this.m_totalRefusedConnections;
    }

    @Override
    public long getTotalConnections() {
        return this.m_totalConnections;
    }

    @Override
    public long getTotalFailedConnections() {
        return this.m_totalFailedConnections;
    }

    @Override
    public long getTotalAcceptedConnections() {
        return this.m_totalAcceptedConnections;
    }

    @Override
    public void setConnectionAcceptor(ConnectionAcceptor connectionAcceptor) {
        this.m_connectionAcceptor = connectionAcceptor == null ? ConnectionAcceptor.DENY : connectionAcceptor;
    }

    private void notifyObserverSocketDied(Exception exception) {
        if (this.m_observer == null) {
            return;
        }
        try {
            this.m_observer.serverSocketDied(exception);
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
    }

    @Override
    public void listen(ServerSocketObserver serverSocketObserver) {
        if (serverSocketObserver == null) {
            throw new NullPointerException();
        }
        this.markObserverSet();
        this.getNIOService().queue(new BeginListenEvent(serverSocketObserver));
    }

    @Override
    protected void shutdown(Exception exception) {
        this.notifyObserverSocketDied(exception);
    }

    @Override
    public ServerSocket socket() {
        return this.getChannel().socket();
    }

    private class BeginListenEvent
    implements Runnable {
        private final ServerSocketObserver m_newObserver;

        private BeginListenEvent(ServerSocketObserver serverSocketObserver) {
            this.m_newObserver = serverSocketObserver;
        }

        @Override
        public void run() {
            ServerSocketChannelResponder.this.m_observer = this.m_newObserver;
            if (!ServerSocketChannelResponder.this.isOpen()) {
                ServerSocketChannelResponder.this.notifyObserverSocketDied(null);
                return;
            }
            ServerSocketChannelResponder.this.addInterest(16);
        }

        public String toString() {
            return "BeginListen[" + this.m_newObserver + "]";
        }
    }
}

