/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Stars;

class StarsRenderer
extends ShapeRenderer {
    StarsRenderer() {
    }

    void render() {
        Stars stars = (Stars)this.shape;
        if (stars.mads == null) {
            return;
        }
        Atom[] atoms = this.frame.atoms;
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Atom atom = atoms[i];
            if (!atom.isShapeVisible(this.myVisibilityFlag) || this.frame.bsHidden.get(i)) continue;
            short colix = stars.colixes == null ? (short)0 : stars.colixes[i];
            this.render1(atom, stars.mads[i], colix);
        }
    }

    void render1(Atom atom, short mad, short colix) {
        int x = atom.screenX;
        int y = atom.screenY;
        int z = atom.screenZ;
        int d = this.viewer.scaleToScreen(z, mad);
        d -= d & 1 ^ 1;
        colix = Graphics3D.getColixInherited(colix, atom.colixAtom);
        int r = d / 2;
        this.g3d.drawLine(colix, x - r, y, z, x - r + d, y, z);
        this.g3d.drawLine(colix, x, y - r, z, x, y - r + d, z);
    }
}

