/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Frame;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.Viewer;

class RepaintManager {
    Viewer viewer;
    FrameRenderer frameRenderer;
    int currentModelIndex = 0;
    int backgroundModelIndex = -1;
    private BitSet bsVisibleFrames = new BitSet();
    AnimationThread animationThread;
    boolean inMotion = false;
    int holdRepaint = 0;
    boolean repaintPending;
    final Rectangle rectOversample = new Rectangle();
    boolean tOversample;
    int firstModelIndex;
    int lastModelIndex;
    int frameStep;
    int modelCount;
    int animationDirection = 1;
    int currentDirection = 1;
    int animationFps = 10;
    int animationReplayMode = 0;
    float firstFrameDelay;
    float lastFrameDelay;
    int firstFrameDelayMs;
    int lastFrameDelayMs;
    boolean animationOn = false;
    boolean animationPaused = false;
    int intAnimThread = 0;

    RepaintManager(Viewer viewer) {
        this.viewer = viewer;
        this.frameRenderer = new FrameRenderer(viewer);
    }

    void setCurrentModelIndex(int modelIndex) {
        Frame frame = this.viewer.getFrame();
        this.currentModelIndex = frame == null || modelIndex < 0 || modelIndex >= frame.getModelCount() ? -1 : modelIndex;
        if (this.currentModelIndex == -1) {
            this.setBackgroundModelIndex(-1);
        }
        this.viewer.setTainted(true);
        if (frame != null) {
            this.setStatusFrameChanged();
        }
        this.setFrameRangeVisible();
    }

    void setStatusFrameChanged() {
        this.viewer.setStatusFrameChanged(this.animationOn ? -2 - this.currentModelIndex : this.currentModelIndex);
    }

    void setBackgroundModelIndex(int modelIndex) {
        Frame frame = this.viewer.getFrame();
        if (frame == null || modelIndex < 0 || modelIndex >= frame.getModelCount() || this.currentModelIndex == -1) {
            modelIndex = -1;
        }
        this.backgroundModelIndex = modelIndex;
        this.viewer.setTainted(true);
        this.setFrameRangeVisible();
    }

    BitSet getVisibleFramesBitSet() {
        return this.bsVisibleFrames;
    }

    private void setFrameRangeVisible() {
        this.bsVisibleFrames.clear();
        if (this.currentModelIndex >= 0) {
            this.bsVisibleFrames.set(this.currentModelIndex);
            if (this.backgroundModelIndex >= 0) {
                this.bsVisibleFrames.set(this.backgroundModelIndex);
            }
            return;
        }
        if (this.frameStep == 0) {
            return;
        }
        for (int i = this.firstModelIndex; i != this.lastModelIndex; i += this.frameStep) {
            this.bsVisibleFrames.set(i);
        }
        this.bsVisibleFrames.set(this.lastModelIndex);
    }

    void setInMotion(boolean inMotion) {
        this.inMotion = inMotion;
        if (!inMotion) {
            this.refresh();
        }
    }

    void pushHoldRepaint() {
        ++this.holdRepaint;
    }

    void popHoldRepaint() {
        --this.holdRepaint;
        if (this.holdRepaint <= 0) {
            this.holdRepaint = 0;
            this.repaintPending = true;
            this.viewer.repaint();
        }
    }

    void refresh() {
        if (this.repaintPending) {
            return;
        }
        this.repaintPending = true;
        if (this.holdRepaint == 0) {
            this.viewer.repaint();
        }
    }

    synchronized void requestRepaintAndWait() {
        this.viewer.repaint();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void repaintDone() {
        this.repaintPending = false;
        this.notify();
    }

    void setOversample(boolean tOversample) {
        this.tOversample = tOversample;
    }

    void render(Graphics3D g3d, Rectangle rectClip, Frame frame, int displayModelID) {
        this.frameRenderer.render(g3d, rectClip, frame, displayModelID);
        Rectangle band = this.viewer.getRubberBandSelection();
        if (band != null) {
            g3d.drawRect(this.viewer.getColixRubberband(), band.x, band.y, 0, 0, band.width, band.height);
        }
    }

    void initializePointers(int frameStep) {
        this.firstModelIndex = 0;
        this.modelCount = frameStep == 0 ? 0 : this.viewer.getModelCount();
        this.lastModelIndex = this.modelCount - 1;
        this.frameStep = frameStep;
    }

    void clear() {
        this.clearAnimation();
        this.frameRenderer.clear();
    }

    void clearAnimation() {
        this.setAnimationOn(false);
        this.setCurrentModelIndex(0);
        this.setAnimationDirection(1);
        this.setAnimationFps(10);
        this.setAnimationReplayMode(0, 0.0f, 0.0f);
        this.initializePointers(0);
    }

    Hashtable getAnimationInfo() {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("firstModelIndex", new Integer(this.firstModelIndex));
        info.put("lastModelIndex", new Integer(this.lastModelIndex));
        info.put("animationDirection", new Integer(this.animationDirection));
        info.put("currentDirection", new Integer(this.currentDirection));
        info.put("displayModelIndex", new Integer(this.currentModelIndex));
        info.put("displayModelNumber", new Integer(this.currentModelIndex >= 0 ? this.viewer.getModelNumber(this.currentModelIndex) : 0));
        info.put("displayModelName", this.currentModelIndex >= 0 ? this.viewer.getModelName(this.currentModelIndex) : "");
        info.put("animationFps", new Integer(this.animationFps));
        info.put("animationReplayMode", new Integer(this.animationReplayMode));
        info.put("firstFrameDelay", new Float(this.firstFrameDelay));
        info.put("lastFrameDelay", new Float(this.lastFrameDelay));
        info.put("animationOn", new Boolean(this.animationOn));
        info.put("animationPaused", new Boolean(this.animationPaused));
        return info;
    }

    String getState() {
        if (this.modelCount < 2) {
            return "";
        }
        StringBuffer commands = new StringBuffer("# frame state;\n# modelCount " + this.modelCount + ";\n# first " + this.viewer.getModelNumber(0) + ";\n# last " + this.viewer.getModelNumber(this.modelCount - 1) + ";\n");
        if (this.backgroundModelIndex >= 0) {
            commands.append("background model " + this.backgroundModelIndex + ";\n");
        }
        if (this.currentModelIndex >= 0) {
            commands.append("frame RANGE " + this.viewer.getModelNumber(this.firstModelIndex) + " " + this.viewer.getModelNumber(this.lastModelIndex) + ";\n");
            commands.append("animation DIRECTION " + (this.animationDirection == 1 ? "+1" : "-1") + ";\n");
            commands.append("animation " + (this.animationOn ? "ON" : "OFF") + ";\n");
            if (this.animationOn && this.animationPaused) {
                commands.append("animation PAUSE;\n");
            }
            commands.append("frame " + this.viewer.getModelNumber(this.currentModelIndex) + ";\n");
        } else {
            commands.append("frame ALL;\n");
        }
        commands.append("\n");
        return commands.toString();
    }

    void setAnimationDirection(int animationDirection) {
        this.animationDirection = animationDirection;
        this.currentDirection = 1;
    }

    void setAnimationFps(int animationFps) {
        if (animationFps >= 1 && animationFps <= 50) {
            this.animationFps = animationFps;
        } else {
            Logger.error("invalid animationFps:" + animationFps);
        }
    }

    void setAnimationReplayMode(int animationReplayMode, float firstFrameDelay, float lastFrameDelay) {
        this.firstFrameDelay = firstFrameDelay > 0.0f ? firstFrameDelay : 0.0f;
        this.firstFrameDelayMs = (int)(this.firstFrameDelay * 1000.0f);
        this.lastFrameDelay = lastFrameDelay > 0.0f ? lastFrameDelay : 0.0f;
        this.lastFrameDelayMs = (int)(this.lastFrameDelay * 1000.0f);
        if (animationReplayMode >= 0 && animationReplayMode <= 2) {
            this.animationReplayMode = animationReplayMode;
        } else {
            Logger.error("invalid animationReplayMode:" + animationReplayMode);
        }
    }

    void setAnimationRange(int framePointer, int framePointer2) {
        this.modelCount = this.viewer.getModelCount();
        if (framePointer < 0) {
            framePointer = 0;
        }
        if (framePointer2 < 0) {
            framePointer2 = this.modelCount;
        }
        if (framePointer >= this.modelCount) {
            framePointer = this.modelCount - 1;
        }
        if (framePointer2 >= this.modelCount) {
            framePointer2 = this.modelCount - 1;
        }
        this.firstModelIndex = framePointer;
        this.lastModelIndex = framePointer2;
        this.frameStep = framePointer2 < framePointer ? -1 : 1;
        this.rewindAnimation();
    }

    void setAnimationOn(boolean animationOn) {
        if (!animationOn || !this.viewer.haveFrame()) {
            this.setAnimationOff(false);
            return;
        }
        this.viewer.refresh(0, "Viewer:setAnimationOn");
        this.setAnimationRange(-1, -1);
        this.resumeAnimation();
    }

    void setAnimationOff(boolean isPaused) {
        if (this.animationThread != null) {
            this.animationThread.interrupt();
            this.animationThread = null;
        }
        this.animationPaused = isPaused;
        this.viewer.refresh(0, "Viewer:setAnimationOff");
        this.animationOn = false;
        this.setStatusFrameChanged();
    }

    void pauseAnimation() {
        this.setAnimationOff(true);
    }

    void reverseAnimation() {
        this.currentDirection = -this.currentDirection;
        if (!this.animationOn) {
            this.resumeAnimation();
        }
    }

    void resumeAnimation() {
        if (this.currentModelIndex < 0) {
            this.setAnimationRange(this.firstModelIndex, this.lastModelIndex);
        }
        if (this.modelCount <= 1) {
            this.animationOn = false;
            return;
        }
        this.animationOn = true;
        this.animationPaused = false;
        if (this.animationThread == null) {
            ++this.intAnimThread;
            this.animationThread = new AnimationThread(this.firstModelIndex, this.lastModelIndex, this.intAnimThread);
            this.animationThread.start();
        }
    }

    boolean setAnimationNext() {
        return this.setAnimationRelative(this.animationDirection);
    }

    void setAnimationLast() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.lastModelIndex : this.firstModelIndex);
    }

    void rewindAnimation() {
        this.setCurrentModelIndex(this.animationDirection > 0 ? this.firstModelIndex : this.lastModelIndex);
        this.currentDirection = 1;
    }

    boolean setAnimationPrevious() {
        return this.setAnimationRelative(-this.animationDirection);
    }

    boolean setAnimationRelative(int direction) {
        boolean isDone;
        int frameStep = this.frameStep * direction * this.currentDirection;
        int modelIndexNext = this.currentModelIndex + frameStep;
        boolean bl = isDone = modelIndexNext > this.firstModelIndex && modelIndexNext > this.lastModelIndex || modelIndexNext < this.firstModelIndex && modelIndexNext < this.lastModelIndex;
        if (isDone) {
            switch (this.animationReplayMode) {
                case 0: {
                    return false;
                }
                case 1: {
                    modelIndexNext = this.animationDirection > 0 ? this.firstModelIndex : this.lastModelIndex;
                    break;
                }
                case 2: {
                    this.currentDirection = -this.currentDirection;
                    modelIndexNext -= 2 * frameStep;
                }
            }
        }
        if (modelIndexNext < 0 || modelIndexNext >= this.modelCount) {
            return false;
        }
        this.setCurrentModelIndex(modelIndexNext);
        return true;
    }

    class AnimationThread
    extends Thread
    implements Runnable {
        final int framePointer;
        final int framePointer2;
        int intThread;

        AnimationThread(int framePointer, int framePointer2, int intAnimThread) {
            this.framePointer = framePointer;
            this.framePointer2 = framePointer2;
            this.intThread = intAnimThread;
        }

        public void run() {
            long timeBegin = System.currentTimeMillis();
            int targetTime = 0;
            Logger.debug("animation thread " + this.intThread + " running");
            RepaintManager.this.requestRepaintAndWait();
            try {
                int sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                if (sleepTime > 0) {
                    Thread.sleep(sleepTime);
                }
                while (!this.isInterrupted()) {
                    if (RepaintManager.this.currentModelIndex == this.framePointer && (sleepTime = (targetTime += RepaintManager.this.firstFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (RepaintManager.this.currentModelIndex == this.framePointer2 && (sleepTime = (targetTime += RepaintManager.this.lastFrameDelayMs) - (int)(System.currentTimeMillis() - timeBegin)) > 0) {
                        Thread.sleep(sleepTime);
                    }
                    if (!RepaintManager.this.setAnimationNext()) {
                        Logger.debug("animation thread " + this.intThread + " exiting");
                        RepaintManager.this.setAnimationOff(false);
                        return;
                    }
                    sleepTime = (targetTime += 1000 / RepaintManager.this.animationFps) - (int)(System.currentTimeMillis() - timeBegin);
                    if (sleepTime < 0) continue;
                    RepaintManager.this.refresh();
                    sleepTime = targetTime - (int)(System.currentTimeMillis() - timeBegin);
                    if (sleepTime <= 0) continue;
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException ie) {
                Logger.debug("animation thread interrupted!");
                RepaintManager.this.setAnimationOn(false);
            }
        }
    }
}

