/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.Mmset;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.Polymer;
import org.jmol.viewer.Shape;

abstract class Mps
extends Shape {
    Mmset mmset;
    Atom[] atoms;
    Mpsmodel[] mpsmodels;

    Mps() {
    }

    final void initShape() {
        this.mmset = this.frame.mmset;
        this.atoms = this.frame.atoms;
    }

    void setSize(int size, BitSet bsSelected) {
        short mad = (short)size;
        this.initialize();
        int m = this.mpsmodels.length;
        while (--m >= 0) {
            this.mpsmodels[m].setMad(mad, bsSelected);
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        this.initialize();
        if ("color" == propertyName) {
            byte pid = JmolConstants.pidOf(value);
            short colix = Graphics3D.getColix(value);
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setColix(colix, pid, bs);
            }
            return;
        }
        if ("translucency" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            int m = this.mpsmodels.length;
            while (--m >= 0) {
                this.mpsmodels[m].setTranslucent(isTranslucent, bs);
            }
        }
    }

    String getShapeState() {
        Hashtable temp = new Hashtable();
        Hashtable temp2 = new Hashtable();
        int m = this.mpsmodels.length;
        while (--m >= 0) {
            this.mpsmodels[m].setShapeState(temp, temp2);
        }
        return Shape.getShapeCommands(temp, temp2, this.frame.atomCount);
    }

    abstract MpsShape allocateMpspolymer(Polymer var1);

    void initialize() {
        if (this.mpsmodels == null) {
            int modelCount = this.mmset == null ? 0 : this.mmset.getModelCount();
            Model[] models = this.mmset.getModels();
            this.mpsmodels = new Mpsmodel[modelCount];
            int i = modelCount;
            while (--i >= 0) {
                this.mpsmodels[i] = new Mpsmodel(this, models[i]);
            }
        }
    }

    int getMpsmodelCount() {
        if (this.mpsmodels == null) {
            return 0;
        }
        return this.mpsmodels.length;
    }

    Mpsmodel getMpsmodel(int i) {
        return this.mpsmodels[i];
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
        int i = this.mpsmodels.length;
        while (--i >= 0) {
            this.mpsmodels[i].findNearestAtomIndex(xMouse, yMouse, closest);
        }
    }

    void setModelClickability() {
        if (this.mpsmodels == null) {
            return;
        }
        int i = this.mpsmodels.length;
        while (--i >= 0) {
            this.mpsmodels[i].setModelClickability();
        }
    }

    abstract class MpsShape {
        Mps shape;
        Polymer polymer;
        Mesh[] meshes;
        boolean[] meshReady;
        short madOn;
        short madHelixSheet;
        short madTurnRandom;
        short madDnaRna;
        short[] mads;
        short[] colixes;
        byte[] paletteIDs;
        BitSet bsColixSet;
        BitSet bsSizeSet;
        boolean isActive;
        int monomerCount;
        Monomer[] monomers;
        Point3f[] leadMidpoints;
        Point3f[] leadPoints;
        Vector3f[] wingVectors;
        int[] leadAtomIndices;
        boolean hasBfactorRange = false;
        int bfactorMin;
        int bfactorMax;
        int range;
        float floatRange;
        private static final double eightPiSquared100 = 7895.6835208714865;

        MpsShape(Polymer polymer, int madOn, int madHelixSheet, int madTurnRandom, int madDnaRna) {
            this.polymer = polymer;
            this.madOn = (short)madOn;
            this.madHelixSheet = (short)madHelixSheet;
            this.madTurnRandom = (short)madTurnRandom;
            this.madDnaRna = (short)madDnaRna;
            this.monomerCount = polymer.monomerCount;
            if (this.monomerCount > 0) {
                this.colixes = new short[this.monomerCount];
                this.paletteIDs = new byte[this.monomerCount];
                this.mads = new short[this.monomerCount + 1];
                this.monomers = polymer.monomers;
                this.meshReady = new boolean[this.monomerCount];
                this.meshes = new Mesh[this.monomerCount];
                this.leadPoints = polymer.getLeadPoints();
                this.leadMidpoints = polymer.getLeadMidpoints();
                this.wingVectors = polymer.getWingVectors();
                this.leadAtomIndices = polymer.getLeadAtomIndices();
            }
        }

        void setShape(Mps shape) {
            this.shape = shape;
        }

        void calcBfactorRange() {
            this.bfactorMin = this.bfactorMax = this.monomers[0].getLeadAtom().getBfactor100();
            int i = this.monomerCount;
            while (--i > 0) {
                int bfactor = this.monomers[i].getLeadAtom().getBfactor100();
                if (bfactor < this.bfactorMin) {
                    this.bfactorMin = bfactor;
                    continue;
                }
                if (bfactor <= this.bfactorMax) continue;
                this.bfactorMax = bfactor;
            }
            this.range = this.bfactorMax - this.bfactorMin;
            this.floatRange = this.range;
            this.hasBfactorRange = true;
        }

        short calcMeanPositionalDisplacement(int bFactor100) {
            return (short)(Math.sqrt((double)bFactor100 / 7895.6835208714865) * 1000.0);
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            this.polymer.findNearestAtomIndex(xMouse, yMouse, closest, this.mads, Mps.this.myVisibilityFlag);
        }

        void setMad(short mad, BitSet bsSelected) {
            this.isActive = true;
            if (this.bsSizeSet == null) {
                this.bsSizeSet = new BitSet();
            }
            int i = this.monomerCount;
            while (--i >= 0) {
                int leadAtomIndex = this.leadAtomIndices[i];
                if (!bsSelected.get(leadAtomIndex)) continue;
                this.mads[i] = mad >= 0 ? mad : this.getMadSpecial(mad, i);
                boolean isVisible = this.mads[i] > 0;
                this.bsSizeSet.set(i, isVisible);
                this.monomers[i].setShapeVisibility(Mps.this.myVisibilityFlag, isVisible);
                Mps.this.atoms[leadAtomIndex].setShapeVisibility(Mps.this.myVisibilityFlag, isVisible);
                this.falsifyMesh(i, true);
            }
            if (this.monomerCount > 1) {
                this.mads[this.monomerCount] = this.mads[this.monomerCount - 1];
            }
        }

        short getMadSpecial(short mad, int groupIndex) {
            switch (mad) {
                case -1: {
                    if (this.madOn >= 0) {
                        return this.madOn;
                    }
                    if (this.madOn != -2) {
                        Logger.error("not supported?");
                        return 0;
                    }
                }
                case -2: {
                    switch (this.monomers[groupIndex].getProteinStructureType()) {
                        case 2: 
                        case 3: {
                            return this.madHelixSheet;
                        }
                        case 4: 
                        case 5: {
                            return this.madDnaRna;
                        }
                    }
                    return this.madTurnRandom;
                }
                case -3: {
                    if (!this.hasBfactorRange) {
                        this.calcBfactorRange();
                    }
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    int bfactor100 = atom.getBfactor100();
                    int scaled = bfactor100 - this.bfactorMin;
                    if (this.range == 0) {
                        return 0;
                    }
                    float percentile = (float)scaled / this.floatRange;
                    if (percentile < 0.0f || percentile > 1.0f) {
                        Logger.error("Que ha ocurrido? " + percentile);
                    }
                    return (short)(1750.0f * percentile + 250.0f);
                }
                case -4: {
                    Atom atom = this.monomers[groupIndex].getLeadAtom();
                    return (short)(2 * this.calcMeanPositionalDisplacement(atom.getBfactor100()));
                }
            }
            Logger.error("unrecognized Mps.getSpecial(" + mad + ")");
            return 0;
        }

        void falsifyMesh(int index, boolean andNearby) {
            if (this.meshReady == null) {
                return;
            }
            this.meshReady[index] = false;
            if (!andNearby) {
                return;
            }
            if (index > 0) {
                this.meshReady[index - 1] = false;
            }
            if (index < this.monomerCount - 1) {
                this.meshReady[index + 1] = false;
            }
        }

        void setColix(short colix, byte pid, BitSet bsSelected) {
            this.isActive = true;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.monomerCount;
            while (--i >= 0) {
                int atomIndex = this.leadAtomIndices[i];
                if (!bsSelected.get(atomIndex)) continue;
                this.colixes[i] = this.shape.setColix(colix, pid, atomIndex);
                this.paletteIDs[i] = pid;
                this.bsColixSet.set(i, this.colixes[i] != 0);
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            this.isActive = true;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            int i = this.monomerCount;
            while (--i >= 0) {
                if (!bsSelected.get(this.leadAtomIndices[i])) continue;
                this.colixes[i] = Graphics3D.getColixTranslucent(this.colixes[i], isTranslucent);
                this.bsColixSet.set(i, this.colixes[i] != 0);
            }
        }

        void setShapeState(Hashtable temp, Hashtable temp2) {
            if (!this.isActive) {
                return;
            }
            String type = JmolConstants.shapeClassBases[Mps.this.shapeID];
            for (int i = 0; i < this.monomerCount; ++i) {
                int atomIndex1 = this.monomers[i].firstAtomIndex;
                int atomIndex2 = this.monomers[i].lastAtomIndex;
                if (!this.bsSizeSet.get(i)) continue;
                Shape.setStateInfo(temp, atomIndex1, atomIndex2, type + " " + (float)this.mads[i] / 2000.0f);
                if (this.bsColixSet == null || !this.bsColixSet.get(i)) continue;
                Shape.setStateInfo(temp2, atomIndex1, atomIndex2, Mps.this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
            }
        }

        void setModelClickability() {
            if (!this.isActive || this.wingVectors == null) {
                return;
            }
            boolean isNucleicPolymer = this.polymer instanceof NucleicPolymer;
            int i = this.monomerCount;
            while (--i >= 0) {
                int iAtom;
                if (this.mads[i] <= 0 || Mps.this.frame.bsHidden.get(iAtom = this.leadAtomIndices[i])) continue;
                Mps.this.frame.atoms[iAtom].clickabilityFlags |= JmolConstants.ALPHA_CARBON_VISIBILITY_FLAG;
                if (!isNucleicPolymer) continue;
                ((NucleicMonomer)this.monomers[i]).setModelClickability();
            }
        }
    }

    class Mpsmodel {
        MpsShape[] mpspolymers;
        int modelIndex;
        int modelVisibilityFlags = 0;

        Mpsmodel(Mps shape, Model model) {
            this.mpspolymers = new MpsShape[model.getPolymerCount()];
            this.modelIndex = model.modelIndex;
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i] = Mps.this.allocateMpspolymer(model.getPolymer(i));
                this.mpspolymers[i].setShape(shape);
            }
        }

        void setMad(short mad, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                MpsShape polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setMad(mad, bsSelected);
            }
        }

        void setColix(short colix, byte pid, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                MpsShape polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setColix(colix, pid, bsSelected);
            }
        }

        void setTranslucent(boolean isTranslucent, BitSet bsSelected) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                MpsShape polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setTranslucent(isTranslucent, bsSelected);
            }
        }

        void setShapeState(Hashtable temp, Hashtable temp2) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                MpsShape polymer = this.mpspolymers[i];
                if (polymer.monomerCount <= 0) continue;
                polymer.setShapeState(temp, temp2);
            }
        }

        int getMpspolymerCount() {
            return this.mpspolymers.length;
        }

        MpsShape getMpspolymer(int i) {
            return this.mpspolymers[i];
        }

        void findNearestAtomIndex(int xMouse, int yMouse, Closest closest) {
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i].findNearestAtomIndex(xMouse, yMouse, closest);
            }
        }

        void setModelClickability() {
            int displayModelIndex = Mps.this.viewer.getCurrentModelIndex();
            this.modelVisibilityFlags = displayModelIndex >= 0 && displayModelIndex != this.modelIndex ? 0 : Mps.this.myVisibilityFlag;
            int i = this.mpspolymers.length;
            while (--i >= 0) {
                this.mpspolymers[i].setModelClickability();
            }
        }
    }
}

