/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point4f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.Shape;
import org.jmol.viewer.StateManager;

class MolecularOrbital
extends Isosurface {
    String moTranslucency = null;
    Point4f moPlane = null;
    Float moCutoff = new Float(0.05f);
    Float moResolution = null;
    Float moScale = null;
    Integer moColorPos = null;
    Integer moColorNeg = null;
    boolean moIsPositiveOnly = false;
    String moTitleFormat = null;
    boolean moDebug;
    int myColorPt;
    String strID;
    int moNumber;
    Hashtable htModels;
    Hashtable thisModel;
    Mesh thisMesh;

    MolecularOrbital() {
    }

    void initShape() {
        super.initShape();
        this.myType = "molecularOrbital";
        super.setProperty("thisID", "mo", null);
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("MolecularOrbital.setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.moDebug = false;
            this.strID = this.getId((Integer)value);
            super.setProperty("init", null, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = (Hashtable)this.htModels.get(this.strID);
            this.moNumber = this.thisModel == null || !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            return;
        }
        if ("cutoff" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == propertyName) {
            this.thisModel.put("moScale", this.moScale);
            return;
        }
        if ("cutoffPositive" == propertyName) {
            this.thisModel.put("moCutoff", value);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == propertyName) {
            this.thisModel.put("moResolution", value);
            return;
        }
        if ("titleFormat" == propertyName) {
            this.moTitleFormat = (String)value;
            return;
        }
        if ("colorRGB" == propertyName) {
            this.moColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == propertyName) {
            if (value == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", value);
            }
            return;
        }
        if ("molecularOrbital" == propertyName) {
            this.moNumber = (Integer)value;
            this.thisModel.put("moNumber", value);
            this.setOrbital(this.moNumber);
            return;
        }
        if ("translucency" == propertyName) {
            this.thisModel.put("moTranslucency", value);
        }
        if ("delete" == propertyName) {
            this.htModels.remove(this.strID);
        }
        super.setProperty(propertyName, value, bs);
    }

    String getId(int modelIndex) {
        return "mo_model" + this.viewer.getModelNumber(modelIndex);
    }

    Object getProperty(String propertyName, int param) {
        if (propertyName == "moNumber") {
            return this.moNumber == 0 ? null : new Integer(this.moNumber);
        }
        if (propertyName == "showMO") {
            int nOrb;
            StringBuffer str = new StringBuffer();
            String infoType = "jvxlFileData";
            Vector mos = (Vector)this.moData.get("mos");
            int n = nOrb = mos == null ? 0 : mos.size();
            if (nOrb == 0) {
                return "";
            }
            int thisMO = param;
            int currentMO = this.moNumber;
            if (currentMO == 0) {
                thisMO = 0;
            }
            int nTotal = thisMO > 0 ? 1 : nOrb;
            for (int i = 1; i <= nOrb; ++i) {
                if (thisMO != 0 && thisMO != i && (thisMO != Integer.MAX_VALUE || i != currentMO)) continue;
                super.setProperty("init", "mo_show", null);
                this.setOrbital(i);
                str.append(super.getProperty(infoType, nTotal));
                infoType = "jvxlSurfaceData";
                super.setProperty("delete", "mo_show", null);
            }
            return "" + str;
        }
        return null;
    }

    boolean getSettings(String strID) {
        this.thisModel = (Hashtable)this.htModels.get(strID);
        if (this.thisModel == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moPlane = (Point4f)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = new Float(0.05f);
        }
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        Object b = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = b != null && (Boolean)b != false;
        this.thisMesh = (Mesh)this.thisModel.get("mesh");
        return true;
    }

    void setOrbital(int moNumber) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("molecularOrbital", new Integer(moNumber), null);
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
        this.thisModel.put("mesh", this.currentMesh);
    }

    String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            s.append(this.getMoState(i));
        }
        return s.toString();
    }

    String getMoState(int modelIndex) {
        this.strID = this.getId(modelIndex);
        if (!this.getSettings(this.strID)) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        if (this.modelCount > 1) {
            Shape.appendCmd(s, "frame " + this.viewer.getModelNumber(modelIndex));
        }
        this.getSettings(this.strID);
        if (this.moCutoff != null) {
            Shape.appendCmd(s, "mo cutoff " + (this.isPositiveOnly ? "+" : "") + this.moCutoff);
        }
        if (this.moScale != null) {
            Shape.appendCmd(s, "mo scale " + this.moScale);
        }
        if (this.moResolution != null) {
            Shape.appendCmd(s, "mo resolution " + this.moResolution);
        }
        if (this.moPlane != null) {
            Shape.appendCmd(s, "mo plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}");
        }
        if (this.moTitleFormat != null) {
            Shape.appendCmd(s, "mo titleFormat " + StateManager.escape(this.moTitleFormat));
        }
        if (this.moColorNeg != null) {
            Shape.appendCmd(s, "mo color " + StateManager.escapeColor(this.moColorNeg) + (this.moColorNeg == this.moColorPos ? "" : " " + StateManager.escapeColor(this.moColorPos)));
        }
        Shape.appendCmd(s, "mo " + this.moNumber);
        Shape.appendCmd(s, this.getMeshState(this.currentMesh, "mo"));
        return s.toString();
    }
}

