/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Measurement;
import org.jmol.viewer.PendingMeasurement;
import org.jmol.viewer.Shape;
import org.jmol.viewer.StateManager;

class Measures
extends Shape {
    BitSet bsSizeSet;
    BitSet bsColixSet;
    BitSet bsSelected;
    static final int measurementGrowthIncrement = 16;
    int measurementCount = 0;
    Measurement[] measurements = new Measurement[16];
    PendingMeasurement pendingMeasurement;
    String[] formats = new String[5];
    short mad = (short)-1;
    short colix;
    String strFormat;
    boolean showMeasurementNumbers = true;
    boolean isAllConnected = false;
    Font3D font3d;
    float[] rangeMinMax = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};

    Measures() {
    }

    void initShape() {
        this.pendingMeasurement = new PendingMeasurement(this.frame);
        this.font3d = this.g3d.getFont3D(15);
    }

    void setSize(int size, BitSet bsSelected) {
        this.mad = (short)size;
    }

    void setProperty(String propertyName, Object value, BitSet bsIgnored) {
        if ("select".equals(propertyName)) {
            BitSet bs = (BitSet)value;
            if (bs == null || this.viewer.cardinalityOf(bs) == 0) {
                this.bsSelected = null;
            } else {
                this.bsSelected = new BitSet();
                this.bsSelected.or(bs);
            }
            return;
        }
        if ("color".equals(propertyName)) {
            short colix;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s = colix = value == null ? (short)0 : Graphics3D.getColix(value);
            if (this.bsSelected == null) {
                this.colix = colix;
            }
            for (int i = 0; i < this.measurements.length; ++i) {
                if (this.measurements[i] == null || (this.bsSelected == null || !this.bsSelected.get(i)) && (this.bsSelected != null || colix != 0 && this.measurements[i].colix != 0)) continue;
                this.measurements[i].colix = colix;
                this.bsColixSet.set(i);
            }
            return;
        }
        if ("delete".equals(propertyName)) {
            this.delete(value);
            this.setIndices();
            return;
        }
        if ("hideAll".equals(propertyName)) {
            this.showHide((Boolean)value);
            return;
        }
        if ("setFormats".equals(propertyName)) {
            this.setFormats((String)value);
            return;
        }
        this.bsSelected = null;
        if ("hide".equals(propertyName)) {
            this.showHide((int[])value, true);
        } else if ("show".equals(propertyName)) {
            this.showHide((int[])value, false);
        } else if ("setRange".equals(propertyName)) {
            this.setRange((float[])value);
        } else if ("setFormat".equals(propertyName)) {
            this.strFormat = (String)value;
        } else if ("setConnected".equals(propertyName)) {
            this.setConnected((Boolean)value);
        } else if ("defineVector".equals(propertyName)) {
            this.define((Vector)value, false, false, false);
        } else if ("deleteVector".equals(propertyName)) {
            this.define((Vector)value, true, false, false);
            this.setIndices();
        } else if ("hideVector".equals(propertyName)) {
            this.define((Vector)value, false, false, true);
        } else if ("showVector".equals(propertyName)) {
            this.define((Vector)value, false, true, false);
        } else if ("toggle".equals(propertyName)) {
            this.toggle((int[])value);
        } else if ("pending".equals(propertyName)) {
            this.pending((int[])value);
        } else if ("font".equals(propertyName)) {
            this.font3d = (Font3D)value;
        } else if ("clear".equals(propertyName)) {
            this.clear();
        } else if ("showMeasurementNumbers".equals(propertyName)) {
            this.showMeasurementNumbers = (Boolean)value;
        } else if ("reformatDistances".equals(propertyName)) {
            this.reformatDistances();
        }
    }

    Object getProperty(String property, int index) {
        if ("count".equals(property)) {
            return new Integer(this.measurementCount);
        }
        if ("countPlusIndices".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].countPlusIndices : null;
        }
        if ("stringValue".equals(property)) {
            return index < this.measurementCount ? this.measurements[index].strMeasurement : null;
        }
        if ("info".equals(property)) {
            return this.getAllInfo();
        }
        if ("infostring".equals(property)) {
            return this.getAllInfoAsString();
        }
        return null;
    }

    private void clear() {
        int countT = this.measurementCount;
        this.measurementCount = 0;
        int i = countT;
        while (--i >= 0) {
            this.measurements[i] = null;
        }
    }

    private int defined(int[] atomCountPlusIndices) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (!this.measurements[i].sameAs(atomCountPlusIndices)) continue;
            return i;
        }
        return -1;
    }

    private void toggle(int[] atomCountPlusIndices) {
        this.rangeMinMax[0] = Float.MAX_VALUE;
        int i = this.defined(atomCountPlusIndices);
        if (i >= 0 && !this.measurements[i].isHidden) {
            this.define(atomCountPlusIndices, true, false);
        } else {
            this.define(atomCountPlusIndices, false, true);
        }
        this.setIndices();
    }

    private void delete(Object value) {
        if (value instanceof int[]) {
            this.define((int[])value, true, false);
        } else if (value instanceof Integer) {
            this.define(this.measurements[((Integer)value).intValue()].countPlusIndices, true, false);
        }
    }

    private void define(Vector monitorExpressions, boolean isDelete, boolean isShow, boolean isHide) {
        int nPoints = monitorExpressions.size();
        if (nPoints < 2) {
            return;
        }
        boolean isOneToOne = true;
        for (int i = 0; i < nPoints && isOneToOne; ++i) {
            if (this.viewer.cardinalityOf((BitSet)monitorExpressions.get(i)) <= 1) continue;
            isOneToOne = false;
        }
        int[] atomCountPlusIndices = new int[5];
        atomCountPlusIndices[0] = nPoints;
        this.nextMeasure(0, nPoints, monitorExpressions, atomCountPlusIndices, isOneToOne ? -1 : 0, isDelete, isShow, isHide);
    }

    private void setIndices() {
        for (int i = 0; i < this.measurementCount; ++i) {
            this.measurements[i].setIndex(i);
        }
    }

    private void define(int[] atomCountPlusIndices, boolean isDelete, boolean isShow) {
        if (this.viewer.getMeasureAllModelsFlag()) {
            if (isShow) {
                this.define(atomCountPlusIndices, true, false);
                if (isDelete) {
                    return;
                }
            }
            Vector<BitSet> measureList = new Vector<BitSet>();
            int nPoints = atomCountPlusIndices[0];
            for (int i = 1; i <= nPoints; ++i) {
                Atom atom = this.frame.atoms[atomCountPlusIndices[i]];
                measureList.add(this.viewer.getAtomBits("atomno", atom.getAtomNumber()));
            }
            this.define(measureList, isDelete, false, false);
            return;
        }
        this.define(atomCountPlusIndices, isDelete);
    }

    private void define(int[] atomCountPlusIndices, boolean isDelete) {
        int i = this.defined(atomCountPlusIndices);
        int count = atomCountPlusIndices[0];
        if (i < 0 && isDelete || atomCountPlusIndices[1] == atomCountPlusIndices[2] || count > 2 && atomCountPlusIndices[1] == atomCountPlusIndices[3] || count == 4 && atomCountPlusIndices[2] == atomCountPlusIndices[4]) {
            return;
        }
        float value = this.frame.getMeasurement(atomCountPlusIndices);
        if (this.rangeMinMax[0] != Float.MAX_VALUE && (value < this.rangeMinMax[0] || value > this.rangeMinMax[1])) {
            return;
        }
        if (i >= 0) {
            if (isDelete) {
                this.viewer.setStatusNewDefaultModeMeasurement("measureDeleted", i, "");
                System.arraycopy(this.measurements, i + 1, this.measurements, i, this.measurementCount - i - 1);
                --this.measurementCount;
                this.measurements[this.measurementCount] = null;
            } else {
                this.measurements[i].isHidden = false;
            }
            return;
        }
        Measurement measureNew = new Measurement(this.frame, atomCountPlusIndices, value, this.colix, this.strFormat, this.measurementCount);
        if (this.measurementCount == this.measurements.length) {
            this.measurements = (Measurement[])ArrayUtil.setLength(this.measurements, this.measurementCount + 16);
        }
        this.viewer.setStatusNewDefaultModeMeasurement("measureCompleted", this.measurementCount, measureNew.toVector().toString());
        this.measurements[this.measurementCount++] = measureNew;
    }

    private void showHide(int[] atomCountPlusIndices, boolean isHide) {
        int i = this.defined(atomCountPlusIndices);
        if (i < 0) {
            return;
        }
        this.measurements[i].isHidden = isHide;
    }

    private void showHide(boolean isHide) {
        int i = this.measurementCount;
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            this.measurements[i].isHidden = isHide;
        }
    }

    private void nextMeasure(int thispt, int nPoints, Vector monitorExpressions, int[] atomCountPlusIndices, int thisModel, boolean isDelete, boolean isShow, boolean isHide) {
        BitSet bs = (BitSet)monitorExpressions.get(thispt);
        int iMax = this.frame.atomCount;
        for (int i = 0; i < iMax; ++i) {
            if (!bs.get(i) || thispt > 0 && i == atomCountPlusIndices[thispt]) continue;
            int modelIndex = this.frame.atoms[i].getModelIndex();
            if (thisModel >= 0) {
                if (thispt == 0) {
                    thisModel = modelIndex;
                } else if (thisModel != modelIndex) continue;
            }
            atomCountPlusIndices[thispt + 1] = i;
            if (thispt == nPoints - 1) {
                if (this.isAllConnected && !this.isConnected(atomCountPlusIndices)) continue;
                int iThis = this.defined(atomCountPlusIndices);
                if (iThis >= 0) {
                    if (isDelete) {
                        this.define(atomCountPlusIndices, true);
                        continue;
                    }
                    if (this.strFormat != null) {
                        this.measurements[iThis].formatMeasurement(this.strFormat);
                        continue;
                    }
                    this.showHide(atomCountPlusIndices, isHide);
                    continue;
                }
                if (isDelete || isHide || isShow) continue;
                this.define(atomCountPlusIndices, false);
                continue;
            }
            this.nextMeasure(thispt + 1, nPoints, monitorExpressions, atomCountPlusIndices, thisModel, isDelete, isShow, isHide);
        }
    }

    private boolean isConnected(int[] atomCountPlusIndices) {
        Atom[] atoms = this.frame.atoms;
        for (int i = atomCountPlusIndices[0]; i > 1; --i) {
            if (atoms[atomCountPlusIndices[i]].isBonded(atoms[atomCountPlusIndices[i - 1]])) continue;
            return false;
        }
        return true;
    }

    private void setRange(float[] rangeMinMax) {
        this.rangeMinMax[0] = rangeMinMax[0];
        this.rangeMinMax[1] = rangeMinMax[1];
    }

    private void setConnected(boolean isAllConnected) {
        this.isAllConnected = isAllConnected;
    }

    private void pending(int[] countPlusIndices) {
        this.pendingMeasurement.setCountPlusIndices(countPlusIndices);
        if (this.pendingMeasurement.count > 1) {
            this.viewer.setStatusNewDefaultModeMeasurement("measurePending", this.pendingMeasurement.count, this.pendingMeasurement.strMeasurement);
        }
    }

    private void reformatDistances() {
        int i = this.measurementCount;
        while (--i >= 0) {
            this.measurements[i].reformatDistanceIfSelected();
        }
    }

    private void setFormats(String format) {
        if (format != null && format.length() == 0) {
            format = null;
        }
        int i = this.measurementCount;
        while (--i >= 0) {
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            this.measurements[i].formatMeasurement(format);
        }
    }

    private Vector getAllInfo() {
        Vector<Hashtable> info = new Vector<Hashtable>();
        for (int i = 0; i < this.measurementCount; ++i) {
            info.add(this.getInfo(i));
        }
        return info;
    }

    private String getAllInfoAsString() {
        String info = "Measurement Information";
        for (int i = 0; i < this.measurementCount; ++i) {
            info = info + "\n" + this.getInfoAsString(i);
        }
        return info;
    }

    private Hashtable getInfo(int index) {
        int count = this.measurements[index].count;
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        info.put("index", new Integer(index));
        info.put("type", count == 2 ? "distance" : (count == 3 ? "angle" : "dihedral"));
        info.put("strMeasurement", this.measurements[index].strMeasurement);
        info.put("count", new Integer(count));
        info.put("value", new Float(this.measurements[index].value));
        Vector atomsInfo = new Vector();
        for (int i = 0; i < count; ++i) {
            Hashtable<String, Object> atomInfo = new Hashtable<String, Object>();
            Atom atom = this.frame.atoms[this.measurements[index].countPlusIndices[i + 1]];
            atomInfo.put("_ipt", new Integer(atom.atomIndex));
            atomInfo.put("atomno", new Integer(atom.getAtomNumber()));
            atomInfo.put("info", atom.getInfo());
            atomsInfo.add(atomInfo);
        }
        info.put("atoms", atomsInfo);
        return info;
    }

    private String getInfoAsString(int index) {
        int count = this.measurements[index].count;
        String info = (count == 2 ? "distance" : (count == 3 ? "angle" : "dihedral")) + " \t" + this.measurements[index].value + " \t" + this.measurements[index].strMeasurement;
        for (int i = 0; i < count; ++i) {
            Atom atom = this.frame.atoms[this.measurements[index].countPlusIndices[i + 1]];
            info = info + " \t" + atom.getInfo();
        }
        return info;
    }

    void setVisibilityInfo() {
        int i = this.measurementCount;
        block0: while (--i >= 0) {
            this.measurements[i].isVisible = false;
            if (this.mad == 0 || this.measurements[i].isHidden) continue;
            for (int iAtom = this.measurements[i].count; iAtom > 0; --iAtom) {
                Atom atom = this.frame.getAtomAt(this.measurements[i].countPlusIndices[iAtom]);
                if (!atom.isClickable()) continue block0;
            }
            this.measurements[i].isVisible = true;
        }
    }

    String getShapeState() {
        String s;
        int i;
        StringBuffer commands = new StringBuffer();
        for (int i2 = 0; i2 < this.measurementCount; ++i2) {
            commands.append(this.getState(i2));
        }
        if (!this.showMeasurementNumbers) {
            commands.append("set measures off; # numbers off\n");
        }
        Shape.appendCmd(commands, "set measures " + this.viewer.getMeasureDistanceUnits());
        Shape.appendCmd(commands, Shape.getFontCommand("measures", this.font3d));
        int n = 0;
        Hashtable temp = new Hashtable();
        BitSet bs = new BitSet(this.measurementCount);
        for (i = 0; i < this.measurementCount; ++i) {
            if (this.measurements[i].isHidden) {
                ++n;
                bs.set(i);
            }
            if (this.bsColixSet != null && this.bsColixSet.get(i)) {
                Shape.setStateInfo(temp, i, this.getColorCommand("measure", this.measurements[i].colix));
            }
            if (this.measurements[i].strFormat == null) continue;
            Shape.setStateInfo(temp, i, "measure " + StateManager.escape(this.measurements[i].strFormat));
        }
        if (n > 0) {
            if (n == this.measurementCount) {
                commands.append("measures off; # lines and numbers off\n");
            } else {
                for (i = 0; i < this.measurementCount; ++i) {
                    if (!this.measurements[i].isHidden) continue;
                    Shape.setStateInfo(temp, i, "measure off");
                }
            }
        }
        if ((s = Shape.getShapeCommands(temp, null, -1, "select measures")) != null) {
            commands.append(s);
            Shape.appendCmd(commands, "select measures ({null})");
        }
        return commands.toString();
    }

    private String getState(int index) {
        int count = this.measurements[index].count;
        String info = "measure";
        for (int i = 0; i < count; ++i) {
            info = info + "({" + this.measurements[index].countPlusIndices[i + 1] + "})";
        }
        info = info + "; # " + this.getInfoAsString(index) + "\n";
        return info;
    }
}

