/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Isosurface;

class LcaoCartoon
extends Isosurface {
    Integer lcaoColorPos = null;
    Integer lcaoColorNeg = null;
    String thisType;
    Float lcaoScale = null;
    int myColorPt;
    String lcaoID;
    BitSet thisSet = null;
    boolean isMolecular;

    LcaoCartoon() {
    }

    void initShape() {
        super.initShape();
        this.myType = "lcaoCartoon";
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("\nLcaoCartoon.setProperty " + propertyName + " " + value);
        if ("init" == propertyName) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bs;
            this.isMolecular = false;
            this.thisType = null;
            this.lcaoScale = null;
            super.setProperty("init", null, null);
            return;
        }
        if ("molecular" == propertyName) {
            this.isMolecular = this.thisType != null && (this.thisType.indexOf("px") >= 0 || this.thisType.indexOf("py") >= 0 || this.thisType.indexOf("pz") >= 0);
            return;
        }
        if ("on" == propertyName) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == propertyName) {
            this.setLcaoOn(false);
            return;
        }
        if ("delete" == propertyName) {
            this.deleteLcaoCartoon();
            return;
        }
        if ("lcaoID" == propertyName) {
            this.lcaoID = (String)value;
            return;
        }
        if ("selectType" == propertyName) {
            this.thisType = (String)value;
            return;
        }
        if ("create" == propertyName) {
            this.thisType = (String)value;
            this.createLcaoCartoon();
            return;
        }
        if ("scale" == propertyName) {
            this.lcaoScale = (Float)value;
        }
        if ("colorRGB" == propertyName) {
            this.lcaoColorPos = (Integer)value;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
        }
        if ("select" == propertyName) {
            this.thisSet = (BitSet)value;
        }
        super.setProperty(propertyName, value, bs);
    }

    void setLcaoOn(boolean TF) {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.setLcaoOn(i, TF);
        }
    }

    void setLcaoOn(int iAtom, boolean TF) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.meshes[i].visible = TF;
        }
    }

    void deleteLcaoCartoon() {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.deleteLcaoCartoon(i);
        }
    }

    void deleteLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
    }

    void createLcaoCartoon() {
        int atomCount;
        int i = atomCount = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!this.thisSet.get(i)) continue;
            this.createLcaoCartoon(i);
        }
    }

    void createLcaoCartoon(int iAtom) {
        String id = this.getID(this.lcaoID, iAtom);
        int i = this.meshCount;
        while (--i >= 0) {
            if (this.meshes[i].thisID.indexOf(id) != 0) continue;
            this.deleteMesh(i);
        }
        super.setProperty("init", null, null);
        super.setProperty("thisID", id, null);
        if (this.lcaoScale != null) {
            super.setProperty("scale", this.lcaoScale, null);
        }
        if (this.lcaoColorNeg != null) {
            super.setProperty("colorRGB", this.lcaoColorNeg, null);
            super.setProperty("colorRGB", this.lcaoColorPos, null);
        }
        super.setProperty("lcaoType", this.thisType, null);
        super.setProperty("atomIndex", new Integer(iAtom), null);
        Vector3f[] axes = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(this.frame.atoms[iAtom])};
        if (this.isMolecular) {
            if (this.thisType.indexOf("px") >= 0) {
                axes[0].set(0.0f, -1.0f, 0.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            } else if (this.thisType.indexOf("py") >= 0) {
                axes[0].set(-1.0f, 0.0f, 0.0f);
                axes[1].set(0.0f, 0.0f, 1.0f);
            } else if (this.thisType.indexOf("pz") >= 0) {
                axes[0].set(0.0f, 0.0f, 1.0f);
                axes[1].set(1.0f, 0.0f, 0.0f);
            }
            if (this.isMolecular && this.thisType.indexOf("-") == 0) {
                axes[0].scale(-1.0f);
            }
        }
        if (this.isMolecular || this.thisType.equalsIgnoreCase("s") || this.viewer.getPrincipalAxes(iAtom, axes[0], axes[1], this.thisType, true)) {
            super.setProperty("lcaoCartoon", axes, null);
        }
    }

    String getID(String id, int i) {
        return (id != null ? id : "lcao_" + (i + 1)) + (this.thisType == null ? "" : this.viewer.simpleReplace(this.thisType, "-", this.thisType.indexOf("-p") == 0 ? "" : "_"));
    }
}

