/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.quantum.MepCalculation;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.MeshCollection;
import org.jmol.viewer.StateManager;

class Isosurface
extends MeshCollection {
    boolean logMessages = false;
    boolean logCompression = false;
    boolean logCube = false;
    static final boolean colorByContourOnly = false;
    int state;
    static final int STATE_INITIALIZED = 1;
    static final int STATE_DATA_READ = 2;
    static final int STATE_DATA_COLORED = 3;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final int defaultEdgeFractionBase = 35;
    static final int defaultEdgeFractionRange = 90;
    static final int defaultColorFractionBase = 35;
    static final int defaultColorFractionRange = 90;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    static final float defaultMepCutoff = 0.05f;
    static final float defaultMepMin = -0.05f;
    static final float defaultMepMax = 0.05f;
    static final float defaultOrbitalCutoff = 0.14f;
    static final float defaultQMOrbitalCutoff = 0.05f;
    static final int defaultContourCount = 11;
    static final int nContourMax = 100;
    static final int defaultColorNegative = Graphics3D.getArgbFromString("red");
    static final int defaultColorPositive = Graphics3D.getArgbFromString("blue");
    static final int defaultColorNegativeLCAO = Graphics3D.getArgbFromString("purple");
    static final int defaultColorPositiveLCAO = Graphics3D.getArgbFromString("orange");
    static final float defaultSolventRadius = 1.2f;
    boolean blockCubeData;
    int nSurfaces;
    String[] title = null;
    String colorScheme;
    short defaultColix;
    boolean colorBySign;
    int colorNeg;
    int colorPos;
    int colorPosLCAO;
    int colorNegLCAO;
    int colorPtr;
    boolean colorByPhase;
    int colorPhase;
    float resolution;
    boolean insideOut;
    float[] mepCharges;
    int qmOrbitalType;
    int qmOrbitalCount;
    static final int QM_TYPE_UNKNOWN = 0;
    static final int QM_TYPE_GAUSSIAN = 1;
    static final int QM_TYPE_SLATER = 2;
    Hashtable moData;
    float[] moCoefficients;
    boolean precalculateVoxelData;
    Vector functionXYinfo;
    String lcaoType;
    boolean isAnisotropic;
    boolean isEccentric;
    float eccentricityScale;
    float eccentricityRatio;
    boolean isAngstroms;
    float scale;
    Matrix3f eccentricityMatrix;
    Matrix3f eccentricityMatrixInverse;
    int atomIndex;
    static final int NO_ANISOTROPY = 32;
    static final int IS_SILENT = 64;
    static final int IS_SOLVENTTYPE = 128;
    static final int HAS_MAXGRID = 256;
    int dataType;
    int surfaceType;
    int mappingType;
    static final int SURFACE_NONE = 0;
    static final int SURFACE_SPHERE = 65;
    static final int SURFACE_ELLIPSOID = 66;
    static final int SURFACE_LOBE = 67;
    static final int SURFACE_LCAOCARTOON = 68;
    static final int SURFACE_FUNCTIONXY = 5;
    static final int SURFACE_SOLVENT = 171;
    static final int SURFACE_SASURFACE = 172;
    static final int SURFACE_MOLECULARORBITAL = 301;
    static final int SURFACE_ATOMICORBITAL = 14;
    static final int SURFACE_MEP = 304;
    static final int SURFACE_FILE = 17;
    static final int SURFACE_INFO = 18;
    static final int SURFACE_MOLECULAR = 179;
    static final int SURFACE_NOMAP = 180;
    float solventRadius;
    float solventExtendedAtomRadius;
    float solventAtomRadiusFactor;
    float solventAtomRadiusAbsolute;
    float solventAtomRadiusOffset;
    boolean useIonic;
    boolean addHydrogens;
    int edgeFractionBase;
    int edgeFractionRange;
    int colorFractionBase;
    int colorFractionRange;
    float mappedDataMin;
    float mappedDataMax;
    float[] anisotropy = new float[3];
    final Point3f volumetricOrigin = new Point3f();
    final Vector3f[] volumetricVectors = new Vector3f[3];
    final Vector3f[] unitVolumetricVectors = new Vector3f[3];
    final float[] volumetricVectorLengths;
    final int[] voxelCounts;
    final Matrix3f volumetricMatrix;
    float[][][] voxelData;
    int fileIndex;
    float cutoff;
    int nContours;
    int thisContour;
    boolean rangeDefined;
    float valueMappedToRed;
    float valueMappedToBlue;
    boolean iAddGridPoints;
    boolean associateNormals;
    boolean newSolventMethod;
    boolean force2SidedTriangles;
    boolean isColorReversed;
    Point3f center;
    Point4f thePlane;
    boolean isContoured;
    boolean isBicolorMap;
    boolean isCutoffAbsolute;
    boolean isPositiveOnly;
    boolean isSilent;
    BufferedReader br;
    Hashtable surfaceInfo;
    BitSet bsSelected;
    BitSet bsIgnore;
    boolean iHaveBitSets;
    boolean iUseBitSets;
    boolean isJvxl;
    boolean endOfData;
    int indexColorPositive;
    int indexColorNegative;
    StringBuffer jvxlFileHeader;
    String jvxlFileMessage;
    String jvxlEdgeDataRead;
    String jvxlColorDataRead;
    int atomCount;
    boolean negativeAtomCount;
    int nBytes;
    int nDataPoints;
    String surfaceData;
    int nPointsX;
    int nPointsY;
    int nPointsZ;
    final Vector3f thePlaneNormal;
    float thePlaneNormalMag;
    final Point3f ptXyzTemp;
    int jvxlSurfaceDataCount;
    int jvxlEdgeDataCount;
    int jvxlColorDataCount;
    boolean jvxlDataIsColorMapped;
    boolean jvxlDataisBicolorMap;
    boolean jvxlDataIsPrecisionColor;
    boolean jvxlWritePrecisionColor;
    boolean jvxlDataIs2dContour;
    float jvxlCutoff;
    int nThisValue;
    boolean thisInside;
    Hashtable assocGridPointMap;
    Hashtable assocGridPointNormals;
    String remainderString;
    static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};
    final Vector3f pointVector;
    float contourPlaneMinimumValue;
    float contourPlaneMaximumValue;
    int fractionPtr;
    String strFractionTemp;
    StringBuffer fractionData;
    char remainder;
    final float[] vertexValues;
    final Point3i[] vertexPoints;
    final Point3f[] surfacePoints;
    final int[] surfacePointIndexes;
    int cubeCountX;
    int cubeCountY;
    int cubeCountZ;
    int contourType;
    final int[] nullNeighbor;
    int firstCriticalVertex;
    int lastCriticalVertex;
    int edgeCount;
    static final float assocCutoff = 0.3f;
    final Point3f voxelOrigin;
    final Point3f voxelT;
    final Point3f pointA;
    final Point3f pointB;
    final Vector3f edgeVector;
    float thisValue;
    static final Point3i[] cubeVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 0, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 0), new Point3i(1, 1, 0), new Point3i(1, 1, 1), new Point3i(0, 1, 1)};
    static final Vector3f[] cubeVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)};
    Vector3f[] voxelVertexVectors;
    static final int[] edgeTypeTable = new int[]{0, 2, 0, 2, 0, 2, 0, 2, 1, 1, 1, 1};
    static final byte[] edgeVertexes = new byte[]{0, 1, 1, 2, 2, 3, 3, 0, 4, 5, 5, 6, 6, 7, 7, 4, 0, 4, 1, 5, 2, 6, 3, 7};
    static final short[] insideMaskTable = new short[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};
    static final byte[][] triangleTable = new byte[][]{null, {0, 8, 3}, {0, 1, 9}, {1, 8, 3, 9, 8, 1}, {1, 2, 10}, {0, 8, 3, 1, 2, 10}, {9, 2, 10, 0, 2, 9}, {2, 8, 3, 2, 10, 8, 10, 9, 8}, {3, 11, 2}, {0, 11, 2, 8, 11, 0}, {1, 9, 0, 2, 3, 11}, {1, 11, 2, 1, 9, 11, 9, 8, 11}, {3, 10, 1, 11, 10, 3}, {0, 10, 1, 0, 8, 10, 8, 11, 10}, {3, 9, 0, 3, 11, 9, 11, 10, 9}, {9, 8, 10, 10, 8, 11}, {4, 7, 8}, {4, 3, 0, 7, 3, 4}, {0, 1, 9, 8, 4, 7}, {4, 1, 9, 4, 7, 1, 7, 3, 1}, {1, 2, 10, 8, 4, 7}, {3, 4, 7, 3, 0, 4, 1, 2, 10}, {9, 2, 10, 9, 0, 2, 8, 4, 7}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4}, {8, 4, 7, 3, 11, 2}, {11, 4, 7, 11, 2, 4, 2, 0, 4}, {9, 0, 1, 8, 4, 7, 2, 3, 11}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1}, {3, 10, 1, 3, 11, 10, 7, 8, 4}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3}, {4, 7, 11, 4, 11, 9, 9, 11, 10}, {9, 5, 4}, {9, 5, 4, 0, 8, 3}, {0, 5, 4, 1, 5, 0}, {8, 5, 4, 8, 3, 5, 3, 1, 5}, {1, 2, 10, 9, 5, 4}, {3, 0, 8, 1, 2, 10, 4, 9, 5}, {5, 2, 10, 5, 4, 2, 4, 0, 2}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8}, {9, 5, 4, 2, 3, 11}, {0, 11, 2, 0, 8, 11, 4, 9, 5}, {0, 5, 4, 0, 1, 5, 2, 3, 11}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5}, {10, 3, 11, 10, 1, 3, 9, 5, 4}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3}, {5, 4, 8, 5, 8, 10, 10, 8, 11}, {9, 7, 8, 5, 7, 9}, {9, 3, 0, 9, 5, 3, 5, 7, 3}, {0, 7, 8, 0, 1, 7, 1, 5, 7}, {1, 5, 3, 3, 5, 7}, {9, 7, 8, 9, 5, 7, 10, 1, 2}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2}, {2, 10, 5, 2, 5, 3, 3, 5, 7}, {7, 9, 5, 7, 8, 9, 3, 11, 2}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7}, {11, 2, 1, 11, 1, 7, 7, 1, 5}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0}, {11, 10, 5, 7, 11, 5}, {10, 6, 5}, {0, 8, 3, 5, 10, 6}, {9, 0, 1, 5, 10, 6}, {1, 8, 3, 1, 9, 8, 5, 10, 6}, {1, 6, 5, 2, 6, 1}, {1, 6, 5, 1, 2, 6, 3, 0, 8}, {9, 6, 5, 9, 0, 6, 0, 2, 6}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8}, {2, 3, 11, 10, 6, 5}, {11, 0, 8, 11, 2, 0, 10, 6, 5}, {0, 1, 9, 2, 3, 11, 5, 10, 6}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11}, {6, 3, 11, 6, 5, 3, 5, 1, 3}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9}, {6, 5, 9, 6, 9, 11, 11, 9, 8}, {5, 10, 6, 4, 7, 8}, {4, 3, 0, 4, 7, 3, 6, 5, 10}, {1, 9, 0, 5, 10, 6, 8, 4, 7}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4}, {6, 1, 2, 6, 5, 1, 4, 7, 8}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9}, {3, 11, 2, 7, 8, 4, 10, 6, 5}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9}, {10, 4, 9, 6, 4, 10}, {4, 10, 6, 4, 9, 10, 0, 8, 3}, {10, 0, 1, 10, 6, 0, 6, 4, 0}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10}, {1, 4, 9, 1, 2, 4, 2, 6, 4}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4}, {0, 2, 4, 4, 2, 6}, {8, 3, 2, 8, 2, 4, 4, 2, 6}, {10, 4, 9, 10, 6, 4, 11, 2, 3}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1}, {3, 11, 6, 3, 6, 0, 0, 6, 4}, {6, 4, 8, 11, 6, 8}, {7, 10, 6, 7, 8, 10, 8, 9, 10}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0}, {10, 6, 7, 10, 7, 1, 1, 7, 3}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9}, {7, 8, 0, 7, 0, 6, 6, 0, 2}, {7, 3, 2, 6, 7, 2}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6}, {0, 9, 1, 11, 6, 7}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0}, {7, 11, 6}, {7, 6, 11}, {3, 0, 8, 11, 7, 6}, {0, 1, 9, 11, 7, 6}, {8, 1, 9, 8, 3, 1, 11, 7, 6}, {10, 1, 2, 6, 11, 7}, {1, 2, 10, 3, 0, 8, 6, 11, 7}, {2, 9, 0, 2, 10, 9, 6, 11, 7}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8}, {7, 2, 3, 6, 2, 7}, {7, 0, 8, 7, 6, 0, 6, 2, 0}, {2, 7, 6, 2, 3, 7, 0, 1, 9}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6}, {10, 7, 6, 10, 1, 7, 1, 3, 7}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7}, {7, 6, 10, 7, 10, 8, 8, 10, 9}, {6, 8, 4, 11, 8, 6}, {3, 6, 11, 3, 0, 6, 0, 4, 6}, {8, 6, 11, 8, 4, 6, 9, 0, 1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6}, {6, 8, 4, 6, 11, 8, 2, 10, 1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3}, {8, 2, 3, 8, 4, 2, 4, 6, 2}, {0, 4, 2, 4, 6, 2}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8}, {1, 9, 4, 1, 4, 2, 2, 4, 6}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1}, {10, 1, 0, 10, 0, 6, 6, 0, 4}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3}, {10, 9, 4, 6, 10, 4}, {4, 9, 5, 7, 6, 11}, {0, 8, 3, 4, 9, 5, 11, 7, 6}, {5, 0, 1, 5, 4, 0, 7, 6, 11}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5}, {9, 5, 4, 10, 1, 2, 7, 6, 11}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6}, {7, 2, 3, 7, 6, 2, 5, 4, 9}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10}, {6, 9, 5, 6, 11, 9, 11, 8, 9}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11}, {6, 11, 3, 6, 3, 5, 5, 3, 1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2}, {9, 5, 6, 9, 6, 0, 0, 6, 2}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8}, {1, 5, 6, 2, 1, 6}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0}, {0, 3, 8, 5, 6, 10}, {10, 5, 6}, {11, 5, 10, 7, 5, 11}, {11, 5, 10, 11, 7, 5, 8, 3, 0}, {5, 11, 7, 5, 10, 11, 1, 9, 0}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1}, {11, 1, 2, 11, 7, 1, 7, 5, 1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2}, {2, 5, 10, 2, 3, 5, 3, 7, 5}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2}, {1, 3, 5, 3, 7, 5}, {0, 8, 7, 0, 7, 1, 1, 7, 5}, {9, 0, 3, 9, 3, 5, 5, 3, 7}, {9, 8, 7, 5, 9, 7}, {5, 8, 4, 5, 10, 8, 10, 11, 8}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5}, {9, 4, 5, 2, 11, 3}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4}, {5, 10, 2, 5, 2, 4, 4, 2, 0}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2}, {8, 4, 5, 8, 5, 3, 3, 5, 1}, {0, 4, 5, 1, 0, 5}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5}, {9, 4, 5}, {4, 11, 7, 4, 9, 11, 9, 10, 11}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3}, {11, 7, 4, 11, 4, 2, 2, 4, 0}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10}, {1, 10, 2, 8, 7, 4}, {4, 9, 1, 4, 1, 7, 7, 1, 3}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1}, {4, 0, 3, 7, 4, 3}, {4, 8, 7}, {9, 10, 8, 10, 11, 8}, {3, 0, 9, 3, 9, 11, 11, 9, 10}, {0, 1, 10, 0, 10, 8, 8, 10, 11}, {3, 1, 10, 11, 3, 10}, {1, 2, 11, 1, 11, 9, 9, 11, 8}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9}, {0, 2, 11, 8, 0, 11}, {3, 2, 11}, {2, 3, 8, 2, 8, 10, 10, 8, 9}, {9, 10, 2, 0, 9, 2}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8}, {1, 10, 2}, {1, 3, 8, 9, 1, 8}, {0, 9, 1}, {0, 3, 8}, null};
    final Point3f planarOrigin;
    final Vector3f[] planarVectors;
    final Vector3f[] unitPlanarVectors;
    final float[] planarVectorLengths;
    final Matrix3f matXyzToPlane;
    int contourVertexCount;
    ContourVertex[] contourVertexes;
    final int[] pixelCounts;
    final Matrix3f planarMatrix;
    float[][] pixelData;
    final float[] vertexValues2d;
    final Point3f[] contourPoints;
    final int[] contourPointIndexes;
    int squareCountX;
    int squareCountY;
    PlanarSquare[] planarSquares;
    int nSquares;
    int contourIndex;
    final int[] nullNeighbor2d;
    final Point3f pixelOrigin;
    final Point3f pixelT;
    Vector3f[] pixelVertexVectors;
    final int[] triangleVertexList;
    static final Point3i[] squareVertexOffsets = new Point3i[]{new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(0, 1, 0)};
    static final Vector3f[] squareVertexVectors = new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
    static final byte[] edgeVertexes2d = new byte[]{0, 1, 1, 2, 2, 3, 3, 0};
    static final byte[] insideMaskTable2d = new byte[]{0, 9, 3, 10, 6, 15, 5, 12, 12, 5, 15, 6, 10, 3, 9, 0};
    final Point3i ptiTemp;
    float[] fact;
    int sphere_gridMax;
    float sphere_ptsPerAngstrom;
    float sphere_radiusAngstroms;
    int psi_gridMax;
    float psi_ptsPerAngstrom;
    float psi_radiusAngstroms;
    double[] rfactor;
    double[] pfactor;
    int lastFactorial;
    static final double A0 = (double)0.52918f;
    static final double ROOT2 = 1.414214;
    int psi_n;
    int psi_l;
    int psi_m;
    float psi_Znuc;
    final Point3f ptPsi;
    float lobe_sizeAngstroms;
    int lobe_gridMax;
    int lobe_ptsPerAngstrom;
    int qm_gridMax;
    float qm_ptsPerAngstrom;
    float qm_marginAngstroms;
    int qm_nAtoms;
    int qm_moNumber;
    Atom[] qm_atoms;
    int mep_gridMax;
    float mep_ptsPerAngstrom;
    float mep_marginAngstroms;
    int mep_nAtoms;
    Atom[] mep_atoms;
    float solvent_ptsPerAngstrom;
    int solvent_gridMax;
    int solvent_modelIndex;
    float[] solvent_atomRadius;
    Point3f[] solvent_ptAtom;
    int solvent_nAtoms;
    int solvent_firstNearbyAtom;
    boolean solvent_quickPlane;
    BitSet atomSet;
    BitSet bsSolventSelected;
    Voxel solvent_voxel;
    final Point3f ptS;
    float[][][] tempVoxelData;
    String functionName;
    int nLCAO;
    Point4f lcaoDir;
    BitSet[] surfaceSet;
    int nSets;
    boolean setsSuccessful;

    Isosurface() {
        this.volumetricVectors[0] = new Vector3f();
        this.volumetricVectors[1] = new Vector3f();
        this.volumetricVectors[2] = new Vector3f();
        this.unitVolumetricVectors[0] = new Vector3f();
        this.unitVolumetricVectors[1] = new Vector3f();
        this.unitVolumetricVectors[2] = new Vector3f();
        this.volumetricVectorLengths = new float[3];
        this.voxelCounts = new int[3];
        this.volumetricMatrix = new Matrix3f();
        this.cutoff = Float.MAX_VALUE;
        this.jvxlFileHeader = new StringBuffer();
        this.thePlaneNormal = new Vector3f();
        this.ptXyzTemp = new Point3f();
        this.pointVector = new Vector3f();
        this.strFractionTemp = "";
        this.fractionData = new StringBuffer();
        this.vertexValues = new float[8];
        this.vertexPoints = new Point3i[8];
        this.surfacePoints = new Point3f[12];
        int i = 12;
        while (--i >= 0) {
            this.surfacePoints[i] = new Point3f();
        }
        i = 8;
        while (--i >= 0) {
            this.vertexPoints[i] = new Point3i();
        }
        this.surfacePointIndexes = new int[12];
        this.nullNeighbor = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.voxelOrigin = new Point3f();
        this.voxelT = new Point3f();
        this.pointA = new Point3f();
        this.pointB = new Point3f();
        this.edgeVector = new Vector3f();
        this.voxelVertexVectors = new Vector3f[8];
        this.planarOrigin = new Point3f();
        this.planarVectors = new Vector3f[3];
        this.unitPlanarVectors = new Vector3f[3];
        this.planarVectorLengths = new float[2];
        this.matXyzToPlane = new Matrix3f();
        this.planarVectors[0] = new Vector3f();
        this.planarVectors[1] = new Vector3f();
        this.planarVectors[2] = new Vector3f();
        this.unitPlanarVectors[0] = new Vector3f();
        this.unitPlanarVectors[1] = new Vector3f();
        this.unitPlanarVectors[2] = new Vector3f();
        this.pixelCounts = new int[2];
        this.planarMatrix = new Matrix3f();
        this.vertexValues2d = new float[4];
        this.contourPoints = new Point3f[4];
        i = 4;
        while (--i >= 0) {
            this.contourPoints[i] = new Point3f();
        }
        this.contourPointIndexes = new int[4];
        this.nullNeighbor2d = new int[]{-1, -1, -1, -1};
        this.pixelOrigin = new Point3f();
        this.pixelT = new Point3f();
        this.pixelVertexVectors = new Vector3f[4];
        this.triangleVertexList = new int[20];
        this.ptiTemp = new Point3i();
        this.fact = new float[20];
        this.sphere_gridMax = 20;
        this.sphere_ptsPerAngstrom = 10.0f;
        this.psi_gridMax = 40;
        this.psi_ptsPerAngstrom = 5.0f;
        this.rfactor = new double[10];
        this.pfactor = new double[10];
        this.lastFactorial = -1;
        this.psi_n = 2;
        this.psi_l = 1;
        this.psi_m = 1;
        this.psi_Znuc = 1.0f;
        this.ptPsi = new Point3f();
        this.lobe_sizeAngstroms = 1.0f;
        this.lobe_gridMax = 21;
        this.lobe_ptsPerAngstrom = 10;
        this.qm_gridMax = QuantumCalculation.MAX_GRID;
        this.qm_ptsPerAngstrom = 10.0f;
        this.qm_marginAngstroms = 1.0f;
        this.qm_moNumber = Integer.MAX_VALUE;
        this.mep_gridMax = MepCalculation.MAX_GRID;
        this.mep_ptsPerAngstrom = 3.0f;
        this.mep_marginAngstroms = 1.0f;
        this.solvent_ptsPerAngstrom = 4.0f;
        this.solvent_gridMax = 60;
        this.atomSet = new BitSet();
        this.solvent_voxel = new Voxel();
        this.ptS = new Point3f();
        this.nLCAO = 0;
        this.lcaoDir = new Point4f();
        this.nSets = 0;
    }

    void initShape() {
        super.initShape();
        this.myType = "isosurface";
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Point4f v;
        Logger.debug("Isosurface state=" + this.state + " setProperty: " + propertyName + " = " + value);
        if ("init" == propertyName) {
            this.script = (String)value;
            this.initializeIsosurface();
            this.iHaveBitSets = this.getScriptBitSets();
            if (!this.iHaveBitSets) {
                this.bsSelected = bs;
            }
            super.setProperty("thisID", null, null);
            return;
        }
        if ("title" == propertyName) {
            if (value == null) {
                this.title = null;
                return;
            }
            if (value instanceof String[]) {
                this.title = (String[])value;
            } else {
                int nLine = 1;
                String lines = (String)value;
                int i = lines.length();
                while (--i >= 0) {
                    if (lines.charAt(i) != '|') continue;
                    ++nLine;
                }
                this.title = new String[nLine];
                nLine = 0;
                int i0 = -1;
                for (int i2 = 0; i2 < lines.length(); ++i2) {
                    if (lines.charAt(i2) != '|') continue;
                    this.title[nLine++] = lines.substring(i0 + 1, i2);
                    i0 = i2;
                }
                this.title[nLine] = lines.substring(i0 + 1);
            }
            for (int i = 0; i < this.title.length; ++i) {
                if (this.title[i].length() <= 0) continue;
                Logger.info("TITLE " + this.title[i]);
            }
            return;
        }
        if ("debug" == propertyName) {
            boolean TF;
            this.logMessages = TF = ((Boolean)value).booleanValue();
            this.logCube = TF;
            return;
        }
        if ("blockData" == propertyName) {
            boolean TF;
            this.blockCubeData = TF = ((Boolean)value).booleanValue();
            return;
        }
        if ("select" == propertyName) {
            if (!this.iHaveBitSets) {
                this.bsSelected = (BitSet)value;
            }
            return;
        }
        if ("ignore" == propertyName) {
            if (!this.iHaveBitSets) {
                this.bsIgnore = (BitSet)value;
            }
            return;
        }
        if ("cutoff" == propertyName) {
            this.cutoff = ((Float)value).floatValue();
            this.isPositiveOnly = false;
            return;
        }
        if ("cutoffPositive" == propertyName) {
            this.cutoff = ((Float)value).floatValue();
            this.isPositiveOnly = true;
            return;
        }
        if ("scale" == propertyName) {
            this.scale = ((Float)value).floatValue();
            return;
        }
        if ("angstroms" == propertyName) {
            this.isAngstroms = true;
            return;
        }
        if ("center" == propertyName) {
            this.center.set((Point3f)value);
            return;
        }
        if ("resolution" == propertyName) {
            this.resolution = ((Float)value).floatValue();
            if (this.resolution == 0.0f) {
                this.resolution = this.getDefaultResolution();
            }
            return;
        }
        if ("anisotropy" == propertyName) {
            if ((this.dataType & 0x20) != 0) {
                return;
            }
            Point3f pt = (Point3f)value;
            this.anisotropy[0] = pt.x;
            this.anisotropy[1] = pt.y;
            this.anisotropy[2] = pt.z;
            this.isAnisotropic = true;
            return;
        }
        if ("eccentricity" == propertyName) {
            this.setEccentricity((Point4f)value);
            return;
        }
        if ("addHydrogens" == propertyName) {
            this.addHydrogens = (Boolean)value;
            return;
        }
        if ("gridPoints" == propertyName) {
            this.iAddGridPoints = true;
            return;
        }
        if ("fixed" == propertyName) {
            this.isFixed = (Boolean)value;
            this.setModelIndex();
            return;
        }
        if ("atomIndex" == propertyName) {
            this.atomIndex = (Integer)value;
            return;
        }
        if ("fileIndex" == propertyName) {
            this.fileIndex = (Integer)value;
            if (this.fileIndex < 1) {
                this.fileIndex = 1;
            }
            return;
        }
        if ("insideOut" == propertyName) {
            this.insideOut = true;
            return;
        }
        if ("remappable" == propertyName) {
            this.jvxlWritePrecisionColor = true;
            return;
        }
        if ("sign" == propertyName) {
            this.isCutoffAbsolute = true;
            this.colorBySign = true;
            this.colorPtr = 0;
            return;
        }
        if ("colorRGB" == propertyName) {
            int rgb;
            this.colorPos = this.colorPosLCAO = (rgb = ((Integer)value).intValue());
            this.defaultColix = Graphics3D.getColix(rgb);
            if (this.colorPtr++ == 0) {
                this.colorNeg = this.colorNegLCAO = rgb;
            }
            return;
        }
        if ("red" == propertyName) {
            this.valueMappedToRed = ((Float)value).floatValue();
            return;
        }
        if ("blue" == propertyName) {
            this.valueMappedToBlue = ((Float)value).floatValue();
            this.rangeDefined = true;
            return;
        }
        if ("reverseColor" == propertyName) {
            this.isColorReversed = true;
            return;
        }
        if ("setColorScheme" == propertyName) {
            this.colorScheme = (String)value;
            if (this.currentMesh != null && this.colorScheme.equals("sets")) {
                this.currentMesh.surfaceSet = this.getSurfaceSet(0);
                super.setProperty("color", "sets", null);
            }
            return;
        }
        if ("contour" == propertyName) {
            this.isContoured = true;
            int n = (Integer)value;
            if (n > 0) {
                this.nContours = n;
            } else if (n == 0) {
                this.nContours = 11;
            } else {
                this.thisContour = -n;
            }
            return;
        }
        if ("phase" == propertyName) {
            String color = (String)value;
            this.isCutoffAbsolute = true;
            this.colorBySign = true;
            this.colorByPhase = true;
            this.colorPhase = -1;
            int i = colorPhases.length;
            while (--i >= 0) {
                if (!color.equalsIgnoreCase(colorPhases[i])) continue;
                this.colorPhase = i;
                break;
            }
            if (this.colorPhase < 0) {
                Logger.warn(" invalid color phase: " + color);
                this.colorPhase = 1;
            }
            if (this.logMessages) {
                Logger.info("phase " + color + " " + this.colorPhase);
            }
            if (this.state == 2) {
                this.dataType = this.surfaceType;
                this.state = 3;
                if (this.currentMesh != null) {
                    this.applyColorScale(this.currentMesh);
                }
            }
            return;
        }
        if ("map" == propertyName) {
            if (this.currentMesh != null) {
                this.state = 2;
            }
            return;
        }
        if ("plane" == propertyName) {
            this.thePlane = (Point4f)value;
            this.isContoured = true;
            ++this.state;
            return;
        }
        if ("sphere" == propertyName) {
            this.sphere_radiusAngstroms = ((Float)value).floatValue();
            this.dataType = 65;
            this.isSilent = !this.logMessages;
            this.setEccentricity(new Point4f(0.0f, 0.0f, 1.0f, 1.0f));
            this.cutoff = Float.MIN_VALUE;
            this.script = " center " + StateManager.escape(this.center) + " SPHERE " + this.sphere_radiusAngstroms;
            propertyName = "getSurface";
        }
        if ("ellipsoid" == propertyName) {
            v = (Point4f)value;
            this.setEccentricity(v);
            this.dataType = 66;
            this.sphere_radiusAngstroms = 1.0f;
            this.cutoff = Float.MIN_VALUE;
            propertyName = "getSurface";
            this.script = " center " + StateManager.escape(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " ELLIPSOID {" + v.x + " " + v.y + " " + v.z + " " + v.w + "}";
        }
        if ("lobe" == propertyName) {
            v = (Point4f)value;
            this.setEccentricity(v);
            this.dataType = 67;
            if (this.cutoff == Float.MAX_VALUE) {
                this.cutoff = 0.14f;
            }
            this.script = " center " + StateManager.escape(this.center) + (Float.isNaN(this.scale) ? "" : " scale " + this.scale) + " LOBE {" + v.x + " " + v.y + " " + v.z + " " + v.w + "}";
            propertyName = "getSurface";
        }
        if ("lcaoType" == propertyName) {
            this.lcaoType = (String)value;
            if (this.colorPtr == 1) {
                this.colorPosLCAO = this.colorNegLCAO;
            }
            this.isSilent = !this.logMessages;
            return;
        }
        if ("lcaoCartoon" == propertyName) {
            if (++this.state != 2) {
                return;
            }
            Vector3f[] info = (Vector3f[])value;
            if (this.center.x == Float.MAX_VALUE) {
                this.center.set(info[2]);
            }
            this.drawLcaoCartoon(this.lcaoType, info[0], info[1]);
        }
        if ("vdwRadius" == propertyName || "ionicRadius" == propertyName) {
            this.useIonic = propertyName.charAt(0) == 'i';
            float radius = ((Float)value).floatValue();
            if (radius >= 100.0f) {
                this.solventAtomRadiusFactor = (radius - 100.0f) / 100.0f;
            } else if (radius > 10.0f) {
                this.solventAtomRadiusAbsolute = radius - 10.0f;
            } else {
                this.solventAtomRadiusOffset = radius;
            }
            return;
        }
        if ("molecular" == propertyName || "solvent" == propertyName || "sasurface" == propertyName || "nomap" == propertyName) {
            this.isAnisotropic = false;
            this.isEccentric = false;
            this.solventRadius = ((Float)value).floatValue();
            if (this.solventRadius < 0.0f) {
                this.solventRadius = 1.2f;
            }
            this.dataType = "nomap" == propertyName ? 180 : ("molecular" == propertyName ? 179 : ("sasurface" == propertyName || this.solventRadius == 0.0f ? 172 : 171));
            switch (this.dataType) {
                case 180: {
                    this.solventExtendedAtomRadius = this.solventRadius;
                    this.solventRadius = 0.0f;
                    this.isContoured = false;
                    break;
                }
                case 179: {
                    this.solventExtendedAtomRadius = 0.0f;
                    Logger.info("creating molecular surface with radius " + this.solventRadius);
                    break;
                }
                case 171: {
                    this.solventExtendedAtomRadius = 0.0f;
                    if (this.bsIgnore == null) {
                        this.bsIgnore = this.viewer.getAtomBitSet("(solvent)");
                    }
                    Logger.info("creating solvent-excluded surface with radius " + this.solventRadius);
                    break;
                }
                case 172: {
                    this.solventExtendedAtomRadius = this.solventRadius;
                    this.solventRadius = 0.0f;
                    if (this.bsIgnore == null) {
                        this.bsIgnore = this.viewer.getAtomBitSet("(solvent)");
                    }
                    Logger.info("creating solvent-accessible surface with radius " + this.solventExtendedAtomRadius);
                }
            }
            if (this.state == 2) {
                propertyName = "mapColor";
            } else {
                this.cutoff = 0.0f;
                propertyName = "getSurface";
            }
        }
        if ("moData" == propertyName) {
            this.moData = (Hashtable)value;
            propertyName = "mapColor";
            return;
        }
        if ("molecularOrbital" == propertyName) {
            this.qm_moNumber = (Integer)value;
            int n = this.moData.containsKey("gaussians") ? 1 : (this.qmOrbitalType = this.moData.containsKey("slaterInfo") ? 2 : 0);
            if (this.qmOrbitalType == 0) {
                Logger.error("moData does not contain data of a known type");
                return;
            }
            Vector mos = (Vector)this.moData.get("mos");
            this.qmOrbitalCount = mos.size();
            Logger.info("Molecular orbital #" + this.qm_moNumber + "/" + this.qmOrbitalCount + " " + this.moData.get("calculationType"));
            Hashtable mo = (Hashtable)mos.get(this.qm_moNumber - 1);
            if (this.title == null) {
                this.title = new String[5];
                this.title[0] = "%F";
                this.title[1] = "Model %M  MO %I/%N";
                this.title[2] = "Energy = %E %U";
                this.title[3] = "?Symmetry = %S";
                this.title[4] = "?Occupancy = %O";
            }
            int i = this.title.length;
            while (--i >= 0) {
                this.addMOTitleInfo(i, mo);
            }
            this.moCoefficients = (float[])mo.get("coefficients");
            this.dataType = 301;
            if (this.state == 2) {
                propertyName = "mapColor";
            } else {
                this.colorBySign = true;
                this.colorByPhase = true;
                this.colorPhase = 0;
                if (this.cutoff == Float.MAX_VALUE) {
                    this.cutoff = 0.05f;
                }
                this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
                this.isBicolorMap = true;
                propertyName = "getSurface";
            }
        }
        if ("mep" == propertyName) {
            this.mepCharges = (float[])value;
            this.isAnisotropic = false;
            this.isEccentric = false;
            this.dataType = 304;
            if (this.state == 2) {
                if (!this.rangeDefined) {
                    this.valueMappedToRed = -0.05f;
                    this.valueMappedToBlue = 0.05f;
                    this.rangeDefined = true;
                }
                propertyName = "mapColor";
            } else {
                this.colorBySign = true;
                this.colorByPhase = true;
                this.colorPhase = 0;
                if (this.cutoff == Float.MAX_VALUE) {
                    this.cutoff = 0.05f;
                }
                this.isCutoffAbsolute = this.cutoff > 0.0f && !this.isPositiveOnly;
                this.isBicolorMap = true;
                propertyName = "getSurface";
            }
        }
        if ("hydrogenOrbital" == propertyName) {
            this.dataType = 14;
            float[] nlmZ = (float[])value;
            this.psi_n = (int)nlmZ[0];
            this.psi_l = (int)nlmZ[1];
            this.psi_m = (int)nlmZ[2];
            this.psi_Znuc = nlmZ[3];
            this.psi_ptsPerAngstrom = 10.0f;
            if (this.psi_Znuc <= 0.0f || Math.abs(this.psi_m) > this.psi_l || this.psi_l >= this.psi_n) {
                Logger.error("must have |m| <= l < n and Znuc > 0: " + this.psi_n + " " + this.psi_l + " " + this.psi_m + " " + this.psi_Znuc);
                return;
            }
            if (this.state == 2) {
                propertyName = "mapColor";
            } else {
                if (this.cutoff == Float.MAX_VALUE) {
                    this.cutoff = 0.14f;
                }
                this.isCutoffAbsolute = true;
                if (this.colorBySign) {
                    this.isBicolorMap = true;
                }
                propertyName = "getSurface";
            }
        }
        if ("functionXY" == propertyName) {
            this.dataType = 5;
            this.functionXYinfo = (Vector)value;
            if (this.isContoured) {
                this.setPlaneParameters(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            this.cutoff = Float.MIN_VALUE;
            this.isAnisotropic = false;
            this.isEccentric = false;
            propertyName = "getSurface";
        }
        if ("getSurface" == propertyName) {
            if (++this.state != 2) {
                return;
            }
            if (this.dataType == 0) {
                if (value instanceof BufferedReader) {
                    this.br = (BufferedReader)value;
                    this.dataType = 17;
                } else if (value instanceof Hashtable) {
                    this.surfaceInfo = (Hashtable)value;
                    this.dataType = 18;
                } else {
                    Logger.error("unknown surface data type??");
                    return;
                }
                if (this.colorBySign) {
                    this.isBicolorMap = true;
                }
            }
            this.surfaceType = this.dataType;
            if (!this.isSilent) {
                Logger.info("loading voxel data...");
            }
            this.checkFlags();
            long timeBegin = System.currentTimeMillis();
            if (!this.createIsosurface()) {
                Logger.error("Could not create isosurface");
                return;
            }
            if (!this.isSilent) {
                Logger.info("surface calculation time: " + (System.currentTimeMillis() - timeBegin) + " ms");
            }
            this.initializeMesh(this.force2SidedTriangles);
            String string = this.jvxlFileMessage = this.jvxlDataIsColorMapped ? "mapped" : "";
            if (this.isContoured && this.thePlane == null) {
                this.planarVectors[0].set(this.volumetricVectors[0]);
                this.planarVectors[1].set(this.volumetricVectors[1]);
                this.pixelCounts[0] = this.voxelCounts[0];
                this.pixelCounts[1] = this.voxelCounts[1];
            }
            if (this.jvxlDataIs2dContour) {
                this.colorIsosurface();
            }
            this.currentMesh.nBytes = this.nBytes;
            if (this.colorByPhase || this.colorBySign) {
                this.state = 3;
                this.mappingType = this.dataType;
                this.applyColorScale(this.currentMesh);
            }
            if (this.colorScheme.equals("sets")) {
                this.currentMesh.surfaceSet = this.getSurfaceSet(0);
                super.setProperty("color", "sets", null);
            }
            this.setModelIndex();
            if (this.logMessages && this.thePlane == null && !this.isSilent) {
                Logger.debug("\n" + this.jvxlGetFile(this.currentMesh, this.jvxlFileMessage, true, 1));
            }
            this.discardTempData(this.jvxlDataIs2dContour);
            this.dataType = 0;
            this.mappedDataMin = Float.MAX_VALUE;
            return;
        }
        if ("mapColor" == propertyName) {
            if (++this.state != 3) {
                return;
            }
            if (!this.isSilent) {
                Logger.info("mapping data...");
            }
            if (this.dataType == 0) {
                if (value instanceof BufferedReader) {
                    this.br = (BufferedReader)value;
                    this.dataType = 17;
                } else if (value instanceof Hashtable) {
                    this.surfaceInfo = (Hashtable)value;
                    this.dataType = 18;
                } else {
                    Logger.error("unknown surface data type??");
                    return;
                }
            }
            this.mappingType = this.dataType;
            this.checkFlags();
            if (this.thePlane != null) {
                this.createIsosurface();
                this.initializeMesh(true);
                this.readVolumetricData(true);
                this.colorIsosurface();
            } else {
                this.readData(true);
                if (this.jvxlDataIsColorMapped) {
                    this.jvxlReadColorData(this.currentMesh);
                } else {
                    this.colorIsosurface();
                }
            }
            this.currentMesh.nBytes = this.nBytes;
            if (this.logMessages && !this.isSilent) {
                Logger.debug("\n" + this.jvxlGetFile(this.currentMesh, this.jvxlFileMessage, true, 1));
            }
            this.setModelIndex();
            this.discardTempData(true);
            this.dataType = 0;
            return;
        }
        if ("delete" == propertyName && this.currentMesh == null) {
            this.nLCAO = 0;
        }
        super.setProperty(propertyName, value, bs);
    }

    Object getProperty(String property, int index) {
        if (property == "moNumber") {
            return new Integer(this.qm_moNumber);
        }
        if (this.currentMesh == null) {
            return "no current isosurface";
        }
        if (property == "jvxlFileData") {
            return this.jvxlGetFile(this.currentMesh, "", true, index);
        }
        if (property == "jvxlSurfaceData") {
            return this.jvxlGetFile(this.currentMesh, "", false, 1);
        }
        return super.getProperty(property, index);
    }

    boolean getScriptBitSets() {
        if (this.script == null) {
            return false;
        }
        int i = this.script.indexOf("# ({");
        if (i < 0) {
            return false;
        }
        int j = this.script.indexOf("})", i);
        this.bsSelected = StateManager.unescapeBitset(this.script.substring(i + 3, j + 1));
        i = this.script.indexOf("({", j);
        if (i < 0) {
            return false;
        }
        j = this.script.indexOf("})", i);
        this.bsIgnore = StateManager.unescapeBitset(this.script.substring(i + 1, j + 1));
        return true;
    }

    String fixScript() {
        if (this.script.indexOf("# ({") >= 0) {
            return this.script;
        }
        if (this.script.charAt(0) == ' ') {
            return this.myType + " " + this.currentMesh.thisID + this.script;
        }
        if (!this.iUseBitSets) {
            return this.script;
        }
        return this.script + "# " + (this.bsSelected == null ? "({null})" : StateManager.escape(this.bsSelected)) + " " + (this.bsIgnore == null ? "({null})" : StateManager.escape(this.bsIgnore));
    }

    void initializeIsosurface() {
        this.logMessages = Logger.isActiveLevel(0);
        this.logCompression = false;
        this.logCube = false;
        this.blockCubeData = false;
        this.isSilent = false;
        this.title = null;
        this.fileIndex = 1;
        this.insideOut = false;
        this.isFixed = false;
        this.atomIndex = -1;
        this.precalculateVoxelData = false;
        this.isColorReversed = false;
        this.iAddGridPoints = false;
        this.newSolventMethod = true;
        this.associateNormals = true;
        this.force2SidedTriangles = true;
        this.colorByPhase = false;
        this.colorBySign = false;
        this.defaultColix = 0;
        this.colorNeg = defaultColorNegative;
        this.colorPos = defaultColorPositive;
        this.colorNegLCAO = defaultColorNegativeLCAO;
        this.colorPosLCAO = defaultColorPositiveLCAO;
        this.colorScheme = "roygb";
        this.addHydrogens = false;
        this.isAnisotropic = false;
        this.isEccentric = false;
        this.scale = Float.NaN;
        this.isAngstroms = false;
        this.resolution = Float.MAX_VALUE;
        this.center = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.cutoff = Float.MAX_VALUE;
        this.thePlane = null;
        this.nBytes = 0;
        this.nContours = 0;
        this.colorPtr = 0;
        this.thisContour = -1;
        this.isContoured = false;
        this.rangeDefined = false;
        this.mappedDataMin = Float.MAX_VALUE;
        this.isPositiveOnly = false;
        this.isCutoffAbsolute = false;
        this.isBicolorMap = false;
        this.precalculateVoxelData = false;
        this.bsIgnore = null;
        this.iUseBitSets = false;
        this.solventExtendedAtomRadius = 0.0f;
        this.solventAtomRadiusFactor = 1.0f;
        this.solventAtomRadiusAbsolute = 0.0f;
        this.solventAtomRadiusOffset = 0.0f;
        this.useIonic = false;
        this.jvxlInitFlags();
        this.initState();
    }

    void initState() {
        this.state = 1;
        this.assocGridPointMap = new Hashtable();
        this.assocGridPointNormals = new Hashtable();
        this.mappingType = 0;
        this.surfaceType = 0;
        this.dataType = 0;
    }

    void setEccentricity(Point4f info) {
        Vector3f ecc = new Vector3f(info.x, info.y, info.z);
        float c = this.scale > 0.0f ? this.scale : (info.w < 0.0f ? 1.0f : ecc.length());
        float fab_c = Math.abs(info.w);
        ecc.normalize();
        Vector3f z = new Vector3f(0.0f, 0.0f, 1.0f);
        ecc.add(z);
        ecc.normalize();
        if (Float.isNaN(ecc.x)) {
            ecc.set(1.0f, 0.0f, 0.0f);
        }
        this.eccentricityMatrix = new Matrix3f();
        this.eccentricityMatrix.setIdentity();
        this.eccentricityMatrix.set(new AxisAngle4f(ecc, (float)Math.PI));
        this.eccentricityMatrixInverse = new Matrix3f();
        this.eccentricityMatrixInverse.invert(this.eccentricityMatrix);
        this.isAnisotropic = true;
        this.isEccentric = true;
        this.eccentricityScale = c;
        this.eccentricityRatio = fab_c;
        if (fab_c > 1.0f) {
            this.eccentricityScale *= fab_c;
        }
        this.anisotropy[0] = fab_c * c;
        this.anisotropy[1] = fab_c * c;
        this.anisotropy[2] = c;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
    }

    void colorIsosurface() {
        this.setMapRanges();
        if (this.isContoured) {
            this.generateContourData(this.jvxlDataIs2dContour);
            this.initializeMesh(true);
            this.applyColorScale(this.currentMesh);
        } else {
            this.applyColorScale(this.currentMesh);
        }
        this.currentMesh.jvxlExtraLine = this.jvxlExtraLine(1);
        this.jvxlFileMessage = "mapped: min = " + this.valueMappedToRed + "; max = " + this.valueMappedToBlue;
    }

    void setMapRanges() {
        if (this.colorByPhase || this.colorBySign || this.isBicolorMap && !this.isContoured) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (this.mappedDataMin == Float.MAX_VALUE || this.mappedDataMin == this.mappedDataMax) {
            this.mappedDataMin = this.getMinMappedValue();
            this.mappedDataMax = this.getMaxMappedValue();
        }
        if (this.logMessages) {
            Logger.debug("setMapRanges: all mapped data " + this.mappedDataMin + " to " + this.mappedDataMax + ", red-blue selected " + this.valueMappedToRed + " to " + this.valueMappedToBlue);
        }
        if (this.mappedDataMin == 0.0f && this.mappedDataMax == 0.0f) {
            this.mappedDataMin = -1.0f;
            this.mappedDataMax = 1.0f;
        }
        if (!this.rangeDefined) {
            this.valueMappedToRed = this.mappedDataMin;
            this.valueMappedToBlue = this.mappedDataMax;
        }
        if (this.logMessages) {
            Logger.debug("setMapRanges: " + this.mappedDataMin + " " + this.mappedDataMax + " " + this.valueMappedToRed + " " + this.valueMappedToBlue);
        }
        this.currentMesh.valueMappedToRed = this.valueMappedToRed;
        this.currentMesh.valueMappedToBlue = this.valueMappedToBlue;
        this.currentMesh.mappedDataMin = this.mappedDataMin;
        this.currentMesh.mappedDataMax = this.mappedDataMax;
    }

    void checkFlags() {
        if (this.viewer.getTestFlag1()) {
            this.newSolventMethod = false;
        }
        if (this.viewer.getTestFlag2()) {
            this.associateNormals = false;
        }
        if (this.viewer.getTestFlag4()) {
            this.force2SidedTriangles = false;
        }
        if (this.logMessages) {
            Logger.debug("Isosurface using testflag4: no 2-sided triangles = " + !this.force2SidedTriangles);
            Logger.debug("Isosurface using testflag2: no associative grouping = " + !this.associateNormals);
            Logger.debug("IsosurfaceRenderer using testflag3: separated triangles = " + this.viewer.getTestFlag3());
            Logger.debug("IsosurfaceRenderer using testflag4: show vertex normals = " + this.viewer.getTestFlag4());
            Logger.debug("For grid points, use: isosurface delete myiso gridpoints \"\"");
        }
    }

    boolean createIsosurface() {
        this.resetIsosurface();
        try {
            this.readData(false);
            this.calcVoxelVertexVectors();
            this.generateSurfaceData();
        }
        catch (Exception e) {
            return false;
        }
        this.currentMesh.jvxlFileHeader = "" + this.jvxlFileHeader;
        this.currentMesh.cutoff = this.isJvxl ? this.jvxlCutoff : this.cutoff;
        this.currentMesh.jvxlColorData = "";
        this.currentMesh.jvxlEdgeData = "" + this.fractionData;
        this.currentMesh.isBicolorMap = this.isBicolorMap;
        this.currentMesh.isContoured = this.isContoured;
        this.currentMesh.nContours = this.nContours;
        if (this.jvxlDataIsColorMapped) {
            this.jvxlReadColorData(this.currentMesh);
        }
        this.currentMesh.colix = this.getDefaultColix();
        this.currentMesh.jvxlExtraLine = this.jvxlExtraLine(1);
        if (this.thePlane != null && this.iAddGridPoints) {
            this.addGridPointCube();
        }
        return true;
    }

    void resetIsosurface() {
        if (this.currentMesh == null) {
            this.allocMesh(null);
        }
        this.currentMesh.clear("isosurface");
        this.contourVertexCount = 0;
        this.currentMesh.firstViewableVertex = 0;
        if (this.iAddGridPoints) {
            this.currentMesh.showPoints = true;
            this.currentMesh.hasGridPoints = true;
        }
        if (this.cutoff == Float.MAX_VALUE) {
            this.cutoff = 0.02f;
        }
        this.currentMesh.jvxlSurfaceData = "";
        this.currentMesh.jvxlEdgeData = "";
        this.currentMesh.jvxlColorData = "";
        this.edgeCount = 0;
    }

    void addGridPointCube() {
        for (int x = 0; x < this.voxelCounts[0]; x += 5) {
            for (int y = 0; y < this.voxelCounts[1]; y += 5) {
                for (int z = 0; z < this.voxelCounts[2]; z += 5) {
                    Point3f pt = new Point3f();
                    this.addVertexCopy(pt, 0.0f, false, "");
                }
            }
        }
    }

    void readData(boolean isMapData) {
        this.isJvxl = false;
        this.endOfData = false;
        this.mappedDataMin = Float.MAX_VALUE;
        this.nSurfaces = this.readVolumetricHeader();
        if (this.nSurfaces < this.fileIndex) {
            Logger.warn("not enough surfaces in file -- resetting fileIndex to " + this.nSurfaces);
            this.fileIndex = this.nSurfaces;
        }
        if (this.isJvxl && isMapData) {
            try {
                int nPoints = this.nPointsX * this.nPointsY * this.nPointsZ;
                this.gotoData(this.fileIndex - 1, nPoints);
                this.jvxlSkipData(nPoints, false);
            }
            catch (Exception e) {
                Logger.error(null, e);
            }
        } else {
            this.readVolumetricData(isMapData);
        }
    }

    void discardTempData(boolean discardAll) {
        this.voxelData = null;
        if (this.dataType == 17) {
            try {
                this.br.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!discardAll) {
            return;
        }
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.pixelData = null;
        this.planarSquares = null;
        this.contourVertexes = null;
        this.contourVertexCount = 0;
    }

    short getDefaultColix() {
        int argb;
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (this.cutoff >= 0.0f) {
            this.indexColorPositive %= JmolConstants.argbsIsosurfacePositive.length;
            argb = JmolConstants.argbsIsosurfacePositive[this.indexColorPositive++];
        } else {
            this.indexColorNegative %= JmolConstants.argbsIsosurfaceNegative.length;
            argb = JmolConstants.argbsIsosurfaceNegative[this.indexColorNegative++];
        }
        return Graphics3D.getColix(argb);
    }

    int readVolumetricHeader() {
        this.precalculateVoxelData = false;
        try {
            switch (this.dataType) {
                case 65: 
                case 66: {
                    this.setupSphere();
                    break;
                }
                case 67: {
                    this.setupLobe();
                    break;
                }
                case 171: 
                case 172: 
                case 179: 
                case 180: {
                    this.setupSolvent();
                    break;
                }
                case 14: {
                    this.setupOrbital();
                    break;
                }
                case 301: {
                    this.setupQMOrbital();
                    break;
                }
                case 5: {
                    this.setupFunctionXY();
                    break;
                }
                case 304: {
                    this.setupMep();
                    break;
                }
                case 18: {
                    this.setupSurfaceInfo();
                    break;
                }
                default: {
                    this.readTitleLines();
                    this.readAtomCountAndOrigin();
                    if (!this.isSilent) {
                        Logger.debug("voxel grid origin:" + this.volumetricOrigin);
                    }
                    for (int i = 0; i < 3; ++i) {
                        this.readVoxelVector(i);
                        if (this.isSilent) continue;
                        Logger.debug("voxel grid vector:" + this.volumetricVectors[i]);
                    }
                }
            }
            this.setupMatrix(this.volumetricMatrix, this.volumetricVectors);
            if (this.dataType != 67 && this.center.x != Float.MAX_VALUE) {
                this.offsetCenter();
            }
            this.readAtoms();
            return this.readExtraLine();
        }
        catch (Exception e) {
            Logger.error(null, e);
            throw new NullPointerException();
        }
    }

    void readVolumetricData(boolean isMapData) {
        try {
            this.readVoxelData(isMapData);
            if (this.isJvxl && this.jvxlEdgeDataCount > 0) {
                this.jvxlEdgeDataRead = this.jvxlReadData("edge", this.jvxlEdgeDataCount);
            }
            if (this.isJvxl && this.jvxlColorDataCount > 0) {
                this.jvxlColorDataRead = this.jvxlReadData("color", this.jvxlColorDataCount);
            }
        }
        catch (Exception e) {
            Logger.error(null, e);
            throw new NullPointerException();
        }
    }

    void readTitleLines() throws Exception {
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append(this.br.readLine());
        this.jvxlFileHeader.append('\n');
        this.jvxlFileHeader.append(this.br.readLine());
        this.jvxlFileHeader.append('\n');
        if (!this.isSilent) {
            Logger.info("" + this.jvxlFileHeader);
        }
    }

    void readAtomCountAndOrigin() throws Exception {
        this.line = this.br.readLine();
        if (!this.isSilent) {
            Logger.debug(this.line);
        }
        this.atomCount = this.parseInt(this.line);
        String atomLine = this.line.substring(this.ichNextParse);
        boolean bl = this.negativeAtomCount = this.atomCount < 0;
        if (!this.isSilent) {
            Logger.debug("atom Count: " + this.atomCount);
        }
        if (this.negativeAtomCount) {
            this.atomCount = -this.atomCount;
        }
        int jvxlAtoms = this.atomCount == 0 ? -2 : -this.atomCount;
        this.volumetricOrigin.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
        this.jvxlFileHeader.append(jvxlAtoms + atomLine + '\n');
    }

    void readVoxelVector(int voxelVectorIndex) throws Exception {
        this.line = this.br.readLine();
        this.jvxlFileHeader.append(this.line);
        this.jvxlFileHeader.append('\n');
        Vector3f voxelVector = this.volumetricVectors[voxelVectorIndex];
        this.voxelCounts[voxelVectorIndex] = this.parseInt(this.line);
        voxelVector.set(this.parseFloat(), this.parseFloat(), this.parseFloat());
        if (!this.isAngstroms) {
            voxelVector.scale(0.5291772f);
        }
        this.volumetricVectorLengths[voxelVectorIndex] = voxelVector.length();
        this.unitVolumetricVectors[voxelVectorIndex].normalize(voxelVector);
        for (int i = 0; i < voxelVectorIndex; ++i) {
            float orthoTest = Math.abs(this.unitVolumetricVectors[i].dot(this.unitVolumetricVectors[voxelVectorIndex]));
            if (!((double)orthoTest > 1.001) && (!((double)orthoTest < 0.999) || !((double)orthoTest > 0.001))) continue;
            Logger.warn("Warning: voxel coordinate vectors are not orthogonal.");
        }
    }

    void setupMatrix(Matrix3f mat, Vector3f[] cols) {
        for (int i = 0; i < 3; ++i) {
            mat.setColumn(i, cols[i]);
        }
    }

    void readAtoms() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.jvxlFileHeader.append(this.br.readLine() + "\n");
        }
        if (this.atomCount == 0) {
            Point3f pt = new Point3f(this.volumetricOrigin);
            this.jvxlFileHeader.append("1 1.0 " + pt.x + " " + pt.y + " " + pt.z + " //BOGUS H ATOM ADDED FOR JVXL FORMAT\n");
            for (int i = 0; i < 3; ++i) {
                pt.scaleAdd(this.voxelCounts[i] - 1, this.volumetricVectors[i], pt);
            }
            this.jvxlFileHeader.append("2 2.0 " + pt.x + " " + pt.y + " " + pt.z + " //BOGUS He ATOM ADDED FOR JVXL FORMAT\n");
        }
    }

    int readExtraLine() throws Exception {
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        if (!this.negativeAtomCount) {
            return 1;
        }
        this.line = this.br.readLine();
        Logger.info("Reading extra orbital/JVXL information line: " + this.line);
        int nSurfaces = this.parseInt(this.line);
        this.isJvxl = nSurfaces < 0;
        if (!this.isJvxl) {
            return nSurfaces;
        }
        nSurfaces = -nSurfaces;
        Logger.info("jvxl file surfaces: " + nSurfaces);
        int ich = this.parseInt();
        if (ich == Integer.MIN_VALUE) {
            Logger.info("using default edge fraction base and range");
        } else {
            this.edgeFractionBase = ich;
            this.edgeFractionRange = this.parseInt();
        }
        ich = this.parseInt();
        if (ich == Integer.MIN_VALUE) {
            Logger.info("using default color fraction base and range");
        } else {
            this.colorFractionBase = ich;
            this.colorFractionRange = this.parseInt();
        }
        return nSurfaces;
    }

    void readVoxelData(boolean isMapData) throws Exception {
        boolean isPrecalculation;
        boolean inside = false;
        int dataCount = 0;
        this.ichNextParse = 0;
        this.nThisValue = 0;
        this.surfaceData = "";
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        int nPoints = this.nPointsX * this.nPointsY * this.nPointsZ;
        if (this.nPointsX <= 0 || this.nPointsY <= 0 || this.nPointsZ <= 0) {
            return;
        }
        if (!this.isSilent) {
            Logger.debug("entering readVoxelData for fileIndex = " + this.fileIndex + "; " + nPoints + " data points mapping=" + isMapData);
        }
        this.gotoData(this.fileIndex - 1, nPoints);
        boolean bl = this.thisInside = !this.isJvxl || !this.isContoured;
        if (this.insideOut) {
            boolean bl2 = this.thisInside = !this.thisInside;
        }
        if (this.thePlane != null) {
            this.setPlaneParameters(this.thePlane);
            this.cutoff = 0.0f;
        } else if (this.isJvxl) {
            float f = this.cutoff = this.isBicolorMap || this.colorBySign ? 0.01f : 0.5f;
        }
        if (!this.isSilent) {
            Logger.info("isosurface cutoff = " + this.cutoff);
        }
        boolean justDefiningPlane = !isMapData && this.thePlane != null;
        boolean bl3 = isPrecalculation = this.precalculateVoxelData && !justDefiningPlane;
        if (this.dataType == 18) {
            if (justDefiningPlane) {
                this.voxelData = new float[this.nPointsX][][];
            } else {
                this.voxelData = this.tempVoxelData;
                this.tempVoxelData = null;
            }
        } else {
            this.voxelData = new float[this.nPointsX][][];
            if (isPrecalculation) {
                for (int x = 0; x < this.nPointsX; ++x) {
                    this.voxelData[x] = new float[this.nPointsY][];
                    for (int y = 0; y < this.nPointsY; ++y) {
                        this.voxelData[x][y] = new float[this.nPointsZ];
                    }
                }
                if (this.dataType == 301) {
                    this.generateQuantumCube();
                } else if (this.dataType == 304) {
                    this.generateMepCube();
                } else if ((this.dataType & 0x80) != 0) {
                    this.generateSolventCube();
                } else {
                    Logger.error("code error -- isPrecalculation, but how?");
                }
                if (isMapData || this.thePlane != null) {
                    return;
                }
            }
        }
        this.nDataPoints = 0;
        float zValue = 0.0f;
        this.line = "";
        for (int x = 0; x < this.nPointsX; ++x) {
            Object plane;
            if (isPrecalculation) {
                plane = this.voxelData[x];
            } else {
                plane = new float[this.nPointsY][];
                this.voxelData[x] = plane;
            }
            for (int y = 0; y < this.nPointsY; ++y) {
                float[] strip;
                if (isPrecalculation) {
                    strip = plane[y];
                } else {
                    plane[y] = strip = new float[this.nPointsZ];
                }
                if (this.dataType == 5) {
                    zValue = this.getFunctionValue(x, y);
                }
                for (int z = 0; z < this.nPointsZ; ++z) {
                    float voxelValue;
                    if (justDefiningPlane) {
                        voxelValue = this.calcVoxelPlaneDistance(x, y, z);
                    } else {
                        switch (this.dataType) {
                            case 65: 
                            case 66: {
                                voxelValue = this.getSphereValue(x, y, z);
                                break;
                            }
                            case 67: {
                                voxelValue = this.getLobeValue(x, y, z);
                                break;
                            }
                            case 171: 
                            case 172: 
                            case 179: {
                                if (isPrecalculation) {
                                    voxelValue = strip[z];
                                    break;
                                }
                                voxelValue = this.getSolventValue(x, y, z);
                                break;
                            }
                            case 14: {
                                voxelValue = this.getPsi(x, y, z);
                                break;
                            }
                            case 301: 
                            case 304: {
                                voxelValue = strip[z];
                                break;
                            }
                            case 5: {
                                voxelValue = this.thePlane == null ? zValue - (float)z : zValue;
                                break;
                            }
                            case 18: {
                                voxelValue = this.voxelData[x][y][z];
                                break;
                            }
                            case 180: {
                                voxelValue = 0.0f;
                                break;
                            }
                            default: {
                                voxelValue = this.getNextVoxelValue();
                            }
                        }
                    }
                    strip[z] = voxelValue;
                    ++this.nDataPoints;
                    if (this.isJvxl && this.thePlane == null || isMapData) continue;
                    if (this.logCube && x < 20 && y < 20 && z < 20) {
                        this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
                        Logger.info("voxelData[" + x + "][" + y + "][" + z + "] xyz(Angstroms)=" + this.ptXyzTemp + " value=" + voxelValue);
                    }
                    if (inside == this.isInside(voxelValue, this.cutoff)) {
                        ++dataCount;
                        continue;
                    }
                    if (dataCount != 0) {
                        this.surfaceData = this.surfaceData + " " + dataCount;
                    }
                    dataCount = 1;
                    inside = !inside;
                }
            }
        }
        if (!this.isJvxl) {
            this.surfaceData = this.surfaceData + " " + dataCount + "\n";
        }
        if (!isMapData) {
            this.currentMesh.jvxlSurfaceData = this.thePlane == null ? this.surfaceData : "";
            this.currentMesh.jvxlPlane = this.thePlane;
        }
        if (!this.isSilent) {
            Logger.debug("Successfully read " + this.nPointsX + " x " + this.nPointsY + " x " + this.nPointsZ + " data points; " + this.edgeCount + " edges");
        }
    }

    void setPlaneParameters(Point4f plane) {
        if (plane.x == 0.0f && plane.y == 0.0f && plane.z == 0.0f) {
            plane.z = 1.0f;
        }
        this.thePlaneNormal.set(plane.x, plane.y, plane.z);
        this.thePlaneNormalMag = this.thePlaneNormal.length();
    }

    float calcVoxelPlaneDistance(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptXyzTemp);
        return this.distancePointToPlane(this.ptXyzTemp, this.thePlane);
    }

    float distancePointToPlane(Point3f pt, Point4f plane) {
        return (plane.x * pt.x + plane.y * pt.y + plane.z * pt.z + plane.w) / this.thePlaneNormalMag;
    }

    void jvxlInitFlags() {
        this.jvxlEdgeDataRead = "";
        this.jvxlColorDataRead = "";
        this.jvxlDataIs2dContour = false;
        this.jvxlDataIsColorMapped = false;
        this.jvxlDataIsPrecisionColor = false;
        this.jvxlDataisBicolorMap = false;
        this.jvxlWritePrecisionColor = false;
    }

    void jvxlReadDefinitionLine(boolean showMsg) throws Exception {
        while ((this.line = this.br.readLine()) != null && this.line.length() == 0 || this.line.charAt(0) == '#') {
        }
        if (showMsg) {
            Logger.info("reading jvxl data set: " + this.line);
        }
        this.jvxlCutoff = this.parseFloat(this.line);
        Logger.info("JVXL read: cutoff " + this.jvxlCutoff);
        int param1 = this.parseInt();
        int param2 = this.parseInt();
        int param3 = this.parseInt();
        if (param3 == Integer.MIN_VALUE || param3 == -1) {
            param3 = 0;
        }
        if (param1 == -1) {
            try {
                this.thePlane = new Point4f(this.parseFloat(), this.parseFloat(), this.parseFloat(), this.parseFloat());
            }
            catch (Exception e) {
                Logger.error("Error reading 4 floats for PLANE definition -- setting to 0 0 1 0  (z=0)");
                this.thePlane = new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
            }
            Logger.info("JVXL read: {" + this.thePlane.x + " " + this.thePlane.y + " " + this.thePlane.z + " " + this.thePlane.w + "}");
        } else {
            this.thePlane = null;
        }
        if (param1 < 0 && param2 != -1) {
            this.isContoured = param3 != 0;
            int nContoursRead = this.parseInt();
            if (this.nContours == 0 && nContoursRead != Integer.MIN_VALUE && nContoursRead != 0 && nContoursRead <= 100) {
                this.nContours = nContoursRead;
                Logger.info("JVXL read: contours " + this.nContours);
            }
        } else {
            this.isContoured = false;
        }
        this.jvxlDataIsPrecisionColor = param1 == -1 && param2 == -2 || param3 < 0;
        this.jvxlDataisBicolorMap = param1 > 0 && param2 < 0;
        this.isBicolorMap = this.jvxlDataisBicolorMap;
        this.jvxlDataIsColorMapped = param3 != 0;
        boolean bl = this.jvxlDataIs2dContour = this.jvxlDataIsColorMapped && this.isContoured;
        if (this.isBicolorMap || this.colorBySign) {
            this.jvxlCutoff = 0.0f;
        }
        int n = param1 < -1 ? -param1 : (this.jvxlSurfaceDataCount = param1 > 0 ? param1 : 0);
        if (param1 == -1) {
            this.jvxlEdgeDataCount = 0;
        } else {
            int n2 = param2 < -1 ? -param2 : (this.jvxlEdgeDataCount = param2 > 0 ? param2 : 0);
        }
        int n3 = param3 < -1 ? -param3 : (this.jvxlColorDataCount = param3 > 0 ? param3 : 0);
        if (this.jvxlDataIsColorMapped) {
            float dataMin = this.parseFloat();
            float dataMax = this.parseFloat();
            float red = this.parseFloat();
            float blue = this.parseFloat();
            if (!Float.isNaN(dataMin) && !Float.isNaN(dataMax)) {
                if (dataMax == 0.0f && dataMin == 0.0f) {
                    dataMin = -1.0f;
                    dataMax = 1.0f;
                }
                this.mappedDataMin = dataMin;
                this.mappedDataMax = dataMax;
                Logger.info("JVXL read: data min/max: " + this.mappedDataMin + "/" + this.mappedDataMax);
            }
            if (!this.rangeDefined) {
                if (!Float.isNaN(red) && !Float.isNaN(blue)) {
                    if (red == 0.0f && blue == 0.0f) {
                        red = -1.0f;
                        blue = 1.0f;
                    }
                    this.valueMappedToRed = red;
                    this.valueMappedToBlue = blue;
                    this.rangeDefined = true;
                } else {
                    this.valueMappedToRed = 0.0f;
                    this.valueMappedToBlue = 1.0f;
                    this.rangeDefined = true;
                }
            }
            Logger.info("JVXL read: color red/blue: " + this.valueMappedToRed + " " + this.valueMappedToBlue);
        }
    }

    float getNextVoxelValue() throws Exception {
        if (this.isJvxl) {
            if (this.jvxlSurfaceDataCount <= 0) {
                return 0.0f;
            }
            if (this.nThisValue == 0) {
                this.nThisValue = this.parseInt();
                if (this.nThisValue == Integer.MIN_VALUE) {
                    this.line = this.br.readLine();
                    if (this.line == null || (this.nThisValue = this.parseInt(this.line)) == Integer.MIN_VALUE) {
                        if (!this.endOfData) {
                            Logger.error("end of file in JvxlReader? line=" + this.line);
                        }
                        this.endOfData = true;
                        this.nThisValue = 10000;
                    } else {
                        this.surfaceData = this.surfaceData + this.line + "\n";
                    }
                }
                this.thisInside = !this.thisInside;
            }
            --this.nThisValue;
            return this.thisInside ? 1.0f : 0.0f;
        }
        float voxelValue = 0.0f;
        if (this.nSurfaces > 1 && !this.blockCubeData) {
            int i;
            for (i = 1; i < this.fileIndex; ++i) {
                this.nextVoxel();
            }
            voxelValue = this.nextVoxel();
            for (i = this.fileIndex; i < this.nSurfaces; ++i) {
                this.nextVoxel();
            }
        } else {
            voxelValue = this.nextVoxel();
        }
        return voxelValue;
    }

    float nextVoxel() throws Exception {
        float voxelValue = this.parseFloat();
        if (Float.isNaN(voxelValue)) {
            this.line = this.br.readLine();
            if (this.line == null || Float.isNaN(voxelValue = this.parseFloat(this.line))) {
                if (!this.endOfData) {
                    Logger.warn("end of file reading cube voxel data? nBytes=" + this.nBytes + " nDataPoints=" + this.nDataPoints + " (line):" + this.line);
                }
                this.endOfData = true;
                this.line = "0 0 0 0 0 0 0 0 0 0";
            }
            this.nBytes += this.line.length() + 1;
        }
        return voxelValue;
    }

    void gotoData(int n, int nPoints) throws Exception {
        if (n > 0) {
            Logger.info("skipping " + n + " data sets, " + nPoints + " points each");
        }
        for (int i = 0; i < n; ++i) {
            if (this.isJvxl) {
                this.jvxlReadDefinitionLine(true);
                Logger.info("JVXL skipping: jvxlSurfaceDataCount=" + this.jvxlSurfaceDataCount + " jvxlEdgeDataCount=" + this.jvxlEdgeDataCount + " jvxlDataIsColorMapped=" + this.jvxlDataIsColorMapped);
                this.jvxlSkipData(nPoints, true);
                continue;
            }
            if (!this.blockCubeData) continue;
            this.skipData(nPoints, true);
        }
        if (this.isJvxl) {
            this.jvxlReadDefinitionLine(true);
        }
    }

    void jvxlSkipData(int nPoints, boolean doSkipColorData) throws Exception {
        if (this.jvxlSurfaceDataCount > 0) {
            this.skipData(nPoints, true);
        }
        if (this.jvxlEdgeDataCount > 0) {
            this.skipData(this.jvxlEdgeDataCount, false);
        }
        if (this.jvxlDataIsColorMapped && doSkipColorData) {
            this.skipData(this.jvxlColorDataCount, false);
        }
    }

    void skipData(int nPoints, boolean isInt) throws Exception {
        for (int iV = 0; iV < nPoints; iV += isInt ? this.countData(this.line) : this.jvxlUncompressString(this.line).length()) {
            this.line = this.br.readLine();
        }
    }

    String jvxlReadData(String type, int nPoints) {
        String str = "";
        try {
            while (str.length() < nPoints) {
                this.line = this.br.readLine();
                str = str + this.jvxlUncompressString(this.line);
            }
        }
        catch (Exception e) {
            Logger.error("Error reading " + type + " data " + e);
            throw new NullPointerException();
        }
        return str;
    }

    int countData(String str) {
        int count = 0;
        if (this.isJvxl) {
            int n = this.parseInt(str);
            while (n != Integer.MIN_VALUE) {
                count += n;
                n = this.parseInt(str, this.ichNextParse);
            }
            return count;
        }
        int ich = 0;
        int ichMax = str.length();
        while (ich < ichMax) {
            char ch;
            while (ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t')) {
                ++ich;
            }
            if (ich < ichMax) {
                ++count;
            }
            while (ich < ichMax && (ch = str.charAt(ich)) != ' ' && ch != '\t') {
                ++ich;
            }
        }
        return count;
    }

    int addVertexCopy(Point3f vertex, float value, boolean iHaveAssociation, String sKey) {
        int vPt = this.currentMesh.addVertexCopy(vertex, value);
        if (this.associateNormals && iHaveAssociation) {
            this.assocGridPointMap.put(new Integer(vPt), sKey);
            if (!this.assocGridPointNormals.containsKey(sKey)) {
                this.assocGridPointNormals.put(sKey, new Vector3f(0.0f, 0.0f, 0.0f));
            }
        }
        return vPt;
    }

    void initializeMesh(boolean use2Sided) {
        Integer I;
        int vertexCount = this.currentMesh.vertexCount;
        Vector3f[] vectorSums = new Vector3f[vertexCount];
        if (!this.isSilent) {
            Logger.debug(" initializeMesh " + vertexCount);
        }
        int i = vertexCount;
        while (--i >= 0) {
            vectorSums[i] = new Vector3f();
        }
        this.currentMesh.sumVertexNormals(vectorSums);
        Enumeration e = this.assocGridPointMap.keys();
        while (e.hasMoreElements()) {
            I = (Integer)e.nextElement();
            ((Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(I))).add(vectorSums[I]);
        }
        e = this.assocGridPointMap.keys();
        while (e.hasMoreElements()) {
            I = (Integer)e.nextElement();
            vectorSums[I.intValue()] = (Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(I));
        }
        this.currentMesh.normixes = new short[vertexCount];
        short[] norm = this.currentMesh.normixes;
        if (use2Sided) {
            int i2 = vertexCount;
            while (--i2 >= 0) {
                norm[i2] = this.g3d.get2SidedNormix(vectorSums[i2]);
            }
        } else {
            int i3 = vertexCount;
            while (--i3 >= 0) {
                norm[i3] = this.g3d.getNormix(vectorSums[i3]);
            }
        }
    }

    void applyColorScale(Mesh mesh) {
        int incr;
        if (this.colorPhase == 0 && this.dataType != 14) {
            this.colorPhase = 1;
        }
        int vertexCount = mesh.vertexCount;
        short[] colixes = mesh.vertexColixes;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.setMapRanges();
        float min = this.mappedDataMin;
        float max = this.mappedDataMax;
        Logger.info("full mapped data range: " + min + " to " + max);
        if (this.isBicolorMap && this.thePlane == null || this.colorBySign) {
            Logger.info("coloring by sign");
        } else if (this.colorByPhase) {
            Logger.info("coloring by phase: " + colorPhases[this.colorPhase]);
        } else {
            Logger.info("coloring red to blue over range: " + this.valueMappedToRed + " to " + this.valueMappedToBlue);
        }
        if (colixes == null) {
            mesh.vertexColixes = colixes = new short[vertexCount];
        }
        String list = "";
        String list1 = "";
        int n = incr = mesh.hasGridPoints && mesh.jvxlPlane == null ? 3 : 1;
        if (this.jvxlDataIsPrecisionColor || this.isContoured) {
            this.jvxlWritePrecisionColor = true;
        }
        for (int i = 0; i < vertexCount; i += incr) {
            char ch;
            float value = this.getVertexColorValue(mesh, i);
            if (mesh.firstViewableVertex != 0 && i >= mesh.firstViewableVertex) continue;
            if (this.jvxlWritePrecisionColor) {
                ch = this.jvxlValueAsCharacter2(value, min, max, this.colorFractionBase, this.colorFractionRange);
                list1 = list1 + this.remainder;
                if (this.logCompression) {
                    Logger.debug("setcolor precision " + value + " as '" + ch + this.jvxlValueFromCharacter2(ch, this.remainder, min, max, this.colorFractionBase, this.colorFractionRange) + "'/remainder=" + this.remainder + " ");
                }
            } else {
                ch = this.jvxlValueAsCharacter(value, this.valueMappedToRed, this.valueMappedToBlue, this.colorFractionBase, this.colorFractionRange);
                if (this.logCompression) {
                    Logger.info("setcolor noprecision " + value + " as " + ch);
                }
            }
            list = list + ch;
        }
        mesh.isJvxlPrecisionColor = this.jvxlWritePrecisionColor;
        String string = mesh.jvxlColorData = this.colorByPhase && !this.isBicolorMap && !this.colorBySign ? "" : list + list1 + "\n";
        if (this.logMessages) {
            Logger.info("color data: " + mesh.jvxlColorData);
        }
    }

    float getVertexColorValue(Mesh mesh, int vertexIndex) {
        float value;
        float datum = this.isBicolorMap && !this.isContoured ? (value = mesh.vertexValues[vertexIndex]) : (this.colorByPhase ? (value = this.getPhase(mesh.vertices[vertexIndex])) : (this.jvxlDataIs2dContour ? (value = this.getInterpolatedPixelValue(mesh.vertices[vertexIndex])) : (value = this.lookupInterpolatedVoxelValue(mesh.vertices[vertexIndex]))));
        if (this.isBicolorMap && !this.isContoured || this.colorBySign) {
            if (value <= 0.0f) {
                mesh.vertexColixes[vertexIndex] = Graphics3D.getColix(this.isColorReversed ? this.colorPos : this.colorNeg);
            }
            if (value > 0.0f) {
                mesh.vertexColixes[vertexIndex] = Graphics3D.getColix(this.isColorReversed ? this.colorNeg : this.colorPos);
            }
            if (!this.isContoured) {
                datum = value > 0.0f ? 0.999f : -0.999f;
            }
        } else {
            if (value < this.valueMappedToRed) {
                value = this.valueMappedToRed;
            }
            if (value >= this.valueMappedToBlue) {
                value = this.valueMappedToBlue;
            }
            mesh.vertexColixes[vertexIndex] = this.viewer.getColixFromPalette(this.isColorReversed ? this.valueMappedToBlue + this.valueMappedToRed - value : value, this.valueMappedToRed, this.valueMappedToBlue, this.colorScheme);
        }
        return datum;
    }

    float getPhase(Point3f pt) {
        this.ptPsi.set(pt);
        this.getCalcPoint(this.ptPsi);
        switch (this.colorPhase) {
            case 0: {
                return this.hydrogenAtomPsiAt(this.ptPsi, this.psi_n, this.psi_l, this.psi_m) > 0.0 ? 1 : -1;
            }
            case -1: 
            case 1: {
                return pt.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return pt.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return pt.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return pt.x * pt.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return pt.y * pt.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return pt.x * pt.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return pt.z * pt.z * 2.0f - pt.x * pt.x - pt.y * pt.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    float getMinMappedValue() {
        if (this.currentMesh != null) {
            return this.getMinMappedValue(this.currentMesh);
        }
        float min = Float.MAX_VALUE;
        int i = this.meshCount;
        while (--i >= 0) {
            float challenger = this.getMinMappedValue(this.meshes[i]);
            if (!(challenger < min)) continue;
            min = challenger;
        }
        Logger.debug("minimum mapped value: " + min);
        return min;
    }

    float getMinMappedValue(Mesh mesh) {
        int vertexCount = mesh.vertexCount;
        Point3f[] vertexes = mesh.vertices;
        float min = Float.MAX_VALUE;
        int incr = mesh.hasGridPoints ? 3 : 1;
        for (int i = 0; i < vertexCount; i += incr) {
            float challenger;
            if (mesh.firstViewableVertex != 0 && i >= mesh.firstViewableVertex || !((challenger = this.jvxlDataIs2dContour ? this.getInterpolatedPixelValue(vertexes[i]) : this.lookupInterpolatedVoxelValue(vertexes[i])) < min)) continue;
            min = challenger;
        }
        Logger.debug("minimum mapped value: " + min);
        return min;
    }

    float getMaxMappedValue() {
        if (this.currentMesh != null) {
            return this.getMaxMappedValue(this.currentMesh);
        }
        float max = -3.4028235E38f;
        int i = this.meshCount;
        while (--i >= 0) {
            float challenger = this.getMaxMappedValue(this.meshes[i]);
            if (!(challenger > max)) continue;
            max = challenger;
        }
        return max;
    }

    float getMaxMappedValue(Mesh mesh) {
        int vertexCount = mesh.vertexCount;
        Point3f[] vertexes = mesh.vertices;
        float max = -3.4028235E38f;
        int incr = mesh.hasGridPoints ? 3 : 1;
        for (int i = 0; i < vertexCount; i += incr) {
            if (mesh.firstViewableVertex != 0 && i >= mesh.firstViewableVertex) continue;
            float challenger = this.jvxlDataIs2dContour ? this.getInterpolatedPixelValue(vertexes[i]) : this.lookupInterpolatedVoxelValue(vertexes[i]);
            if (challenger == Float.MAX_VALUE) {
                challenger = 0.0f;
            }
            if (!(challenger > max) || challenger == Float.MAX_VALUE) continue;
            max = challenger;
        }
        Logger.debug("maximum mapped value: " + max);
        return max;
    }

    float lookupInterpolatedVoxelValue(Point3f point) {
        Point3f pt = new Point3f();
        this.xyzToVoxelPt(point, pt);
        return this.getInterpolatedVoxelValue(pt);
    }

    float getInterpolatedVoxelValue(Point3f pt) {
        int iMax = this.voxelCounts[0] - 1;
        int xDown = this.indexDown(pt.x, iMax);
        int xUp = xDown + (pt.x < 0.0f || xDown == iMax ? 0 : 1);
        iMax = this.voxelCounts[1] - 1;
        int yDown = this.indexDown(pt.y, iMax);
        int yUp = yDown + (pt.y < 0.0f || yDown == iMax ? 0 : 1);
        iMax = this.voxelCounts[2] - 1;
        int zDown = this.indexDown(pt.z, iMax);
        int zUp = zDown + (pt.z < 0.0f || zDown == iMax || this.jvxlDataIs2dContour ? 0 : 1);
        float v1 = this.getFractional2DValue(pt.x - (float)xDown, pt.y - (float)yDown, this.voxelData[xDown][yDown][zDown], this.voxelData[xUp][yDown][zDown], this.voxelData[xDown][yUp][zDown], this.voxelData[xUp][yUp][zDown]);
        float v2 = this.getFractional2DValue(pt.x - (float)xDown, pt.y - (float)yDown, this.voxelData[xDown][yDown][zUp], this.voxelData[xUp][yDown][zUp], this.voxelData[xDown][yUp][zUp], this.voxelData[xUp][yUp][zUp]);
        return v1 + (pt.z - (float)zDown) * (v2 - v1);
    }

    float getInterpolatedPixelValue(Point3f ptXYZ) {
        int xDown;
        this.pointVector.set(ptXYZ);
        this.xyzToPixelVector(this.pointVector);
        float x = this.pointVector.x;
        float y = this.pointVector.y;
        int n = x >= (float)this.pixelCounts[0] ? this.pixelCounts[0] - 1 : (xDown = x < 0.0f ? 0 : (int)x);
        int yDown = y >= (float)this.pixelCounts[1] ? this.pixelCounts[1] - 1 : (y < 0.0f ? 0 : (int)y);
        int xUp = xDown + (xDown == this.pixelCounts[0] - 1 ? 0 : 1);
        int yUp = yDown + (yDown == this.pixelCounts[1] - 1 ? 0 : 1);
        float value = this.getFractional2DValue(x - (float)xDown, y - (float)yDown, this.pixelData[xDown][yDown], this.pixelData[xUp][yDown], this.pixelData[xDown][yUp], this.pixelData[xUp][yUp]);
        return value;
    }

    int indexDown(float value, int iMax) {
        if (value < 0.0f) {
            return 0;
        }
        int floor = (int)value;
        return floor > iMax ? iMax : floor;
    }

    float getFractional2DValue(float fx, float fy, float x11, float x12, float x21, float x22) {
        float v1 = x11 + fx * (x12 - x11);
        float v2 = x21 + fx * (x22 - x21);
        return v1 + fy * (v2 - v1);
    }

    void jvxlReadColorData(Mesh mesh) {
        this.fractionPtr = 0;
        int vertexCount = mesh.vertexCount;
        short[] colixes = mesh.vertexColixes;
        this.fractionData = new StringBuffer();
        this.strFractionTemp = this.isJvxl ? this.jvxlColorDataRead : "";
        this.fractionPtr = 0;
        Logger.info("JVXL reading color data base/range: " + this.mappedDataMin + "/" + this.mappedDataMax + " for " + vertexCount + " vertices." + " using encoding keys " + this.colorFractionBase + " " + this.colorFractionRange);
        Logger.info("mapping red-->blue for " + this.valueMappedToRed + " to " + this.valueMappedToBlue + " colorPrecision:" + this.jvxlDataIsPrecisionColor);
        float min = this.mappedDataMin == Float.MAX_VALUE ? 0.0f : this.mappedDataMin;
        float range = (this.mappedDataMin == Float.MAX_VALUE ? 1.0f : this.mappedDataMax) - min;
        float colorRange = this.valueMappedToBlue - this.valueMappedToRed;
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        if (colixes == null || colixes.length < vertexCount) {
            mesh.vertexColixes = colixes = new short[vertexCount];
        }
        int n = this.isContoured ? this.contourVertexCount : vertexCount;
        String data = this.jvxlColorDataRead;
        int cpt = 0;
        for (int i = 0; i < n; ++i) {
            float value;
            float fraction;
            if (this.jvxlDataIsPrecisionColor) {
                fraction = this.jvxlFractionFromCharacter2(data.charAt(cpt), data.charAt(cpt + n), this.colorFractionBase, this.colorFractionRange);
                value = min + fraction * range;
            } else {
                fraction = this.jvxlFractionFromCharacter(data.charAt(cpt), this.colorFractionBase, this.colorFractionRange, 0.5f);
                value = this.valueMappedToRed + fraction * colorRange;
            }
            ++cpt;
            if (value < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = value;
            }
            if (value > this.contourPlaneMaximumValue) {
                this.contourPlaneMaximumValue = value;
            }
            if (this.isContoured) {
                this.contourVertexes[i].setValue(value);
                continue;
            }
            if (this.colorBySign) {
                colixes[i] = Graphics3D.getColix((this.isColorReversed ? value > 0.0f : value <= 0.0f) ? this.colorNeg : this.colorPos);
                continue;
            }
            colixes[i] = this.viewer.getColixFromPalette(this.isColorReversed ? this.valueMappedToRed + this.valueMappedToBlue - value : value, this.valueMappedToRed, this.valueMappedToBlue, this.colorScheme);
            if (this.logMessages) {
                Logger.info("readColor " + i + ": " + fraction + " " + value + " " + this.valueMappedToRed + " " + this.valueMappedToBlue + " " + colixes[i]);
            }
            if (!mesh.hasGridPoints) continue;
            colixes[++i] = this.viewer.getColixFromPalette(0.2f, 0.0f, 1.0f, this.colorScheme);
            colixes[++i] = this.viewer.getColixFromPalette(0.8f, 0.0f, 1.0f, this.colorScheme);
        }
        if (this.mappedDataMin == Float.MAX_VALUE) {
            this.mappedDataMin = this.contourPlaneMinimumValue;
            this.mappedDataMax = this.contourPlaneMaximumValue;
        }
        mesh.jvxlColorData = data + "\n";
    }

    float jvxlGetNextFraction(int base, int range, float fracOffset) {
        if (this.fractionPtr >= this.strFractionTemp.length()) {
            if (!this.endOfData) {
                Logger.error("end of file reading compressed fraction data at point " + this.fractionData.length());
            }
            this.endOfData = true;
            this.strFractionTemp = "" + (char)base;
            this.fractionData.append(this.strFractionTemp);
            this.fractionData.append('\n');
            this.fractionPtr = 0;
        }
        return this.jvxlFractionFromCharacter(this.strFractionTemp.charAt(this.fractionPtr++), base, range, fracOffset);
    }

    float jvxlValueFromCharacter(int ich, float min, float max, int base, int range, float fracOffset) {
        float fraction = this.jvxlFractionFromCharacter(ich, base, range, fracOffset);
        return max == min ? fraction : min + fraction * (max - min);
    }

    float jvxlFractionFromCharacter(int ich, int base, int range, float fracOffset) {
        float fraction;
        if (ich < base) {
            ich = 92;
        }
        if ((fraction = ((float)(ich - base) + fracOffset) / (float)range) < 0.0f) {
            fraction = 0.0f;
        }
        if (fraction > 1.0f) {
            fraction = 0.999999f;
        }
        if (ich == base + range) {
            fraction = Float.NaN;
        }
        if (this.logCompression) {
            Logger.info("ffc: " + fraction + " <-- " + ich + " " + (char)ich);
        }
        return fraction;
    }

    char jvxlValueAsCharacter(float value, float min, float max, int base, int range) {
        float fraction = min == max ? value : (value - min) / (max - min);
        return this.jvxlFractionAsCharacter(fraction, base, range);
    }

    char jvxlFractionAsCharacter(float fraction, int base, int range) {
        int ich;
        if (fraction > 0.9999f) {
            fraction = 0.9999f;
        }
        if (Float.isNaN(fraction)) {
            fraction = 1.0001f;
        }
        if ((ich = (int)(fraction * (float)range + (float)base)) < base) {
            ich = base;
        }
        if (ich == 92) {
            ich = 33;
        }
        if (this.logCompression) {
            Logger.info("fac: " + fraction + " --> " + ich + " " + (char)ich);
        }
        return (char)ich;
    }

    float jvxlValueFromCharacter2(int ich, int ich2, float min, float max, int base, int range) {
        float fraction = this.jvxlFractionFromCharacter2(ich, ich2, base, range);
        return max == min ? fraction : min + fraction * (max - min);
    }

    float jvxlFractionFromCharacter2(int ich1, int ich2, int base, int range) {
        float fraction = this.jvxlFractionFromCharacter(ich1, base, range, 0.0f);
        float remains = this.jvxlFractionFromCharacter(ich2, base, range, 0.5f);
        if (this.logMessages) {
            Logger.info("fraction:" + fraction + " + " + remains / (float)range + " r=" + range + " " + (char)ich1 + (char)ich2 + " = " + (fraction + remains / (float)range));
        }
        return fraction + remains / (float)range;
    }

    char jvxlValueAsCharacter2(float value, float min, float max, int base, int range) {
        float fraction = min == max ? value : (value - min) / (max - min);
        char ch1 = this.jvxlFractionAsCharacter(fraction, base, range);
        this.remainder = this.jvxlFractionAsCharacter((fraction -= this.jvxlFractionFromCharacter(ch1, base, range, 0.0f)) * (float)range, base, range);
        return ch1;
    }

    String jvxlExtraLine(int n) {
        return -n + " " + this.edgeFractionBase + " " + this.edgeFractionRange + " " + this.colorFractionBase + " " + this.colorFractionRange + " Jmol voxel format version 0.9f\n";
    }

    String jvxlGetFile(Mesh mesh, String msg, boolean includeHeader, int nSurfaces) {
        String compressedData;
        String data = "";
        if (includeHeader && (data = mesh.jvxlFileHeader + (nSurfaces > 0 ? -nSurfaces + mesh.jvxlExtraLine.substring(2) : mesh.jvxlExtraLine)).indexOf("JVXL") != 0) {
            data = "JVXL " + data;
        }
        data = data + "# " + msg + "\n";
        if (this.title != null) {
            for (int i = 0; i < this.title.length; ++i) {
                data = data + "# " + this.title[i] + "\n";
            }
        }
        data = data + mesh.jvxlDefinitionLine + "\n";
        String string = compressedData = mesh.jvxlPlane == null ? mesh.jvxlSurfaceData : "";
        if (this.logMessages) {
            Logger.info(" jvxlGetFile: " + mesh.jvxlSurfaceData + "\n" + mesh.jvxlEdgeData + "\n" + mesh.jvxlColorData + "\n" + mesh.jvxlPlane);
        }
        compressedData = mesh.jvxlPlane == null ? compressedData + this.jvxlCompressString(mesh.jvxlEdgeData + mesh.jvxlColorData) : compressedData + this.jvxlCompressString(mesh.jvxlColorData);
        if (!this.isJvxl && mesh.nBytes > 0) {
            mesh.jvxlCompressionRatio = (int)(((float)mesh.nBytes + (float)mesh.jvxlFileHeader.length()) / (float)(data.length() + compressedData.length()));
        }
        data = data + compressedData;
        if (msg != null) {
            data = data + "#-------end of jvxl file data-------\n";
        }
        return data;
    }

    String jvxlGetDefinitionLine(Mesh mesh) {
        String definitionLine = mesh.cutoff + " ";
        int nSurfaceData = mesh.jvxlSurfaceData.length();
        int nEdgeData = mesh.jvxlEdgeData.length() - 1;
        int nColorData = mesh.jvxlColorData.length() - 1;
        if (mesh.jvxlPlane == null) {
            definitionLine = mesh.isContoured ? definitionLine + -nSurfaceData + " " + nEdgeData : (mesh.isBicolorMap ? definitionLine + nSurfaceData + " " + -nEdgeData : definitionLine + nSurfaceData + " " + nEdgeData);
            definitionLine = definitionLine + " " + (mesh.isJvxlPrecisionColor && nColorData != -1 ? -nColorData : nColorData);
        } else {
            definitionLine = definitionLine + "-1 -2 " + -nColorData + " " + mesh.jvxlPlane.x + " " + mesh.jvxlPlane.y + " " + mesh.jvxlPlane.z + " " + mesh.jvxlPlane.w;
        }
        if (mesh.isContoured) {
            definitionLine = definitionLine + " " + mesh.nContours;
        }
        definitionLine = definitionLine + " " + mesh.mappedDataMin + " " + mesh.mappedDataMax + " " + mesh.valueMappedToRed + " " + mesh.valueMappedToBlue;
        if (mesh.jvxlPlane != null) {
            definitionLine = definitionLine + " CONTOUR PLANE " + mesh.jvxlPlane;
        }
        if (mesh.jvxlCompressionRatio > 0) {
            definitionLine = definitionLine + " approximate compressionRatio=" + mesh.jvxlCompressionRatio + ":1";
        }
        return definitionLine;
    }

    String jvxlCompressString(String data) {
        if (this.logCompression) {
            Logger.info(data.length() + " compressing\n" + data);
        }
        String dataOut = "";
        String dataBuffer = "";
        char chLast = '\u0000';
        data = data + '\u0000';
        int nLast = 0;
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == chLast) {
                ++nLast;
                dataBuffer = dataBuffer + ch;
                if (ch != '~') {
                    ch = '\u0000';
                }
            } else if (nLast > 0) {
                dataOut = dataOut + (nLast < 4 || chLast == '~' || chLast == ' ' || chLast == '\t' ? dataBuffer : "~" + nLast + " ");
                dataBuffer = "";
                nLast = 0;
            }
            if (ch == '\u0000') continue;
            dataOut = dataOut + ch;
            chLast = ch;
        }
        if (this.logCompression) {
            Logger.info(dataOut.length() + "\n" + dataOut);
            data = this.jvxlUncompressString(dataOut);
            Logger.info(data.length() + " uncompressing\n" + data);
        }
        return dataOut;
    }

    String jvxlUncompressString(String data) {
        if (data.indexOf("~") < 0) {
            return data;
        }
        if (this.logCompression) {
            Logger.info(data.length() + " uncompressing\n" + data);
        }
        String dataOut = "";
        char chLast = '\u0000';
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '~') {
                int nChar;
                if ((nChar = this.parseInt(data, ++i)) == Integer.MIN_VALUE) {
                    if (chLast == '~') {
                        dataOut = dataOut + '~';
                        while ((ch = data.charAt(++i)) == '~') {
                            dataOut = dataOut + '~';
                        }
                        continue;
                    }
                    Logger.error("Error uncompressing string " + data.substring(0, i) + "?");
                    continue;
                }
                for (int c = 0; c < nChar; ++c) {
                    dataOut = dataOut + chLast;
                }
                i = this.ichNextParse;
                continue;
            }
            dataOut = dataOut + ch;
            chLast = ch;
        }
        if (this.logCompression) {
            Logger.info(dataOut.length() + "\n" + dataOut);
        }
        return dataOut;
    }

    int getContourType(Point4f plane) {
        Vector3f norm = new Vector3f(plane.x, plane.y, plane.z);
        float dotX = norm.dot(this.volumetricVectors[0]);
        float dotY = norm.dot(this.volumetricVectors[1]);
        float dotZ = norm.dot(this.volumetricVectors[2]);
        dotX *= dotX;
        dotY *= dotY;
        dotZ *= dotZ;
        float max = dotX;
        if (max < dotY) {
            max = dotY;
        }
        int iType = max < dotZ ? 2 : (max == dotY ? 1 : 0);
        Logger.info("contouring planar pixel subset " + iType);
        return iType;
    }

    void generateSurfaceData() {
        this.cubeCountX = this.voxelData.length - 1;
        this.cubeCountY = this.voxelData[0].length - 1;
        this.cubeCountZ = this.voxelData[0][0].length - 1;
        this.fractionData = new StringBuffer();
        this.strFractionTemp = this.isJvxl ? this.jvxlEdgeDataRead : "";
        this.fractionPtr = 0;
        if (this.thePlane != null) {
            this.contourVertexCount = 0;
            this.contourType = this.getContourType(this.thePlane);
        } else if (this.isContoured) {
            this.contourVertexCount = 0;
            this.contourType = 2;
        }
        if (!this.isSilent || this.logMessages) {
            Logger.info("cutoff=" + this.cutoff + " voxel cubes=" + this.cubeCountX + "," + this.cubeCountY + "," + this.cubeCountZ + "," + " total=" + this.cubeCountX * this.cubeCountY * this.cubeCountZ);
            Logger.info("resolutions(x,y,z)=" + 1.0f / this.volumetricVectors[0].length() + "," + 1.0f / this.volumetricVectors[1].length() + "," + 1.0f / this.volumetricVectors[2].length());
        }
        int[][] isoPointIndexes = new int[this.cubeCountY * this.cubeCountZ][12];
        int i = this.cubeCountY * this.cubeCountZ;
        while (--i >= 0) {
            isoPointIndexes[i] = new int[12];
        }
        int insideCount = 0;
        int outsideCount = 0;
        int surfaceCount = 0;
        int x = this.cubeCountX;
        while (--x >= 0) {
            int y = this.cubeCountY;
            while (--y >= 0) {
                int z = this.cubeCountZ;
                while (--z >= 0) {
                    int[] voxelPointIndexes = this.propagateNeighborPointIndexes(x, y, z, isoPointIndexes);
                    int insideMask = 0;
                    int i2 = 8;
                    while (--i2 >= 0) {
                        float voxelValue;
                        Point3i offset = cubeVertexOffsets[i2];
                        this.vertexValues[i2] = voxelValue = this.voxelData[x + offset.x][y + offset.y][z + offset.z];
                        if (this.logCube) {
                            this.vertexPoints[i2].set(x + offset.x, y + offset.y, z + offset.z);
                        }
                        if (!this.isInside(voxelValue, this.cutoff)) continue;
                        insideMask |= 1 << i2;
                    }
                    if (insideMask == 0) {
                        ++outsideCount;
                        continue;
                    }
                    if (insideMask == 255) {
                        ++insideCount;
                        continue;
                    }
                    ++surfaceCount;
                    if (!this.processOneCubical(insideMask, this.cutoff, voxelPointIndexes, x, y, z) || this.isContoured) continue;
                    byte[] triangles = triangleTable[insideMask];
                    int i3 = triangles.length;
                    while ((i3 -= 3) >= 0) {
                        if (this.isCutoffAbsolute && !this.checkCutoff(voxelPointIndexes[triangles[i3]], voxelPointIndexes[triangles[i3 + 1]], voxelPointIndexes[triangles[i3 + 2]])) continue;
                        this.currentMesh.addTriangle(voxelPointIndexes[triangles[i3]], voxelPointIndexes[triangles[i3 + 1]], voxelPointIndexes[triangles[i3 + 2]]);
                    }
                }
            }
        }
        if (this.isJvxl) {
            this.fractionData = new StringBuffer();
            this.fractionData.append(this.jvxlEdgeDataRead);
        }
        this.fractionData.append('\n');
        if (!this.isSilent || this.logMessages) {
            Logger.info("insideCount=" + insideCount + " outsideCount=" + outsideCount + " surfaceCount=" + surfaceCount + " total=" + (insideCount + outsideCount + surfaceCount));
        }
    }

    boolean checkCutoff(int v1, int v2, int v3) {
        if (v1 < 0 || v2 < 0 || v3 < 0) {
            return false;
        }
        float val1 = this.currentMesh.vertexValues[v1];
        float val2 = this.currentMesh.vertexValues[v2];
        float val3 = this.currentMesh.vertexValues[v3];
        return val1 * val2 >= 0.0f && val2 * val3 >= 0.0f;
    }

    boolean isInside(float voxelValue, float max) {
        return max > 0.0f && (this.isCutoffAbsolute ? Math.abs(voxelValue) : voxelValue) >= max || max <= 0.0f && voxelValue <= max;
    }

    int[] propagateNeighborPointIndexes(int x, int y, int z, int[][] isoPointIndexes) {
        boolean noXNeighbor;
        int cellIndex = y * this.cubeCountZ + z;
        int[] voxelPointIndexes = isoPointIndexes[cellIndex];
        boolean bl = noXNeighbor = x == this.cubeCountX - 1;
        if (noXNeighbor) {
            voxelPointIndexes[1] = -1;
            voxelPointIndexes[9] = -1;
            voxelPointIndexes[5] = -1;
            voxelPointIndexes[10] = -1;
        } else {
            voxelPointIndexes[1] = voxelPointIndexes[3];
            voxelPointIndexes[9] = voxelPointIndexes[8];
            voxelPointIndexes[5] = voxelPointIndexes[7];
            voxelPointIndexes[10] = voxelPointIndexes[11];
        }
        boolean noYNeighbor = y == this.cubeCountY - 1;
        int[] yNeighbor = noYNeighbor ? this.nullNeighbor : isoPointIndexes[cellIndex + this.cubeCountZ];
        voxelPointIndexes[6] = yNeighbor[2];
        voxelPointIndexes[7] = yNeighbor[3];
        voxelPointIndexes[4] = yNeighbor[0];
        if (noXNeighbor) {
            voxelPointIndexes[5] = yNeighbor[1];
        }
        boolean noZNeighbor = z == this.cubeCountZ - 1;
        int[] zNeighbor = noZNeighbor ? this.nullNeighbor : isoPointIndexes[cellIndex + 1];
        voxelPointIndexes[2] = zNeighbor[0];
        voxelPointIndexes[11] = zNeighbor[8];
        if (noYNeighbor) {
            voxelPointIndexes[6] = zNeighbor[4];
        }
        if (noXNeighbor) {
            voxelPointIndexes[10] = zNeighbor[9];
        }
        voxelPointIndexes[0] = -1;
        voxelPointIndexes[3] = -1;
        voxelPointIndexes[8] = -1;
        return voxelPointIndexes;
    }

    boolean processOneCubical(int insideMask, float cutoff, int[] voxelPointIndexes, int x, int y, int z) {
        short edgeMask = insideMaskTable[insideMask];
        boolean isNaN = false;
        int iEdge = 12;
        while (--iEdge >= 0) {
            int assocVertex;
            if ((edgeMask & 1 << iEdge) == 0 || voxelPointIndexes[iEdge] >= 0) continue;
            ++this.edgeCount;
            byte vertexA = edgeVertexes[2 * iEdge];
            byte vertexB = edgeVertexes[2 * iEdge + 1];
            float valueA = this.vertexValues[vertexA];
            float valueB = this.vertexValues[vertexB];
            if (Float.isNaN(valueA) || Float.isNaN(valueB)) {
                isNaN = true;
            }
            this.calcVertexPoints(x, y, z, vertexA, vertexB);
            float fraction = this.calcSurfacePoint(cutoff, valueA, valueB, this.surfacePoints[iEdge]);
            if (this.isContoured) {
                int vPt = Integer.MAX_VALUE;
                if (edgeTypeTable[iEdge] == this.contourType) {
                    vPt = this.addContourData(x, y, z, cubeVertexOffsets[vertexA], this.surfacePoints[iEdge], cutoff);
                }
                voxelPointIndexes[iEdge] = vPt;
                continue;
            }
            int n = fraction < 0.3f ? -1 : (assocVertex = fraction > 0.7f ? 1 : 0);
            String sKey = assocVertex == 0 ? "" : this.calcDataKey(x, y, z, assocVertex < 0 ? vertexA : vertexB);
            voxelPointIndexes[iEdge] = this.addVertexCopy(this.surfacePoints[iEdge], this.thisValue, assocVertex != 0, sKey);
            if (this.logCube) {
                Logger.info("edge " + this.vertexPoints[vertexA] + " " + this.vertexPoints[vertexB] + " surface " + this.surfacePoints[iEdge] + " " + this.thisValue);
            }
            if (!this.iAddGridPoints) continue;
            this.addVertexCopy(valueA < valueB ? this.pointA : this.pointB, Float.NaN, false, "");
            this.addVertexCopy(valueA < valueB ? this.pointB : this.pointA, Float.NaN, false, "");
        }
        return !isNaN;
    }

    String calcDataKey(int x, int y, int z, int vertexPt) {
        Point3i offset = cubeVertexOffsets[vertexPt];
        return x + offset.x + "_" + (y + offset.y) + "_" + (z + offset.z);
    }

    float calcSurfacePoint(float cutoff, float valueA, float valueB, Point3f surfacePoint) {
        float fraction;
        if (this.isJvxl && this.jvxlEdgeDataCount > 0) {
            this.thisValue = fraction = this.jvxlGetNextFraction(this.edgeFractionBase, this.edgeFractionRange, 0.5f);
        } else {
            float diff = valueB - valueA;
            fraction = (cutoff - valueA) / diff;
            if (this.isCutoffAbsolute && (fraction < 0.0f || fraction > 1.0f)) {
                fraction = (-cutoff - valueA) / diff;
            }
            if (fraction < 0.0f || fraction > 1.0f) {
                Logger.error("problem with unusual fraction=" + fraction + " cutoff=" + cutoff + " A:" + valueA + " B:" + valueB);
                fraction = Float.NaN;
            }
            this.thisValue = valueA + fraction * diff;
            if (!this.isJvxl) {
                this.fractionData.append(this.jvxlFractionAsCharacter(fraction, this.edgeFractionBase, this.edgeFractionRange));
            }
        }
        this.edgeVector.sub(this.pointB, this.pointA);
        surfacePoint.scaleAdd(fraction, this.edgeVector, this.pointA);
        return fraction;
    }

    void calcVertexPoints(int x, int y, int z, int vertexA, int vertexB) {
        this.voxelPtToXYZ(x, y, z, this.voxelOrigin);
        this.pointA.add(this.voxelOrigin, this.voxelVertexVectors[vertexA]);
        this.pointB.add(this.voxelOrigin, this.voxelVertexVectors[vertexB]);
    }

    void calcVoxelVertexVectors() {
        int i = 8;
        while (--i >= 0) {
            this.voxelVertexVectors[i] = new Vector3f();
            this.volumetricMatrix.transform(cubeVertexVectors[i], this.voxelVertexVectors[i]);
        }
        if (this.logMessages) {
            for (i = 0; i < 8; ++i) {
                Logger.info("voxelVertexVectors[" + i + "]=" + this.voxelVertexVectors[i]);
            }
        }
    }

    void generateContourData(boolean iHaveContourVertexesAlready) {
        if (this.nContours == 0 || this.nContours > 100) {
            this.nContours = 11;
        }
        Logger.info("generateContours:" + this.nContours);
        this.getPlanarVectors();
        this.setPlanarTransform();
        this.getPlanarOrigin();
        this.setupMatrix(this.planarMatrix, this.planarVectors);
        this.calcPixelVertexVectors();
        this.getPixelCounts();
        this.createPlanarSquares();
        this.loadPixelData(iHaveContourVertexesAlready);
        if (this.logMessages) {
            int n = this.pixelCounts[0] / 2;
            Logger.info(this.dumpArray("generateContourData", this.pixelData, n - 4, n + 4, n - 4, n + 4));
        }
        this.createContours();
        this.triangulateContours();
    }

    void getPlanarVectors() {
        this.planarVectors[2].set(0.0f, 0.0f, 0.0f);
        if (this.thePlane == null) {
            return;
        }
        Vector3f vZ = this.volumetricVectors[this.contourType];
        float vZdotNorm = vZ.dot(this.thePlaneNormal);
        switch (this.contourType) {
            case 0: {
                this.planarVectors[0].scaleAdd(-this.volumetricVectors[1].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[1]);
                this.planarVectors[1].scaleAdd(-this.volumetricVectors[2].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[2]);
                break;
            }
            case 1: {
                this.planarVectors[0].scaleAdd(-this.volumetricVectors[2].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[2]);
                this.planarVectors[1].scaleAdd(-this.volumetricVectors[0].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[0]);
                break;
            }
            case 2: {
                this.planarVectors[0].scaleAdd(-this.volumetricVectors[0].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[0]);
                this.planarVectors[1].scaleAdd(-this.volumetricVectors[1].dot(this.thePlaneNormal) / vZdotNorm, vZ, this.volumetricVectors[1]);
            }
        }
    }

    void setPlanarTransform() {
        int i;
        this.planarVectorLengths[0] = this.planarVectors[0].length();
        this.planarVectorLengths[1] = this.planarVectors[1].length();
        this.unitPlanarVectors[0].normalize(this.planarVectors[0]);
        this.unitPlanarVectors[1].normalize(this.planarVectors[1]);
        this.unitPlanarVectors[2].cross(this.unitPlanarVectors[0], this.unitPlanarVectors[1]);
        this.setupMatrix(this.matXyzToPlane, this.unitPlanarVectors);
        this.matXyzToPlane.invert();
        float alpha = this.planarVectors[0].angle(this.planarVectors[1]);
        Logger.info("planar axes type " + this.contourType + " axis angle = " + (double)alpha / Math.PI * 180.0 + " normal=" + this.unitPlanarVectors[2]);
        for (i = 0; i < 2; ++i) {
            Logger.info("planar vectors / lengths:" + this.planarVectors[i] + " / " + this.planarVectorLengths[i]);
        }
        for (i = 0; i < 3; ++i) {
            Logger.info("unit orthogonal plane vectors:" + this.unitPlanarVectors[i]);
        }
    }

    void getPlanarOrigin() {
        this.planarOrigin.set(0.0f, 0.0f, 0.0f);
        if (this.contourVertexCount == 0) {
            return;
        }
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        this.planarOrigin.set(this.contourVertexes[0].vertexXYZ);
        for (int i = 0; i < this.contourVertexCount; ++i) {
            this.pointVector.set(this.contourVertexes[i].vertexXYZ);
            this.xyzToPixelVector(this.pointVector);
            if (this.logMessages && i < 10) {
                Logger.info("getPlanarOrigin: " + this.contourVertexes[i].vertexXYZ + " is 2D: " + this.pointVector);
            }
            if (this.pointVector.x < minX) {
                minX = this.pointVector.x;
            }
            if (!(this.pointVector.y < minY)) continue;
            minY = this.pointVector.y;
        }
        if (this.logMessages) {
            Logger.info("getPlanarOrigin: minX, minY: " + minX + "," + minY);
        }
        this.planarOrigin.set(this.pixelPtToXYZ((int)(minX * 1.0001f), (int)(minY * 1.0001f)));
        Logger.info("generatePixelData planarOrigin = " + this.planarOrigin + ":" + this.locatePixel(this.planarOrigin));
    }

    int addContourData(int x, int y, int z, Point3i offsets, Point3f vertexXYZ, float value) {
        if (this.contourVertexes == null) {
            this.contourVertexes = new ContourVertex[256];
        }
        if (this.contourVertexCount == this.contourVertexes.length) {
            this.contourVertexes = (ContourVertex[])ArrayUtil.doubleLength(this.contourVertexes);
        }
        int vPt = this.addVertexCopy(vertexXYZ, value, false, "");
        this.contourVertexes[this.contourVertexCount++] = new ContourVertex(x += offsets.x, y += offsets.y, z += offsets.z, vertexXYZ, vPt);
        if ((double)Math.abs(value) < 1.0E-7) {
            this.currentMesh.invalidateVertex(vPt);
        }
        this.currentMesh.firstViewableVertex = this.currentMesh.vertexCount;
        if (this.logMessages) {
            Logger.info("addCountourdata " + x + " " + y + " " + z + offsets + vertexXYZ + value);
        }
        return vPt;
    }

    void getPixelCounts() {
        if (this.thePlane == null) {
            return;
        }
        int max = 1;
        for (int i = 0; i < 3; ++i) {
            if (i == this.contourType) continue;
            max = Math.max(max, this.voxelCounts[i]);
        }
        this.pixelCounts[0] = this.pixelCounts[1] = max;
        Logger.info("getPixelCounts " + this.pixelCounts[0] + "," + this.pixelCounts[1]);
    }

    void createPlanarSquares() {
        this.squareCountX = this.pixelCounts[0] - 1;
        this.squareCountY = this.pixelCounts[1] - 1;
        this.planarSquares = new PlanarSquare[this.squareCountX * this.squareCountY];
        this.nSquares = 0;
        for (int x = 0; x < this.squareCountX; ++x) {
            for (int y = 0; y < this.squareCountY; ++y) {
                this.planarSquares[this.nSquares++] = new PlanarSquare(null, x, y);
            }
        }
        Logger.info("nSquares = " + this.nSquares);
    }

    void loadPixelData(boolean iHaveContourVertexesAlready) {
        this.pixelData = new float[this.pixelCounts[0]][this.pixelCounts[1]];
        Logger.info("loadPixelData haveContourVertices? " + iHaveContourVertexesAlready);
        this.contourPlaneMinimumValue = Float.MAX_VALUE;
        this.contourPlaneMaximumValue = -3.4028235E38f;
        for (int i = 0; i < this.contourVertexCount; ++i) {
            int y;
            int x;
            float value;
            ContourVertex c = this.contourVertexes[i];
            Point3i pt = this.locatePixel(c.vertexXYZ);
            c.setPixelLocation(pt);
            if (iHaveContourVertexesAlready) {
                value = c.value;
            } else {
                value = this.lookupInterpolatedVoxelValue(c.vertexXYZ);
                c.setValue(value);
            }
            if (value < this.contourPlaneMinimumValue) {
                this.contourPlaneMinimumValue = value;
            }
            if (value > this.contourPlaneMaximumValue) {
                this.contourPlaneMaximumValue = value;
            }
            if (this.logMessages) {
                Logger.info("loadPixelData " + c.vertexXYZ + value + pt);
            }
            if ((x = pt.x) >= 0 && x < this.pixelCounts[0] && (y = pt.y) >= 0 && y < this.pixelCounts[1]) {
                this.pixelData[x][y] = value;
                if (x != this.squareCountX && y != this.squareCountY) {
                    this.planarSquares[x * this.squareCountY + y].setVertex(0, c.vertexIndex);
                }
                if (x != 0 && y != this.squareCountY) {
                    this.planarSquares[(x - 1) * this.squareCountY + y].setVertex(1, c.vertexIndex);
                }
                if (y != 0 && x != this.squareCountX) {
                    this.planarSquares[x * this.squareCountY + y - 1].setVertex(3, c.vertexIndex);
                }
                if (y == 0 || x == 0) continue;
                this.planarSquares[(x - 1) * this.squareCountY + y - 1].setVertex(2, c.vertexIndex);
                continue;
            }
            Logger.error("loadPixelData out of bounds: " + pt.x + " " + pt.y + "?");
        }
    }

    void createContours() {
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.setMapRanges();
        float min = this.valueMappedToRed;
        float max = this.valueMappedToBlue;
        float diff = max - min;
        Logger.info("generateContourData min=" + min + " max=" + max + " nContours=" + this.nContours);
        for (int i = 0; i < this.nContours; ++i) {
            this.contourIndex = i;
            float cutoff = min + (float)i * 1.0f / (float)this.nContours * diff;
            this.generateContourData(cutoff);
        }
    }

    void generateContourData(float contourCutoff) {
        int[][] isoPointIndexes2d = new int[this.squareCountY][4];
        int i = this.squareCountY;
        while (--i >= 0) {
            isoPointIndexes2d[i][3] = -1;
            isoPointIndexes2d[i][2] = -1;
            isoPointIndexes2d[i][1] = -1;
            isoPointIndexes2d[i][0] = -1;
        }
        if ((double)Math.abs(contourCutoff) < 1.0E-4) {
            contourCutoff = contourCutoff <= 0.0f ? -1.0E-4f : 1.0E-4f;
        }
        int insideCount = 0;
        int outsideCount = 0;
        int contourCount = 0;
        int x = this.squareCountX;
        while (--x >= 0) {
            int y = this.squareCountY;
            while (--y >= 0) {
                int[] pixelPointIndexes = this.propagateNeighborPointIndexes2d(x, y, isoPointIndexes2d);
                int insideMask = 0;
                int i2 = 4;
                while (--i2 >= 0) {
                    float vertexValue;
                    Point3i offset = squareVertexOffsets[i2];
                    this.vertexValues2d[i2] = vertexValue = this.pixelData[x + offset.x][y + offset.y];
                    if (!this.isInside2d(vertexValue, contourCutoff)) continue;
                    insideMask |= 1 << i2;
                }
                if (insideMask == 0) {
                    ++outsideCount;
                    continue;
                }
                if (insideMask == 15) {
                    ++insideCount;
                    this.planarSquares[x * this.squareCountY + y].addEdgeMask(this.contourIndex, 0, 15);
                    continue;
                }
                ++contourCount;
                this.processOneQuadrilateral(insideMask, contourCutoff, pixelPointIndexes, x, y);
            }
        }
        if (this.logMessages) {
            Logger.info("contourCutoff=" + contourCutoff + " pixel squares=" + this.squareCountX + "," + this.squareCountY + "," + " total=" + this.squareCountX * this.squareCountY + "\n" + " insideCount=" + insideCount + " outsideCount=" + outsideCount + " contourCount=" + contourCount + " total=" + (insideCount + outsideCount + contourCount));
        }
    }

    boolean isInside2d(float voxelValue, float max) {
        return max > 0.0f && voxelValue >= max || max <= 0.0f && voxelValue <= max;
    }

    int[] propagateNeighborPointIndexes2d(int x, int y, int[][] isoPointIndexes2d) {
        boolean noXNeighbor;
        int[] pixelPointIndexes = isoPointIndexes2d[y];
        boolean bl = noXNeighbor = x == this.squareCountX - 1;
        if (noXNeighbor) {
            pixelPointIndexes[0] = -1;
            pixelPointIndexes[1] = -1;
            pixelPointIndexes[2] = -1;
            pixelPointIndexes[3] = -1;
        } else {
            pixelPointIndexes[1] = pixelPointIndexes[3];
        }
        boolean noYNeighbor = y == this.squareCountY - 1;
        pixelPointIndexes[2] = noYNeighbor ? -1 : isoPointIndexes2d[y + 1][0];
        pixelPointIndexes[0] = -1;
        pixelPointIndexes[3] = -1;
        return pixelPointIndexes;
    }

    void processOneQuadrilateral(int insideMask, float cutoff, int[] pixelPointIndexes, int x, int y) {
        byte edgeMask = insideMaskTable2d[insideMask];
        this.planarSquares[x * this.squareCountY + y].addEdgeMask(this.contourIndex, edgeMask, insideMask);
        int iEdge = 4;
        while (--iEdge >= 0) {
            if ((edgeMask & 1 << iEdge) == 0 || pixelPointIndexes[iEdge] >= 0) continue;
            byte vertexA = edgeVertexes2d[2 * iEdge];
            byte vertexB = edgeVertexes2d[2 * iEdge + 1];
            float valueA = this.vertexValues2d[vertexA];
            float valueB = this.vertexValues2d[vertexB];
            if (this.thePlane == null) {
                this.calcVertexPoints3d(x, y, vertexA, vertexB);
            } else {
                this.calcVertexPoints2d(x, y, vertexA, vertexB);
            }
            this.calcContourPoint(cutoff, valueA, valueB, this.contourPoints[iEdge]);
            pixelPointIndexes[iEdge] = this.addVertexCopy(this.contourPoints[iEdge], cutoff, false, "");
        }
        this.planarSquares[x * this.squareCountY + y].setIntersectionPoints(this.contourIndex, pixelPointIndexes);
    }

    void calcVertexPoints2d(int x, int y, int vertexA, int vertexB) {
        this.pixelOrigin.scaleAdd(x, this.planarVectors[0], this.planarOrigin);
        this.pixelOrigin.scaleAdd(y, this.planarVectors[1], this.pixelOrigin);
        this.pointA.add(this.pixelOrigin, this.pixelVertexVectors[vertexA]);
        this.pointB.add(this.pixelOrigin, this.pixelVertexVectors[vertexB]);
    }

    void calcVertexPoints3d(int x, int y, int vertexA, int vertexB) {
        this.contourLocateXYZ(x + Isosurface.squareVertexOffsets[vertexA].x, y + Isosurface.squareVertexOffsets[vertexA].y, this.pointA);
        this.contourLocateXYZ(x + Isosurface.squareVertexOffsets[vertexB].x, y + Isosurface.squareVertexOffsets[vertexB].y, this.pointB);
    }

    void contourLocateXYZ(int ix, int iy, Point3f pt) {
        int i = this.findContourVertex(ix, iy);
        if (i < 0) {
            pt.x = Float.NaN;
            return;
        }
        ContourVertex c = this.contourVertexes[i];
        pt.set(c.vertexXYZ);
    }

    int findContourVertex(int ix, int iy) {
        for (int i = 0; i < this.contourVertexCount; ++i) {
            if (this.contourVertexes[i].pixelLocation[0] != ix || this.contourVertexes[i].pixelLocation[1] != iy) continue;
            return i;
        }
        return -1;
    }

    float calcContourPoint(float cutoff, float valueA, float valueB, Point3f contourPoint) {
        float diff = valueB - valueA;
        float fraction = (cutoff - valueA) / diff;
        this.edgeVector.sub(this.pointB, this.pointA);
        contourPoint.scaleAdd(fraction, this.edgeVector, this.pointA);
        return fraction;
    }

    void calcPixelVertexVectors() {
        int i = 4;
        while (--i >= 0) {
            this.pixelVertexVectors[i] = this.calcPixelVertexVector(squareVertexVectors[i]);
        }
    }

    Vector3f calcPixelVertexVector(Vector3f squareVector) {
        Vector3f v = new Vector3f();
        this.planarMatrix.transform(squareVector, v);
        return v;
    }

    void triangulateContours() {
        this.currentMesh.vertexColixes = new short[this.currentMesh.vertexCount];
        for (int i = 0; i < this.nContours; ++i) {
            if (this.thisContour > 0 && this.thisContour != i + 1) continue;
            this.createContourTriangles(i);
        }
    }

    void createContourTriangles(int contourIndex) {
        for (int i = 0; i < this.nSquares; ++i) {
            this.triangulateContourSquare(i, contourIndex);
        }
    }

    void triangulateContourSquare(int squareIndex, int contourIndex) {
        PlanarSquare square = this.planarSquares[squareIndex];
        int edgeMask0 = square.edgeMask12[contourIndex] & 0xFF;
        if (edgeMask0 == 0) {
            return;
        }
        if (edgeMask0 == 15 && contourIndex > 0 && square.edgeMask12[contourIndex - 1] == 15) {
            return;
        }
        boolean isOK = true;
        int edgeMask = edgeMask0;
        if (contourIndex > 0 && (edgeMask0 = square.edgeMask12[contourIndex - 1]) != 15) {
            isOK = false;
            if (((edgeMask ^ edgeMask0) & 0xF0) == 0) {
                isOK = false;
            }
            edgeMask &= 0xFF;
            edgeMask ^= edgeMask0 & 0xF0F;
        }
        if (contourIndex > 0 && edgeMask == 0) {
            return;
        }
        this.fillSquare(square, contourIndex, edgeMask, false);
        if (!isOK) {
            this.fillSquare(square, contourIndex, edgeMask, true);
        }
    }

    void fillSquare(PlanarSquare square, int contourIndex, int edgeMask, boolean reverseWinding) {
        int vPt = 0;
        boolean flip = reverseWinding;
        int nIntersect = 0;
        for (int i = 0; i < 4; ++i) {
            boolean newIntersect = false;
            if ((edgeMask & 1 << i) != 0) {
                this.triangleVertexList[vPt++] = square.vertexes[i];
            }
            if (flip && (edgeMask & 1 << 8 + i) != 0) {
                ++nIntersect;
                newIntersect = true;
                this.triangleVertexList[vPt++] = square.intersectionPoints[contourIndex - 1][i];
            }
            if ((edgeMask & 1 << 4 + i) != 0) {
                ++nIntersect;
                newIntersect = true;
                this.triangleVertexList[vPt++] = square.intersectionPoints[contourIndex][i];
            }
            if (!flip && (edgeMask & 1 << 8 + i) != 0) {
                ++nIntersect;
                newIntersect = true;
                this.triangleVertexList[vPt++] = square.intersectionPoints[contourIndex - 1][i];
            }
            if (nIntersect != 2 || !newIntersect) continue;
            flip = !flip;
        }
        this.createTriangleSet(vPt);
    }

    void createTriangleSet(int nVertex) {
        int k = this.triangleVertexList[1];
        for (int i = 2; i < nVertex; ++i) {
            this.currentMesh.addTriangle(this.triangleVertexList[0], k, this.triangleVertexList[i]);
            k = this.triangleVertexList[i];
        }
    }

    String binaryString(int value) {
        String str = "0b";
        if (value == 0) {
            return "0";
        }
        int i = 0;
        while (value != 0) {
            str = str + (value % 2 == 1 ? "1" : "0");
            value >>= 1;
            if (i++ == 0 || i % 4 != 0) continue;
            str = str + " ";
        }
        return str;
    }

    String dumpArray(String msg, float[][] A, int x1, int x2, int y1, int y2) {
        String s = "dumpArray: " + msg + "\n";
        for (int x = x1; x <= x2; ++x) {
            s = s + "\t*" + x + "*";
        }
        for (int y = y2; y >= y1; --y) {
            s = s + "\n*" + y + "*";
            for (int x = x1; x <= x2; ++x) {
                s = s + "\t" + (x < A.length && y < A[x].length ? A[x][y] : Float.NaN);
            }
        }
        return s;
    }

    String dumpIntArray(int[] A, int n) {
        String str = "";
        for (int i = 0; i < n; ++i) {
            str = str + " " + A[i];
        }
        return str;
    }

    void voxelPtToXYZ(int x, int y, int z, Point3f pt) {
        pt.scaleAdd(x, this.volumetricVectors[0], this.volumetricOrigin);
        pt.scaleAdd(y, this.volumetricVectors[1], pt);
        pt.scaleAdd(z, this.volumetricVectors[2], pt);
    }

    float scaleByVoxelVector(Vector3f vector, int voxelVectorIndex) {
        return vector.dot(this.unitVolumetricVectors[voxelVectorIndex]) / this.volumetricVectorLengths[voxelVectorIndex];
    }

    void xyzToVoxelPt(Point3f point, Point3f pt2) {
        this.pointVector.set(point);
        this.pointVector.sub(this.volumetricOrigin);
        pt2.x = this.scaleByVoxelVector(this.pointVector, 0);
        pt2.y = this.scaleByVoxelVector(this.pointVector, 1);
        pt2.z = this.scaleByVoxelVector(this.pointVector, 2);
    }

    void xyzToVoxelPt(float x, float y, float z, Point3i pt2) {
        this.pointVector.set(x, y, z);
        this.pointVector.sub(this.volumetricOrigin);
        this.ptXyzTemp.x = this.scaleByVoxelVector(this.pointVector, 0);
        this.ptXyzTemp.y = this.scaleByVoxelVector(this.pointVector, 1);
        this.ptXyzTemp.z = this.scaleByVoxelVector(this.pointVector, 2);
        pt2.set((int)this.ptXyzTemp.x, (int)this.ptXyzTemp.y, (int)this.ptXyzTemp.z);
    }

    void offsetCenter() {
        Point3f pt = new Point3f();
        pt.scaleAdd((float)(this.voxelCounts[0] - 1) / 2.0f, this.volumetricVectors[0], pt);
        pt.scaleAdd((float)(this.voxelCounts[1] - 1) / 2.0f, this.volumetricVectors[1], pt);
        pt.scaleAdd((float)(this.voxelCounts[2] - 1) / 2.0f, this.volumetricVectors[2], pt);
        this.volumetricOrigin.sub(this.center, pt);
    }

    Point3f pixelPtToXYZ(int x, int y) {
        Point3f ptXyz = new Point3f();
        ptXyz.scaleAdd(x, this.planarVectors[0], this.planarOrigin);
        ptXyz.scaleAdd(y, this.planarVectors[1], ptXyz);
        return ptXyz;
    }

    Point3i locatePixel(Point3f ptXyz) {
        this.pointVector.set(ptXyz);
        this.xyzToPixelVector(this.pointVector);
        this.ptiTemp.x = (int)(this.pointVector.x + 0.5f);
        this.ptiTemp.y = (int)(this.pointVector.y + 0.5f);
        return this.ptiTemp;
    }

    void xyzToPixelVector(Vector3f vector) {
        vector.sub(vector, this.planarOrigin);
        this.matXyzToPlane.transform(vector);
        vector.x /= this.planarVectorLengths[0];
        vector.y /= this.planarVectorLengths[1];
    }

    void getCalcPoint(Point3f pt) {
        pt.sub(this.center);
        if (this.isEccentric) {
            this.eccentricityMatrixInverse.transform(pt);
        }
        if (this.isAnisotropic) {
            pt.x /= this.anisotropy[0];
            pt.y /= this.anisotropy[1];
            pt.z /= this.anisotropy[2];
        }
    }

    int setVoxelRange(int index, float min, float max, float ptsPerAngstrom, int gridMax) {
        int nGrid;
        float range = max - min;
        if (this.resolution != Float.MAX_VALUE) {
            ptsPerAngstrom = this.resolution;
            nGrid = (int)(range * ptsPerAngstrom);
        } else {
            nGrid = (int)(range * ptsPerAngstrom);
        }
        if (nGrid > gridMax) {
            if ((this.dataType & 0x100) > 0) {
                if (this.resolution != Float.MAX_VALUE) {
                    Logger.info("Maximum number of voxels for index=" + index);
                }
                nGrid = gridMax;
            } else if (this.resolution == Float.MAX_VALUE) {
                nGrid = gridMax;
            }
        }
        ptsPerAngstrom = (float)nGrid / range;
        float d = this.volumetricVectorLengths[index] = 1.0f / ptsPerAngstrom;
        this.voxelCounts[index] = nGrid + ((this.dataType & 0x80) != 0 ? 3 : 0);
        switch (index) {
            case 0: {
                this.volumetricVectors[0].set(d, 0.0f, 0.0f);
                this.volumetricOrigin.x = min;
                break;
            }
            case 1: {
                this.volumetricVectors[1].set(0.0f, d, 0.0f);
                this.volumetricOrigin.y = min;
                break;
            }
            case 2: {
                this.volumetricVectors[2].set(0.0f, 0.0f, d);
                this.volumetricOrigin.z = min;
                if (this.isEccentric) {
                    this.eccentricityMatrix.transform(this.volumetricOrigin);
                }
                if (this.center.x == Float.MAX_VALUE) break;
                this.volumetricOrigin.add(this.center);
            }
        }
        if (this.isEccentric) {
            this.eccentricityMatrix.transform(this.volumetricVectors[index]);
        }
        this.unitVolumetricVectors[index].normalize(this.volumetricVectors[index]);
        return this.voxelCounts[index];
    }

    String jvxlGetVolumeHeader(int nAtoms) {
        String str = -nAtoms + " " + this.volumetricOrigin.x / 0.5291772f + " " + this.volumetricOrigin.y / 0.5291772f + " " + this.volumetricOrigin.z / 0.5291772f + "\n";
        for (int i = 0; i < 3; ++i) {
            str = str + this.voxelCounts[i] + " " + this.volumetricVectors[i].x / 0.5291772f + " " + this.volumetricVectors[i].y / 0.5291772f + " " + this.volumetricVectors[i].z / 0.5291772f + "\n";
        }
        return str;
    }

    static float factorial(int n) {
        if (n == 0) {
            return 1.0f;
        }
        return (float)n * Isosurface.factorial(n - 1);
    }

    float getDefaultResolution() {
        return Float.MAX_VALUE;
    }

    void setupSphere() {
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        float radius = this.sphere_radiusAngstroms * 1.1f * this.eccentricityScale;
        for (int i = 0; i < 3; ++i) {
            this.setVoxelRange(i, -radius, radius, this.sphere_ptsPerAngstrom, this.sphere_gridMax);
        }
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("SPHERE \nres=" + this.sphere_ptsPerAngstrom + " rad=" + this.sphere_radiusAngstroms + (this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")" : "") + "\n");
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(2));
        this.atomCount = 0;
        this.negativeAtomCount = false;
    }

    float getSphereValue(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptPsi);
        this.getCalcPoint(this.ptPsi);
        return this.sphere_radiusAngstroms - (float)Math.sqrt(this.ptPsi.x * this.ptPsi.x + this.ptPsi.y * this.ptPsi.y + this.ptPsi.z * this.ptPsi.z);
    }

    void setupOrbital() {
        this.psi_radiusAngstroms = this.autoScaleOrbital();
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        for (int i = 0; i < 3; ++i) {
            this.setVoxelRange(i, -this.psi_radiusAngstroms, this.psi_radiusAngstroms, this.psi_ptsPerAngstrom, this.psi_gridMax);
        }
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("hydrogen-like orbital \nn=" + this.psi_n + ", l=" + this.psi_l + ", m=" + this.psi_m + " Znuc=" + this.psi_Znuc + " res=" + this.psi_ptsPerAngstrom + " rad=" + this.psi_radiusAngstroms + (this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")" : "") + "\n");
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(2));
        this.atomCount = 0;
        this.negativeAtomCount = false;
        this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
    }

    float autoScaleOrbital() {
        float w = ((float)(this.psi_n * (this.psi_n + 3)) - 5.0f) / this.psi_Znuc;
        if (w < 1.0f) {
            w = 1.0f;
        }
        if (this.psi_n < 3) {
            w += 1.0f;
        }
        float aMax = 0.0f;
        if (!this.isAnisotropic) {
            return w;
        }
        int i = 3;
        while (--i >= 0) {
            if (!(this.anisotropy[i] > aMax)) continue;
            aMax = this.anisotropy[i];
        }
        return w * aMax;
    }

    void calcFactors(int n, int el, int m) {
        int p;
        int abm = Math.abs(m);
        if (this.lastFactorial < n + el) {
            for (int i = this.lastFactorial + 1; i <= n + el; ++i) {
                this.fact[i] = Isosurface.factorial(i);
            }
            this.lastFactorial = n + el;
        }
        double Nnl = Math.pow((double)(2.0f * this.psi_Znuc / (float)n) / (double)0.52918f, 1.5) * Math.sqrt((double)(this.fact[n - el - 1] / 2.0f / (float)n) / Math.pow(this.fact[n + el], 3.0));
        double Lnl = this.fact[n + el] * this.fact[n + el];
        double Plm = Math.pow(2.0, -el) * (double)this.fact[el] * (double)this.fact[el + abm] * Math.sqrt((float)(2 * el + 1) * this.fact[el - abm] / 2.0f / this.fact[el + abm]);
        for (p = 0; p <= n - el - 1; ++p) {
            this.rfactor[p] = Nnl * Lnl / (double)this.fact[p] / (double)this.fact[n - el - p - 1] / (double)this.fact[2 * el + p + 1];
        }
        for (p = abm; p <= el; ++p) {
            this.pfactor[p] = Math.pow(-1.0, el - p) * Plm / (double)this.fact[p] / (double)this.fact[el + abm - p] / (double)this.fact[el - p] / (double)this.fact[p - abm];
        }
    }

    float getPsi(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptPsi);
        this.getCalcPoint(this.ptPsi);
        return (float)this.hydrogenAtomPsiAt(this.ptPsi, this.psi_n, this.psi_l, this.psi_m);
    }

    double hydrogenAtomPsiAt(Point3f pt, int n, int el, int m) {
        int abm = Math.abs(m);
        double x2y2 = pt.x * pt.x + pt.y * pt.y;
        double r2 = x2y2 + (double)(pt.z * pt.z);
        double r = Math.sqrt(r2);
        double rho = 2.0 * (double)this.psi_Znuc * r / (double)n / (double)0.52918f;
        double theta_lm = 0.0;
        double phi_m = 0.0;
        double sum = 0.0;
        for (int p = 0; p <= n - el - 1; ++p) {
            sum += Math.pow(-rho, p) * this.rfactor[p];
        }
        double rnl = Math.exp(-rho / 2.0) * Math.pow(rho, el) * sum;
        double ph = Math.atan2(pt.y, pt.x);
        double th = Math.atan2(Math.sqrt(x2y2), pt.z);
        double cth = Math.cos(th);
        double sth = Math.sin(th);
        sum = 0.0;
        for (int p = abm; p <= el; ++p) {
            sum += Math.pow(1.0 + cth, p - abm) * Math.pow(1.0 - cth, el - p) * this.pfactor[p];
        }
        theta_lm = Math.abs(Math.pow(sth, abm)) * sum;
        phi_m = m == 0 ? 1.0 : (m > 0 ? Math.cos((double)m * ph) * 1.414214 : Math.sin((double)(-m) * ph) * 1.414214);
        if (Math.abs(phi_m) < 1.0E-10) {
            phi_m = 0.0;
        }
        return rnl * theta_lm * phi_m;
    }

    void setupLobe() {
        this.psi_n = 3;
        this.psi_l = 2;
        this.psi_m = 0;
        this.psi_Znuc = 15.0f;
        if (this.center.x == Float.MAX_VALUE) {
            this.center.set(0.0f, 0.0f, 0.0f);
        }
        float radius = this.lobe_sizeAngstroms * 1.1f * this.eccentricityRatio * this.eccentricityScale;
        if (this.eccentricityScale > 0.0f && this.eccentricityScale < 1.0f) {
            radius /= this.eccentricityScale;
        }
        this.setVoxelRange(0, -radius, radius, this.lobe_ptsPerAngstrom, this.lobe_gridMax);
        this.setVoxelRange(1, -radius, radius, this.lobe_ptsPerAngstrom, this.lobe_gridMax);
        this.setVoxelRange(2, 0.0f, radius / this.eccentricityRatio, this.lobe_ptsPerAngstrom, this.lobe_gridMax);
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("lobe \nn=" + this.psi_n + ", l=" + this.psi_l + ", m=" + this.psi_m + " Znuc=" + this.psi_Znuc + " res=" + this.lobe_ptsPerAngstrom + " rad=" + radius + (this.isAnisotropic ? " anisotropy=(" + this.anisotropy[0] + "," + this.anisotropy[1] + "," + this.anisotropy[2] + ")" : "") + "\n");
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(2));
        this.atomCount = 0;
        this.negativeAtomCount = false;
        this.calcFactors(this.psi_n, this.psi_l, this.psi_m);
    }

    float getLobeValue(int x, int y, int z) {
        this.voxelPtToXYZ(x, y, z, this.ptPsi);
        this.getCalcPoint(this.ptPsi);
        float value = (float)this.hydrogenAtomPsiAt(this.ptPsi, this.psi_n, this.psi_l, this.psi_m);
        if (value < 0.0f) {
            value = 0.0f;
        }
        return value;
    }

    void addMOTitleInfo(int iLine, Hashtable mo) {
        String line = this.title[iLine];
        int pt = line.indexOf("%");
        if (line.length() == 0 || pt < 0) {
            return;
        }
        boolean replaced = false;
        for (int i = pt; i < line.length() - 1; ++i) {
            if (line.charAt(i) != '%') continue;
            String info = "";
            switch (line.charAt(i + 1)) {
                case 'F': {
                    info = this.viewer.getFileName();
                    break;
                }
                case 'I': {
                    info = info + this.qm_moNumber;
                    break;
                }
                case 'N': {
                    info = info + this.qmOrbitalCount;
                    break;
                }
                case 'M': {
                    info = info + this.viewer.getModelNumber(this.viewer.getDisplayModelIndex());
                    break;
                }
                case 'E': {
                    info = info + mo.get("energy");
                    break;
                }
                case 'U': {
                    if (!mo.containsKey("energyUnits")) break;
                    info = info + this.moData.get("energyUnits");
                    break;
                }
                case 'S': {
                    if (!mo.containsKey("symmetry")) break;
                    info = info + mo.get("symmetry");
                    break;
                }
                case 'O': {
                    if (!mo.containsKey("occupancy")) break;
                    info = info + mo.get("occupancy");
                }
            }
            replaced |= info.length() > 0;
            line = line.substring(0, i) + info + line.substring(i + 2);
            i += info.length();
        }
        line = replaced || line.charAt(0) != '?' ? line : "";
        this.title[iLine] = line.length() > 1 && line.charAt(0) == '?' ? line.substring(1) : line;
    }

    void setupQMOrbital() {
        int i;
        Atom[] atoms = this.frame.atoms;
        Point3f xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int modelIndex = this.viewer.getDisplayModelIndex();
        int iAtom = 0;
        int nSelected = 0;
        int nAtoms = this.viewer.getAtomCount();
        this.iUseBitSets = true;
        for (i = 0; i < nAtoms; ++i) {
            if (atoms[i].modelIndex != modelIndex) continue;
            ++iAtom;
            if (this.bsSelected != null && !this.bsSelected.get(i)) continue;
            ++nSelected;
        }
        this.qm_nAtoms = iAtom;
        if (nSelected > 0) {
            Logger.info(nSelected + " of " + this.qm_nAtoms + " atoms will be used in the orbital calculation");
        }
        if (this.qm_nAtoms > 0) {
            this.qm_atoms = new Atom[this.qm_nAtoms];
        }
        iAtom = 0;
        for (i = 0; i < nAtoms; ++i) {
            Atom atom = atoms[i];
            if (atom.modelIndex != modelIndex) continue;
            Point3f pt = new Point3f(atom);
            if (nSelected == 0 || this.bsSelected == null || this.bsSelected.get(i)) {
                float rA = atom.getVanderwaalsRadiusFloat() + this.qm_marginAngstroms;
                if (pt.x - rA < xyzMin.x) {
                    xyzMin.x = pt.x - rA;
                }
                if (pt.x + rA > xyzMax.x) {
                    xyzMax.x = pt.x + rA;
                }
                if (pt.y - rA < xyzMin.y) {
                    xyzMin.y = pt.y - rA;
                }
                if (pt.y + rA > xyzMax.y) {
                    xyzMax.y = pt.y + rA;
                }
                if (pt.z - rA < xyzMin.z) {
                    xyzMin.z = pt.z - rA;
                }
                if (pt.z + rA > xyzMax.z) {
                    xyzMax.z = pt.z + rA;
                }
                this.qm_atoms[iAtom++] = atom;
                continue;
            }
            ++iAtom;
        }
        if (!Float.isNaN(this.scale)) {
            Vector3f v = new Vector3f(xyzMax);
            v.sub(xyzMin);
            v.scale(0.5f);
            xyzMin.add(v);
            v.scale(this.scale);
            xyzMax.set(xyzMin);
            xyzMax.add(v);
            xyzMin.sub(v);
        }
        Logger.info("MO range bohr " + xyzMin + " to " + xyzMax);
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("MO range bohr " + xyzMin + " to " + xyzMax + "\ncalculation type: " + this.moData.get("calculationType") + "\n");
        int maxGrid = this.qm_gridMax;
        this.setVoxelRange(0, xyzMin.x, xyzMax.x, this.qm_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(1, xyzMin.y, xyzMax.y, this.qm_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(2, xyzMin.z, xyzMax.z, this.qm_ptsPerAngstrom, maxGrid);
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(iAtom));
        Point3f pt = new Point3f();
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            Atom atom = atoms[i2];
            if (atom.modelIndex != modelIndex) continue;
            pt.set(atom);
            pt.scale(1.8897262f);
            this.jvxlFileHeader.append(atom.getAtomicAndIsotopeNumber() + " " + atom.getAtomicAndIsotopeNumber() + ".0 " + pt.x + " " + pt.y + " " + pt.z + "\n");
        }
        this.atomCount = -2147483647;
        this.negativeAtomCount = false;
        this.precalculateVoxelData = true;
    }

    void generateQuantumCube() {
        float[] origin = new float[]{this.volumetricOrigin.x, this.volumetricOrigin.y, this.volumetricOrigin.z};
        switch (this.qmOrbitalType) {
            case 1: {
                QuantumCalculation q = new QuantumCalculation((String)this.moData.get("calculationType"), this.qm_atoms, (Vector)this.moData.get("shells"), (float[][])this.moData.get("gaussians"), (Hashtable)this.moData.get("atomicOrbitalOrder"), null, null, this.moCoefficients);
                q.createGaussianCube(this.voxelData, this.voxelCounts, origin, this.volumetricVectorLengths);
                break;
            }
            case 2: {
                QuantumCalculation q = new QuantumCalculation((String)this.moData.get("calculationType"), this.qm_atoms, (Vector)this.moData.get("shells"), null, null, (int[][])this.moData.get("slaterInfo"), (float[][])this.moData.get("slaterData"), this.moCoefficients);
                q.createSlaterCube(this.voxelData, this.voxelCounts, origin, this.volumetricVectorLengths);
                break;
            }
        }
    }

    void setupMep() {
        int i;
        Atom[] atoms = this.frame.atoms;
        Point3f xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        int modelIndex = this.viewer.getDisplayModelIndex();
        int iAtom = 0;
        int nSelected = 0;
        this.iUseBitSets = true;
        int nAtoms = this.viewer.getAtomCount();
        for (i = 0; i < nAtoms; ++i) {
            if (atoms[i].modelIndex != modelIndex) continue;
            ++iAtom;
            if (!this.bsSelected.get(i)) continue;
            ++nSelected;
        }
        this.mep_nAtoms = iAtom;
        if (nSelected > 0) {
            Logger.info(nSelected + " of " + this.mep_nAtoms + " atoms will be used in the mep calculation");
        }
        if (this.mep_nAtoms > 0) {
            this.mep_atoms = new Atom[this.mep_nAtoms];
        }
        iAtom = 0;
        for (i = 0; i < nAtoms; ++i) {
            Atom atom = atoms[i];
            if (atom.modelIndex != modelIndex) continue;
            Point3f pt = new Point3f(atom);
            if (this.bsSelected.get(i)) {
                float rA = atom.getVanderwaalsRadiusFloat() + this.mep_marginAngstroms;
                if (pt.x - rA < xyzMin.x) {
                    xyzMin.x = pt.x - rA;
                }
                if (pt.x + rA > xyzMax.x) {
                    xyzMax.x = pt.x + rA;
                }
                if (pt.y - rA < xyzMin.y) {
                    xyzMin.y = pt.y - rA;
                }
                if (pt.y + rA > xyzMax.y) {
                    xyzMax.y = pt.y + rA;
                }
                if (pt.z - rA < xyzMin.z) {
                    xyzMin.z = pt.z - rA;
                }
                if (pt.z + rA > xyzMax.z) {
                    xyzMax.z = pt.z + rA;
                }
                this.mep_atoms[iAtom++] = atom;
                continue;
            }
            ++iAtom;
        }
        if (!Float.isNaN(this.scale)) {
            Vector3f v = new Vector3f(xyzMax);
            v.sub(xyzMin);
            v.scale(0.5f);
            xyzMin.add(v);
            v.scale(this.scale);
            xyzMax.set(xyzMin);
            xyzMax.add(v);
            xyzMin.sub(v);
        }
        Logger.info("MEP range bohr " + xyzMin + " to " + xyzMax);
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("MEP range bohr " + xyzMin + " to " + xyzMax + "\n");
        int maxGrid = this.mep_gridMax;
        this.setVoxelRange(0, xyzMin.x, xyzMax.x, this.mep_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(1, xyzMin.y, xyzMax.y, this.mep_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(2, xyzMin.z, xyzMax.z, this.mep_ptsPerAngstrom, maxGrid);
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(iAtom));
        Point3f pt = new Point3f();
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            Atom atom = atoms[i2];
            if (atom.modelIndex != modelIndex) continue;
            pt.set(atom);
            pt.scale(1.8897262f);
            this.jvxlFileHeader.append(atom.getAtomicAndIsotopeNumber() + " " + atom.getAtomicAndIsotopeNumber() + ".0 " + pt.x + " " + pt.y + " " + pt.z + "\n");
        }
        this.atomCount = -2147483647;
        this.negativeAtomCount = false;
        this.precalculateVoxelData = true;
    }

    void generateMepCube() {
        float[] origin = new float[]{this.volumetricOrigin.x, this.volumetricOrigin.y, this.volumetricOrigin.z};
        MepCalculation m = new MepCalculation(this.mep_atoms, this.mepCharges);
        m.createMepCube(this.voxelData, this.voxelCounts, origin, this.volumetricVectorLengths);
    }

    void setupSolvent() {
        int i;
        this.bsSolventSelected = new BitSet();
        if (this.thePlane != null) {
            this.setPlaneParameters(this.thePlane);
        }
        this.solvent_quickPlane = true;
        Atom[] atoms = this.frame.atoms;
        Point3f xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Point3f xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.solvent_modelIndex = -1;
        int iAtom = 0;
        int nAtoms = this.viewer.getAtomCount();
        int nSelected = 0;
        this.iUseBitSets = true;
        if (this.bsIgnore == null) {
            this.bsIgnore = new BitSet();
        }
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            if (!this.bsSelected.get(i2) || this.bsIgnore.get(i2) || this.solvent_quickPlane && this.thePlane != null && Math.abs(this.distancePointToPlane(atoms[i2], this.thePlane)) > 2.0f * this.solventWorkingRadius(atoms[i2])) continue;
            this.bsSolventSelected.set(i2);
            ++nSelected;
        }
        this.atomSet = new BitSet();
        int firstSet = -1;
        int lastSet = 0;
        for (int i3 = 0; i3 < nAtoms; ++i3) {
            if (!this.bsSolventSelected.get(i3)) continue;
            if (this.solvent_modelIndex < 0) {
                this.solvent_modelIndex = atoms[i3].modelIndex;
            }
            if (this.solvent_modelIndex != atoms[i3].modelIndex) {
                this.bsIgnore.set(i3);
                continue;
            }
            ++iAtom;
            this.atomSet.set(i3);
            if (firstSet == -1) {
                firstSet = i3;
            }
            lastSet = i3;
        }
        int nH = 0;
        int[] atomNo = null;
        if (iAtom > 0) {
            int i4;
            Point3f[] hAtoms = null;
            if (this.addHydrogens) {
                hAtoms = this.viewer.getAdditionalHydrogens(this.atomSet);
                nH = hAtoms.length;
            }
            this.solvent_atomRadius = new float[iAtom + nH];
            this.solvent_ptAtom = new Point3f[iAtom + nH];
            atomNo = new int[iAtom + nH];
            float r = this.solventWorkingRadius(null);
            for (i4 = 0; i4 < nH; ++i4) {
                atomNo[i4] = 1;
                this.solvent_atomRadius[i4] = r;
                this.solvent_ptAtom[i4] = hAtoms[i4];
                if (!this.logMessages) continue;
                Logger.debug("draw {" + hAtoms[i4].x + " " + hAtoms[i4].y + " " + hAtoms[i4].z + "};");
            }
            iAtom = nH;
            for (i4 = firstSet; i4 <= lastSet; ++i4) {
                if (!this.atomSet.get(i4)) continue;
                atomNo[iAtom] = atoms[i4].getElementNumber();
                this.solvent_ptAtom[iAtom] = atoms[i4];
                this.solvent_atomRadius[iAtom++] = this.solventWorkingRadius(atoms[i4]);
            }
        }
        this.solvent_nAtoms = this.solvent_firstNearbyAtom = iAtom;
        Logger.info(iAtom + " atoms will be used in the solvent-accessible surface calculation");
        for (int i5 = 0; i5 < this.solvent_nAtoms; ++i5) {
            Point3f pt = this.solvent_ptAtom[i5];
            float rA = this.solvent_atomRadius[i5];
            if (pt.x - rA < xyzMin.x) {
                xyzMin.x = pt.x - rA;
            }
            if (pt.x + rA > xyzMax.x) {
                xyzMax.x = pt.x + rA;
            }
            if (pt.y - rA < xyzMin.y) {
                xyzMin.y = pt.y - rA;
            }
            if (pt.y + rA > xyzMax.y) {
                xyzMax.y = pt.y + rA;
            }
            if (pt.z - rA < xyzMin.z) {
                xyzMin.z = pt.z - rA;
            }
            if (!(pt.z + rA > xyzMax.z)) continue;
            xyzMax.z = pt.z + rA;
        }
        Logger.info("surface range " + xyzMin + " to " + xyzMax);
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("solvent-" + (this.dataType == 172 ? "accesible" : "excluded") + " surface\nrange " + xyzMin + " to " + xyzMax + "\n");
        Point3f pt = new Point3f();
        BitSet bsNearby = new BitSet();
        int nNearby = 0;
        firstSet = -1;
        lastSet = 0;
        for (i = 0; i < nAtoms; ++i) {
            if (this.atomSet.get(i) || this.bsIgnore.get(i)) continue;
            float rA = this.solventWorkingRadius(atoms[i]);
            if (this.solvent_quickPlane && this.thePlane != null && Math.abs(this.distancePointToPlane(atoms[i], this.thePlane)) > 2.0f * rA) continue;
            pt = atoms[i];
            if (!(pt.x + rA > xyzMin.x) || !(pt.x - rA < xyzMax.x) || !(pt.y + rA > xyzMin.y) || !(pt.y - rA < xyzMax.y) || !(pt.z + rA > xyzMin.z) || !(pt.z - rA < xyzMax.z)) continue;
            if (firstSet == -1) {
                firstSet = i;
            }
            lastSet = i;
            bsNearby.set(i);
            ++nNearby;
        }
        if (nNearby != 0) {
            this.solvent_nAtoms += nNearby;
            this.solvent_atomRadius = ArrayUtil.setLength(this.solvent_atomRadius, this.solvent_nAtoms);
            this.solvent_ptAtom = (Point3f[])ArrayUtil.setLength(this.solvent_ptAtom, this.solvent_nAtoms);
            iAtom = this.solvent_firstNearbyAtom;
            for (i = firstSet; i <= lastSet; ++i) {
                if (!bsNearby.get(i)) continue;
                this.solvent_ptAtom[iAtom] = atoms[i];
                this.solvent_atomRadius[iAtom++] = this.solventWorkingRadius(atoms[i]);
            }
        }
        int maxGrid = this.solvent_gridMax;
        this.setVoxelRange(0, xyzMin.x, xyzMax.x, this.solvent_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(1, xyzMin.y, xyzMax.y, this.solvent_ptsPerAngstrom, maxGrid);
        this.setVoxelRange(2, xyzMin.z, xyzMax.z, this.solvent_ptsPerAngstrom, maxGrid);
        this.precalculateVoxelData = this.newSolventMethod;
        int nAtomsWritten = Math.min(this.solvent_firstNearbyAtom, 100);
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(nAtomsWritten));
        pt = new Point3f();
        for (int i6 = 0; i6 < nAtomsWritten; ++i6) {
            pt.set(this.solvent_ptAtom[i6]);
            pt.scale(1.8897262f);
            this.jvxlFileHeader.append(atomNo[i6] + " " + atomNo[i6] + ".0 " + pt.x + " " + pt.y + " " + pt.z + "\n");
        }
        this.atomCount = -2147483647;
        this.negativeAtomCount = false;
    }

    float solventWorkingRadius(Atom atom) {
        float r = this.solventAtomRadiusAbsolute > 0.0f ? this.solventAtomRadiusAbsolute : (atom == null ? (float)JmolConstants.vanderwaalsMars[1] / 1000.0f : (this.useIonic ? atom.getBondingRadiusFloat() : atom.getVanderwaalsRadiusFloat()));
        r *= this.solventAtomRadiusFactor;
        if ((double)(r += this.solventExtendedAtomRadius + this.solventAtomRadiusOffset) < 0.1) {
            r = 0.1f;
        }
        return r;
    }

    void generateSolventCube() {
        float rA;
        Point3f ptA;
        long time = System.currentTimeMillis();
        Point3f ptY0 = new Point3f();
        Point3f ptZ0 = new Point3f();
        Point3i pt0 = new Point3i();
        Point3i pt1 = new Point3i();
        float maxValue = this.dataType == 180 ? Float.MAX_VALUE : Float.MAX_VALUE;
        for (int x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    this.voxelData[x][y][z] = maxValue;
                }
            }
        }
        if (this.dataType == 180) {
            return;
        }
        float maxRadius = 0.0f;
        for (int iAtom = 0; iAtom < this.solvent_nAtoms; ++iAtom) {
            ptA = this.solvent_ptAtom[iAtom];
            rA = this.solvent_atomRadius[iAtom];
            if (rA > maxRadius) {
                maxRadius = rA;
            }
            boolean isNearby = iAtom >= this.solvent_firstNearbyAtom;
            this.setGridLimitsForAtom(ptA, rA, pt0, pt1);
            this.voxelPtToXYZ(pt0.x, pt0.y, pt0.z, this.ptXyzTemp);
            for (int i = pt0.x; i < pt1.x; ++i) {
                ptY0.set(this.ptXyzTemp);
                for (int j = pt0.y; j < pt1.y; ++j) {
                    ptZ0.set(this.ptXyzTemp);
                    for (int k = pt0.z; k < pt1.z; ++k) {
                        float v = this.ptXyzTemp.distance(ptA) - rA;
                        if (v < this.voxelData[i][j][k]) {
                            this.voxelData[i][j][k] = isNearby ? Float.NaN : v;
                        }
                        this.ptXyzTemp.add(this.volumetricVectors[2]);
                    }
                    this.ptXyzTemp.set(ptZ0);
                    this.ptXyzTemp.add(this.volumetricVectors[1]);
                }
                this.ptXyzTemp.set(ptY0);
                this.ptXyzTemp.add(this.volumetricVectors[0]);
            }
        }
        if ((this.dataType == 171 || this.dataType == 179) && this.solventRadius > 0.0f) {
            Point3i ptA0 = new Point3i();
            Point3i ptB0 = new Point3i();
            Point3i ptA1 = new Point3i();
            Point3i ptB1 = new Point3i();
            for (int iAtom = 0; iAtom < this.solvent_firstNearbyAtom - 1; ++iAtom) {
                if (!(this.solvent_ptAtom[iAtom] instanceof Atom)) continue;
                ptA = this.solvent_ptAtom[iAtom];
                rA = this.solvent_atomRadius[iAtom] + this.solventRadius;
                this.setGridLimitsForAtom(ptA, rA - this.solventRadius, ptA0, ptA1);
                AtomIterator iter = this.frame.getWithinModelIterator((Atom)ptA, rA + this.solventRadius + maxRadius);
                while (iter.hasNext()) {
                    float dAB;
                    Atom ptB = iter.next();
                    if (ptB.atomIndex <= ((Atom)ptA).atomIndex || !this.bsSolventSelected.get(ptB.atomIndex)) continue;
                    float rB = this.solventWorkingRadius(ptB) + this.solventRadius;
                    if (this.solvent_quickPlane && this.thePlane != null && Math.abs(this.distancePointToPlane(ptB, this.thePlane)) > 2.0f * rB || (dAB = ptA.distance(ptB)) >= rA + rB) continue;
                    this.setGridLimitsForAtom(ptB, rB - this.solventRadius, ptB0, ptB1);
                    pt0.x = Math.min(ptA0.x, ptB0.x);
                    pt0.y = Math.min(ptA0.y, ptB0.y);
                    pt0.z = Math.min(ptA0.z, ptB0.z);
                    pt1.x = Math.max(ptA1.x, ptB1.x);
                    pt1.y = Math.max(ptA1.y, ptB1.y);
                    pt1.z = Math.max(ptA1.z, ptB1.z);
                    this.voxelPtToXYZ(pt0.x, pt0.y, pt0.z, this.ptXyzTemp);
                    for (int i = pt0.x; i < pt1.x; ++i) {
                        ptY0.set(this.ptXyzTemp);
                        for (int j = pt0.y; j < pt1.y; ++j) {
                            ptZ0.set(this.ptXyzTemp);
                            for (int k = pt0.z; k < pt1.z; ++k) {
                                float v;
                                float dVS = this.checkSpecialVoxel(ptA, rA, ptB, rB, dAB, this.ptXyzTemp);
                                if (!Float.isNaN(dVS) && (v = this.solventRadius - dVS) < this.voxelData[i][j][k]) {
                                    this.voxelData[i][j][k] = v;
                                }
                                this.ptXyzTemp.add(this.volumetricVectors[2]);
                            }
                            this.ptXyzTemp.set(ptZ0);
                            this.ptXyzTemp.add(this.volumetricVectors[1]);
                        }
                        this.ptXyzTemp.set(ptY0);
                        this.ptXyzTemp.add(this.volumetricVectors[0]);
                    }
                }
            }
        }
        if (this.thePlane != null) {
            maxValue = 0.001f;
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] < maxValue) continue;
                        this.voxelData[x][y][z] = maxValue;
                    }
                }
            }
        }
        Logger.debug("solvent surface time:" + (System.currentTimeMillis() - time));
    }

    void setGridLimitsForAtom(Point3f ptA, float rA, Point3i pt0, Point3i pt1) {
        this.xyzToVoxelPt(ptA.x - rA, ptA.y - rA, ptA.z - rA, pt0);
        --pt0.x;
        --pt0.y;
        --pt0.z;
        if (pt0.x < 0) {
            pt0.x = 0;
        }
        if (pt0.y < 0) {
            pt0.y = 0;
        }
        if (pt0.z < 0) {
            pt0.z = 0;
        }
        this.xyzToVoxelPt(ptA.x + rA, ptA.y + rA, ptA.z + rA, pt1);
        pt1.x += 2;
        pt1.y += 2;
        pt1.z += 2;
        if (pt1.x >= this.nPointsX) {
            pt1.x = this.nPointsX;
        }
        if (pt1.y >= this.nPointsY) {
            pt1.y = this.nPointsY;
        }
        if (pt1.z >= this.nPointsZ) {
            pt1.z = this.nPointsZ;
        }
    }

    float getSolventValue(int x, int y, int z) {
        float rA;
        Point3f ptA;
        this.solvent_voxel.setValue(x, y, z, Float.MAX_VALUE);
        for (int i = 0; i < this.solvent_nAtoms && (double)this.solvent_voxel.value >= -0.5; ++i) {
            ptA = this.solvent_ptAtom[i];
            rA = this.solvent_atomRadius[i];
            float v = this.solvent_voxel.ptXyz.distance(ptA) - rA;
            if (!(v < this.solvent_voxel.value)) continue;
            this.solvent_voxel.setValue(i >= this.solvent_firstNearbyAtom ? Float.NaN : v);
        }
        if (this.solventRadius == 0.0f) {
            return this.solvent_voxel.value;
        }
        Point3f ptV = this.solvent_voxel.ptXyz;
        for (int i = 0; i < this.solvent_nAtoms - 1 && (double)this.solvent_voxel.value >= -0.5; ++i) {
            ptA = this.solvent_ptAtom[i];
            rA = this.solvent_atomRadius[i] + this.solventRadius;
            for (int j = i + 1; j < this.solvent_nAtoms && (double)this.solvent_voxel.value >= -0.5; ++j) {
                float dVS;
                if (i >= this.solvent_firstNearbyAtom && j >= this.solvent_firstNearbyAtom) continue;
                Point3f ptB = this.solvent_ptAtom[j];
                float rB = this.solvent_atomRadius[j] + this.solventRadius;
                float dAB = ptA.distance(ptB);
                if (dAB >= rA + rB || Float.isNaN(dVS = this.checkSpecialVoxel(ptA, rA, ptB, rB, dAB, ptV))) continue;
                this.solvent_voxel.setValue(this.solventRadius - dVS);
            }
        }
        return this.solvent_voxel.value;
    }

    float checkSpecialVoxel(Point3f ptA, float rAS, Point3f ptB, float rBS, float dAB, Point3f ptV) {
        float dAV = ptA.distance(ptV);
        float dBV = ptB.distance(ptV);
        float dVS = Float.NaN;
        float f = rAS / dAV;
        if (f > 1.0f) {
            this.ptS.set(ptA.x + (ptV.x - ptA.x) * f, ptA.y + (ptV.y - ptA.y) * f, ptA.z + (ptV.z - ptA.z) * f);
            if (ptB.distance(this.ptS) < rBS && !this.voxelIsInTrough(dVS = this.solventDistance(ptV, ptA, ptB, rAS, rBS, dAB, dAV, dBV), rAS * rAS, rBS, dAB, dAV, dBV)) {
                return Float.NaN;
            }
            return dVS;
        }
        f = rBS / dBV;
        if (f <= 1.0f) {
            return dVS;
        }
        this.ptS.set(ptB.x + (ptV.x - ptB.x) * f, ptB.y + (ptV.y - ptB.y) * f, ptB.z + (ptV.z - ptB.z) * f);
        if (ptA.distance(this.ptS) < rAS && !this.voxelIsInTrough(dVS = this.solventDistance(ptV, ptB, ptA, rBS, rAS, dAB, dBV, dAV), rAS * rAS, rBS, dAB, dAV, dBV)) {
            return Float.NaN;
        }
        return dVS;
    }

    boolean voxelIsInTrough(float dVS, float rAS2, float rBS, float dAB, float dAV, float dBV) {
        float cosASBf = (rAS2 + rBS * rBS - dAB * dAB) / rBS;
        float cosASVf = (rAS2 + dVS * dVS - dAV * dAV) / dVS;
        return cosASBf < cosASVf;
    }

    float solventDistance(Point3f ptV, Point3f ptA, Point3f ptB, float rAS, float rBS, float dAB, float dAV, float dBV) {
        double angleVAB = Math.acos((dAV * dAV + dAB * dAB - dBV * dBV) / (2.0f * dAV * dAB));
        double angleBAS = Math.acos((dAB * dAB + rAS * rAS - rBS * rBS) / (2.0f * dAB * rAS));
        float dVS = (float)Math.sqrt((double)(rAS * rAS + dAV * dAV) - (double)(2.0f * rAS * dAV) * Math.cos(angleBAS - angleVAB));
        return dVS;
    }

    void setupSurfaceInfo() {
        this.volumetricOrigin.set((Point3f)this.surfaceInfo.get("volumetricOrigin"));
        Vector3f[] v = (Vector3f[])this.surfaceInfo.get("volumetricVectors");
        for (int i = 0; i < 3; ++i) {
            this.volumetricVectors[i].set(v[i]);
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            this.unitVolumetricVectors[i].normalize(this.volumetricVectors[i]);
        }
        int[] counts = (int[])this.surfaceInfo.get("voxelCounts");
        for (int i = 0; i < 3; ++i) {
            this.voxelCounts[i] = counts[i];
        }
        this.voxelData = (float[][][])this.surfaceInfo.get("voxelData");
        this.tempVoxelData = this.voxelData;
        this.precalculateVoxelData = true;
    }

    void setupFunctionXY() {
        this.jvxlFileHeader = new StringBuffer();
        this.jvxlFileHeader.append("functionXY\n" + this.functionXYinfo + "\n");
        this.functionName = (String)this.functionXYinfo.get(0);
        this.volumetricOrigin.set((Point3f)this.functionXYinfo.get(1));
        if (!this.isAngstroms) {
            this.volumetricOrigin.scale(0.5291772f);
        }
        for (int i = 0; i < 3; ++i) {
            Point4f info = (Point4f)this.functionXYinfo.get(i + 2);
            this.voxelCounts[i] = (int)info.x;
            this.volumetricVectors[i].set(info.y, info.z, info.w);
            if (!this.isAngstroms) {
                this.volumetricVectors[i].scale(0.5291772f);
            }
            this.volumetricVectorLengths[i] = this.volumetricVectors[i].length();
            this.unitVolumetricVectors[i].normalize(this.volumetricVectors[i]);
        }
        this.jvxlFileHeader.append(this.jvxlGetVolumeHeader(2));
        this.atomCount = 0;
        this.negativeAtomCount = false;
    }

    float getFunctionValue(int x, int y) {
        return this.viewer.functionXY(this.functionName, x, y);
    }

    void drawLcaoCartoon(String lcaoCartoon, Vector3f z, Vector3f x) {
        String id;
        boolean isReverse;
        Vector3f y = new Vector3f();
        boolean bl = isReverse = lcaoCartoon.length() > 0 && lcaoCartoon.charAt(0) == '-';
        if (isReverse) {
            lcaoCartoon = lcaoCartoon.substring(1);
        }
        this.colorPos = this.colorPosLCAO;
        this.colorNeg = this.colorNegLCAO;
        int sense = isReverse ? -1 : 1;
        y.cross(z, x);
        String string = id = this.currentMesh == null ? "lcao" + ++this.nLCAO + "_" + lcaoCartoon : this.currentMesh.thisID;
        if (this.currentMesh == null) {
            this.allocMesh(id);
        }
        this.defaultColix = Graphics3D.getColix(this.colorPos);
        if (lcaoCartoon.equals("px")) {
            this.currentMesh.thisID = this.currentMesh.thisID + "a";
            this.createLcaoLobe(x, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(x, -sense);
            this.currentMesh.colix = Graphics3D.getColix(this.colorNeg);
            return;
        }
        if (lcaoCartoon.equals("py")) {
            this.currentMesh.thisID = this.currentMesh.thisID + "a";
            this.createLcaoLobe(y, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(y, -sense);
            this.currentMesh.colix = Graphics3D.getColix(this.colorNeg);
            return;
        }
        if (lcaoCartoon.equals("pz")) {
            this.currentMesh.thisID = this.currentMesh.thisID + "a";
            this.createLcaoLobe(z, sense);
            this.setProperty("thisID", id + "b", null);
            this.createLcaoLobe(z, -sense);
            this.currentMesh.colix = Graphics3D.getColix(this.colorNeg);
            return;
        }
        if (lcaoCartoon.equals("pxa")) {
            this.createLcaoLobe(x, sense);
            return;
        }
        if (lcaoCartoon.equals("pxb")) {
            this.createLcaoLobe(x, -sense);
            return;
        }
        if (lcaoCartoon.equals("pya")) {
            this.createLcaoLobe(y, sense);
            return;
        }
        if (lcaoCartoon.equals("pyb")) {
            this.createLcaoLobe(y, -sense);
            return;
        }
        if (lcaoCartoon.equals("pza")) {
            this.createLcaoLobe(z, sense);
            return;
        }
        if (lcaoCartoon.equals("pzb")) {
            this.createLcaoLobe(z, -sense);
            return;
        }
        if (lcaoCartoon.indexOf("sp") == 0 || lcaoCartoon.indexOf("lp") == 0) {
            this.createLcaoLobe(z, sense);
            return;
        }
        this.createLcaoLobe(null, 1.0f);
    }

    void createLcaoLobe(Vector3f lobeAxis, float factor) {
        this.initState();
        Logger.debug("creating isosurface " + this.currentMesh.thisID);
        if (lobeAxis == null) {
            this.setProperty("sphere", new Float(factor / 2.0f), null);
            return;
        }
        this.lcaoDir.x = lobeAxis.x * factor;
        this.lcaoDir.y = lobeAxis.y * factor;
        this.lcaoDir.z = lobeAxis.z * factor;
        this.lcaoDir.w = 0.7f;
        this.setProperty("lobe", this.lcaoDir, null);
    }

    void setModelIndex() {
        this.setModelIndex(this.atomIndex);
        this.currentMesh.ptCenter.set(this.center);
        this.currentMesh.title = this.title;
        this.currentMesh.jvxlDefinitionLine = this.jvxlGetDefinitionLine(this.currentMesh);
        if (this.script != null) {
            this.currentMesh.scriptCommand = this.fixScript();
        }
    }

    Vector getShapeDetail() {
        Vector V = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            Mesh mesh = this.meshes[i];
            if (mesh == null) continue;
            info.put("ID", mesh.thisID == null ? "<noid>" : mesh.thisID);
            info.put("vertexCount", new Integer(mesh.vertexCount));
            if (mesh.ptCenter.x != Float.MAX_VALUE) {
                info.put("center", mesh.ptCenter);
            }
            if (mesh.jvxlDefinitionLine != null) {
                info.put("jvxlDefinitionLine", mesh.jvxlDefinitionLine);
            }
            info.put("modelIndex", new Integer(mesh.modelIndex));
            if (mesh.title != null) {
                info.put("title", mesh.title);
            }
            V.add(info);
        }
        return V;
    }

    BitSet[] getSurfaceSet(int level) {
        if (this.currentMesh == null) {
            return null;
        }
        if (level == 0) {
            this.surfaceSet = new BitSet[100];
            this.nSets = 0;
        }
        this.setsSuccessful = true;
        for (int i = 0; i < this.currentMesh.polygonCount; ++i) {
            int[] p = this.currentMesh.polygonIndexes[i];
            int pt0 = this.findSet(p[0]);
            int pt1 = this.findSet(p[1]);
            int pt2 = this.findSet(p[2]);
            if (pt0 < 0 && pt1 < 0 && pt2 < 0) {
                this.createSet(p[0], p[1], p[2]);
                continue;
            }
            if (pt0 == pt1 && pt2 == pt2) continue;
            if (pt0 >= 0) {
                this.surfaceSet[pt0].set(p[1]);
                this.surfaceSet[pt0].set(p[2]);
                if (pt1 >= 0 && pt1 != pt0) {
                    this.mergeSets(pt0, pt1);
                }
                if (pt2 < 0 || pt2 == pt0 || pt2 == pt1) continue;
                this.mergeSets(pt0, pt2);
                continue;
            }
            if (pt1 >= 0) {
                this.surfaceSet[pt1].set(p[0]);
                this.surfaceSet[pt1].set(p[2]);
                if (pt2 < 0 || pt2 == pt1) continue;
                this.mergeSets(pt1, pt2);
                continue;
            }
            this.surfaceSet[pt2].set(p[0]);
            this.surfaceSet[pt2].set(p[1]);
        }
        int n = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            ++n;
        }
        BitSet[] temp = new BitSet[n];
        n = 0;
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null) continue;
            temp[n++] = this.surfaceSet[i];
        }
        this.nSets = n;
        this.surfaceSet = temp;
        if (!this.setsSuccessful && level < 2) {
            this.getSurfaceSet(++level);
        }
        return this.surfaceSet;
    }

    int findSet(int vertex) {
        for (int i = 0; i < this.nSets; ++i) {
            if (this.surfaceSet[i] == null || !this.surfaceSet[i].get(vertex)) continue;
            return i;
        }
        return -1;
    }

    void createSet(int v1, int v2, int v3) {
        int i;
        for (i = 0; i < this.nSets && this.surfaceSet[i] != null; ++i) {
        }
        if (i >= 100) {
            this.setsSuccessful = false;
            return;
        }
        if (i == this.nSets) {
            this.nSets = i + 1;
        }
        this.surfaceSet[i] = new BitSet();
        this.surfaceSet[i].set(v1);
        this.surfaceSet[i].set(v2);
        this.surfaceSet[i].set(v3);
    }

    void mergeSets(int a, int b) {
        this.surfaceSet[a].or(this.surfaceSet[b]);
        this.surfaceSet[b] = null;
    }

    class Voxel
    extends Point3i {
        Point3f ptXyz = new Point3f();
        float value;

        Voxel() {
        }

        void setValue(int x, int y, int z, float value) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.value = value;
            Isosurface.this.voxelPtToXYZ(x, y, z, this.ptXyz);
        }

        void setValue(float value) {
            if (this.value < value) {
                return;
            }
            if (Isosurface.this.logCube) {
                Logger.info("voxel.setValue " + this.x + " " + this.y + " " + this.z + this.ptXyz + ": " + value + " was " + this.value);
            }
            this.value = value;
        }
    }

    class PlanarSquare {
        int[] edgeMask12;
        int edgeMask12All;
        int nInside;
        int nOutside;
        int nThrough;
        int contourBits;
        int x;
        int y;
        Point3f origin;
        int[] vertexes;
        int[][] intersectionPoints;

        PlanarSquare(Point3f origin, int x, int y) {
            this.edgeMask12 = new int[Isosurface.this.nContours];
            this.intersectionPoints = new int[Isosurface.this.nContours][4];
            this.vertexes = new int[4];
            this.edgeMask12All = 0;
            this.contourBits = 0;
            this.origin = origin;
            this.x = x;
            this.y = y;
        }

        void setIntersectionPoints(int contourIndex, int[] pts) {
            for (int i = 0; i < 4; ++i) {
                this.intersectionPoints[contourIndex][i] = pts[i];
            }
        }

        void setVertex(int iV, int pt) {
            if (this.vertexes[iV] != 0 && this.vertexes[iV] != pt) {
                Logger.error("IV IS NOT 0 or pt:" + iV + " " + this.vertexes[iV] + "!=" + pt);
            }
            this.vertexes[iV] = pt;
        }

        void addEdgeMask(int contourIndex, int edgeMask4, int insideMask) {
            if (insideMask != 0) {
                this.contourBits |= 1 << contourIndex;
            }
            this.edgeMask12[contourIndex] = ((edgeMask4 << 4) + edgeMask4 << 4) + insideMask;
            this.edgeMask12All |= this.edgeMask12[contourIndex];
            if (insideMask == 0) {
                ++this.nOutside;
            } else if (insideMask == 15) {
                ++this.nInside;
            } else {
                ++this.nThrough;
            }
        }
    }

    class ContourVertex {
        Point3f vertexXYZ = new Point3f();
        Point3i voxelLocation;
        int[] pixelLocation = new int[2];
        float value;
        int vertexIndex;

        ContourVertex(int x, int y, int z, Point3f vertexXYZ, int vPt) {
            this.vertexXYZ.set(vertexXYZ);
            this.voxelLocation = new Point3i(x, y, z);
            this.vertexIndex = vPt;
        }

        void setValue(float value) {
            this.value = value;
            Isosurface.this.voxelData[this.voxelLocation.x][this.voxelLocation.y][this.voxelLocation.z] = value;
            if ((double)Math.abs(value) < 1.0E-7) {
                Isosurface.this.currentMesh.invalidateVertex(this.vertexIndex);
            }
        }

        void setPixelLocation(Point3i pt) {
            this.pixelLocation[0] = pt.x;
            this.pixelLocation[1] = pt.y;
        }
    }
}

