/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.AtomShape;
import org.jmol.viewer.DotsRenderer;
import org.jmol.viewer.Shape;
import org.jmol.viewer.StateManager;

class Dots
extends AtomShape {
    DotsRenderer dotsRenderer;
    BitSet bsOn = new BitSet();
    short mad = 0;
    short lastMad = 0;
    float lastSolventRadius = 0.0f;
    float maxRadius = 0.0f;
    float scale = 1.0f;
    float setRadius = Float.MAX_VALUE;
    float addRadius = Float.MAX_VALUE;
    short surfaceColix = (short)12;
    int dotsConvexMax;
    int[][] dotsConvexMaps;
    final int nArcPoints = 9;
    Vector3f[] geodesicVertices;
    int geodesicCount;
    int[] geodesicMap;
    Vector3f[] geodesicSolventVertices;
    int geodesicSolventCount;
    int[] geodesicSolventMap;
    int[] mapT;
    static final int[] mapNull = new int[0];
    static final int DOTS_MODE_DOTS = 0;
    static final int DOTS_MODE_SURFACE = 1;
    static final int DOTS_MODE_CALCONLY = 2;
    int argb;
    BitSet bsSurface;
    boolean calcDistanceOnly;
    boolean useVanderwaalsRadius;
    boolean disregardNeighbors = false;
    boolean onlySelectedDots = false;
    int indexI;
    int indexJ;
    int indexK;
    Atom atomI;
    Atom atomJ;
    Atom atomK;
    Point3f centerI;
    Point3f centerJ;
    Point3f centerK;
    float radiusI;
    float radiusJ;
    float radiusK;
    float radiusP;
    float diameterP;
    float radiiIP2;
    float radiiJP2;
    float radiiKP2;
    float distanceIJ2;
    final Point3f pointT = new Point3f();
    boolean TIMINGS = true;
    long timeBeginExecution;
    long timeEndExecution;
    boolean isSurface;
    boolean isCalcOnly;
    Point3f centerT;
    int neighborCount;
    Atom[] neighbors = new Atom[16];
    int[] neighborIndices = new int[16];
    Point3f[] neighborCenters = new Point3f[16];
    float[] neighborPlusProbeRadii2 = new float[16];
    float[] neighborRadii2 = new float[16];

    Dots() {
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    void initShape() {
        Logger.debug("init dots");
        this.dotsRenderer = (DotsRenderer)this.frame.getRenderer(7);
        this.geodesicVertices = this.dotsRenderer.geodesic.vertices;
        this.geodesicCount = this.geodesicVertices.length;
        this.geodesicMap = Dots.allocateBitmap(this.geodesicCount);
        this.geodesicSolventVertices = this.dotsRenderer.geodesicSolvent.vertices;
        this.geodesicSolventCount = this.geodesicSolventVertices.length;
        this.geodesicSolventMap = Dots.allocateBitmap(this.geodesicSolventCount);
        this.mapT = Dots.allocateBitmap(this.geodesicSolventCount);
        super.initShape();
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        Logger.debug("Dots.setProperty: " + propertyName + " " + value);
        if ("init" == propertyName) {
            int mode = (Integer)value;
            this.isSurface = mode == 1;
            this.isCalcOnly = mode == 2;
            this.argb = 0;
            return;
        }
        if ("color" == propertyName) {
            super.setProperty(propertyName, value, bs);
            return;
        }
        if ("translucency" == propertyName) {
            return;
        }
        if ("colorSurface" == propertyName) {
            this.surfaceColix = Graphics3D.getColix(value);
            return;
        }
        if ("translucencySurface" == propertyName) {
            boolean isTranslucent = "translucent" == value;
            this.surfaceColix = Graphics3D.getColixTranslucent(this.surfaceColix, isTranslucent);
            return;
        }
        if ("radius" == propertyName) {
            this.radiusI = ((Float)value).floatValue();
            return;
        }
        if ("colorRGB" == propertyName) {
            this.argb = (Integer)value;
            return;
        }
        if ("atom" == propertyName) {
            this.indexI = (Integer)value;
            this.dotsConvexMax = Math.max(this.indexI + 1, this.dotsConvexMax);
            this.atoms[this.indexI].setShapeVisibility(this.myVisibilityFlag, true);
            return;
        }
        if ("dots" == propertyName) {
            this.isActive = true;
            bs = (BitSet)value;
            Dots.setAllBits(this.geodesicMap, this.geodesicCount);
            int iDot = this.geodesicCount;
            while (--iDot >= 0) {
                if (bs.get(iDot)) continue;
                Dots.clearBit(this.geodesicMap, iDot);
            }
            if (this.dotsConvexMaps == null) {
                this.dotsConvexMaps = new int[this.atomCount][];
            }
            int[] map = mapNull;
            int count = this.getMapStorageCount(this.geodesicMap);
            if (count > 0) {
                map = new int[count];
                System.arraycopy(this.geodesicMap, 0, map, 0, count);
            }
            this.dotsConvexMaps[this.indexI] = map;
            if (this.mads == null) {
                this.mads = new short[this.atomCount];
            }
            this.mads[this.indexI] = (short)(this.radiusI * 1000.0f);
            if (this.colixes == null) {
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.colixes[this.indexI] = Graphics3D.getColix(this.argb);
            return;
        }
    }

    void setSize(int size, BitSet bsSelected) {
        int i;
        boolean newSet;
        Logger.debug("Dots.setSize " + size);
        this.bsSurface = new BitSet();
        boolean isVisible = true;
        this.isActive = true;
        short mad = (short)size;
        if (mad == 1 && this.isCalcOnly) {
            mad = 12202;
        }
        if (mad < 0) {
            this.useVanderwaalsRadius = false;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        } else if (mad == 0) {
            this.isSurface = false;
            this.isCalcOnly = false;
            isVisible = false;
        } else if (mad == 1) {
            this.useVanderwaalsRadius = true;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        } else if (mad <= 1001) {
            this.useVanderwaalsRadius = true;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = Float.MAX_VALUE;
            this.scale = (float)(mad - 1) / 100.0f;
        } else if (mad <= 11002) {
            this.useVanderwaalsRadius = false;
            this.addRadius = Float.MAX_VALUE;
            this.setRadius = (float)(mad - 1002) / 1000.0f;
            this.scale = 1.0f;
        } else if (mad <= 13002) {
            this.useVanderwaalsRadius = true;
            this.addRadius = (float)(mad - 11002) / 1000.0f;
            this.setRadius = Float.MAX_VALUE;
            this.scale = 1.0f;
        }
        this.maxRadius = this.frame.getMaxVanderwaalsRadius();
        float solventRadius = this.viewer.getCurrentSolventProbeRadius();
        if (this.addRadius == Float.MAX_VALUE) {
            this.addRadius = solventRadius != 0.0f ? solventRadius : 0.0f;
        }
        this.timeBeginExecution = System.currentTimeMillis();
        boolean bl = newSet = this.lastSolventRadius != this.addRadius || mad != 0 && mad != this.lastMad || this.dotsConvexMax == 0;
        if (isVisible) {
            i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i) || this.bsOn.get(i)) continue;
                this.bsOn.set(i);
                newSet = true;
            }
        } else {
            i = this.atomCount;
            while (--i >= 0) {
                if (!bsSelected.get(i)) continue;
                this.bsOn.set(i, false);
            }
        }
        if (!this.isCalcOnly) {
            i = this.atomCount;
            while (--i >= 0) {
                this.atoms[i].setShapeVisibility(this.myVisibilityFlag, this.bsOn.get(i));
            }
        }
        if (newSet) {
            this.dotsConvexMax = 0;
            this.dotsConvexMaps = null;
            this.radiusP = 0.0f;
            this.mads = null;
            this.diameterP = 2.0f * this.radiusP;
            this.lastSolventRadius = this.addRadius;
        }
        if (isVisible && this.dotsConvexMaps != null) {
            i = this.atomCount;
            while (--i >= 0) {
                if (!this.bsOn.get(i)) continue;
                this.dotsConvexMaps[i] = null;
            }
        }
        if (isVisible) {
            this.lastMad = mad;
            if (this.dotsConvexMaps == null) {
                this.dotsConvexMaps = new int[this.atomCount][];
                this.colixes = new short[this.atomCount];
                this.paletteIDs = new byte[this.atomCount];
            }
            this.disregardNeighbors = !this.viewer.getDotSurfaceFlag();
            this.onlySelectedDots = this.viewer.getDotsSelectedOnlyFlag();
            i = this.atomCount;
            while (--i >= 0) {
                if (!this.bsOn.get(i)) continue;
                this.setAtomI(i);
                this.getNeighbors();
                this.calcConvexMap();
            }
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            i = this.atomCount;
            while (--i >= 0 && this.dotsConvexMaps[i] == null) {
            }
            this.dotsConvexMax = i + 1;
        }
        this.frame.setSurfaceAtoms(this.bsSurface, this.bsOn);
        if (this.isCalcOnly) {
            this.dotsConvexMax = 0;
            this.dotsConvexMaps = null;
        }
        this.timeEndExecution = System.currentTimeMillis();
        Logger.debug("dots generation time = " + this.getExecutionWalltime());
    }

    float getAppropriateRadius(Atom atom) {
        if (this.mads != null) {
            return (float)this.mads[atom.atomIndex] / 1000.0f;
        }
        float v = this.addRadius + (this.setRadius != Float.MAX_VALUE ? this.setRadius : (this.useVanderwaalsRadius ? atom.getVanderwaalsRadiusFloat() : atom.getBondingRadiusFloat()) * this.scale);
        return v;
    }

    void setAtomI(int indexI) {
        this.indexI = indexI;
        this.atomI = this.atoms[indexI];
        this.centerI = this.atomI;
        this.radiusI = this.getAppropriateRadius(this.atomI);
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    void calcConvexMap() {
        this.calcConvexBits();
        int[] map = mapNull;
        int count = this.getMapStorageCount(this.geodesicMap);
        if (count > 0) {
            this.bsSurface.set(this.indexI);
            if (this.isSurface) {
                this.addIncompleteFaces(this.geodesicMap, this.dotsRenderer.geodesic);
                this.addIncompleteFaces(this.geodesicMap, this.dotsRenderer.geodesic);
            }
            count = this.getMapStorageCount(this.geodesicMap);
            map = new int[count];
            System.arraycopy(this.geodesicMap, 0, map, 0, count);
        }
        this.dotsConvexMaps[this.indexI] = map;
    }

    int getMapStorageCount(int[] map) {
        int indexLast = map.length;
        while (--indexLast >= 0 && map[indexLast] == 0) {
        }
        return indexLast + 1;
    }

    void addIncompleteFaces(int[] points, DotsRenderer.Geodesic g) {
        Dots.clearBitmap(this.mapT);
        short[] faces = g.faceIndices;
        int len = faces.length;
        short maxPt = -1;
        int f = 0;
        while (f < len) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            boolean ok1 = Dots.getBit(points, p1);
            boolean ok2 = Dots.getBit(points, p2);
            boolean ok3 = Dots.getBit(points, p3);
            if (!ok1 && !ok2 && !ok3 || ok1 && ok2 && ok3) continue;
            if (!ok1) {
                Dots.setBit(this.mapT, p1);
                if (maxPt < p1) {
                    maxPt = p1;
                }
            }
            if (!ok2) {
                Dots.setBit(this.mapT, p2);
                if (maxPt < p2) {
                    maxPt = p2;
                }
            }
            if (ok3) continue;
            Dots.setBit(this.mapT, p3);
            if (maxPt >= p3) continue;
            maxPt = p3;
        }
        for (short i = 0; i <= maxPt; ++i) {
            if (!Dots.getBit(this.mapT, i)) continue;
            Dots.setBit(points, i);
        }
    }

    void calcConvexBits() {
        Dots.setAllBits(this.geodesicMap, this.geodesicCount);
        float combinedRadii = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] faces = this.dotsRenderer.geodesic.faceIndices;
        int p4 = DotsRenderer.power4[this.dotsRenderer.geodesic.level - 1];
        Dots.clearBitmap(this.mapT);
        Point3f[] vertexTest = this.dotsRenderer.vertexTest;
        for (int i = 0; i < 12; ++i) {
            vertexTest[i].set(this.geodesicVertices[i]);
            vertexTest[i].scaleAdd(combinedRadii, this.centerI);
        }
        for (int f = 0; f < 20; ++f) {
            int faceTest = 0;
            short p1 = faces[3 * p4 * (4 * f + 0)];
            short p2 = faces[3 * p4 * (4 * f + 1)];
            short p3 = faces[3 * p4 * (4 * f + 2)];
            for (int j = 0; j < this.neighborCount; ++j) {
                boolean ok3;
                float maxDist = this.neighborPlusProbeRadii2[j];
                this.centerT = this.neighborCenters[j];
                boolean ok1 = vertexTest[p1].distanceSquared(this.centerT) >= maxDist;
                boolean ok2 = vertexTest[p2].distanceSquared(this.centerT) >= maxDist;
                boolean bl = ok3 = vertexTest[p3].distanceSquared(this.centerT) >= maxDist;
                if (!ok1) {
                    Dots.clearBit(this.geodesicMap, p1);
                }
                if (!ok2) {
                    Dots.clearBit(this.geodesicMap, p2);
                }
                if (!ok3) {
                    Dots.clearBit(this.geodesicMap, p3);
                }
                if (ok1 || ok2 || ok3) continue;
                faceTest = -1;
                break;
            }
            int kFirst = f * 12 * p4;
            int kLast = kFirst + 12 * p4;
            for (int k = kFirst; k < kLast; ++k) {
                short vect = faces[k];
                if (Dots.getBit(this.mapT, vect) || !Dots.getBit(this.geodesicMap, vect)) continue;
                switch (faceTest) {
                    case -1: {
                        Dots.clearBit(this.geodesicMap, vect);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float maxDist = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.set(this.geodesicVertices[vect]);
                            this.pointT.scaleAdd(combinedRadii, this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < maxDist)) continue;
                            Dots.clearBit(this.geodesicMap, vect);
                        }
                        break;
                    }
                }
                Dots.setBit(this.mapT, vect);
            }
        }
    }

    void getNeighbors() {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return;
        }
        AtomIterator iter = this.frame.getWithinModelIterator(this.atomI, this.radiusI + this.diameterP + this.maxRadius);
        while (iter.hasNext()) {
            Atom neighbor = iter.next();
            if (neighbor == this.atomI || this.onlySelectedDots && !this.bsOn.get(neighbor.atomIndex)) continue;
            float neighborRadius = this.getAppropriateRadius(neighbor);
            if (this.centerI.distance(neighbor) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighbors.length) {
                this.neighbors = (Atom[])ArrayUtil.doubleLength(this.neighbors);
                this.neighborIndices = ArrayUtil.doubleLength(this.neighborIndices);
                this.neighborCenters = (Point3f[])ArrayUtil.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = ArrayUtil.doubleLength(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = ArrayUtil.doubleLength(this.neighborRadii2);
            }
            this.neighbors[this.neighborCount] = neighbor;
            this.neighborCenters[this.neighborCount] = neighbor;
            this.neighborIndices[this.neighborCount] = neighbor.atomIndex;
            float neighborPlusProbeRadii = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = neighborPlusProbeRadii * neighborPlusProbeRadii;
            this.neighborRadii2[this.neighborCount] = neighborRadius * neighborRadius;
            ++this.neighborCount;
        }
    }

    static final int[] allocateBitmap(int count) {
        return new int[count + 31 >> 5];
    }

    static final void setBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] | 1 << (~i & 0x1F);
    }

    static final void clearBit(int[] bitmap, int i) {
        int n = i >> 5;
        bitmap[n] = bitmap[n] & ~(1 << (~i & 0x1F));
    }

    static final boolean getBit(int[] bitmap, int i) {
        return bitmap[i >> 5] << (i & 0x1F) < 0;
    }

    static final void setAllBits(int[] bitmap, int count) {
        int i = count >> 5;
        if ((count & 0x1F) != 0) {
            bitmap[i] = Integer.MIN_VALUE >> count - 1;
        }
        while (--i >= 0) {
            bitmap[i] = -1;
        }
    }

    static final void clearBitmap(int[] bitmap) {
        int i = bitmap.length;
        while (--i >= 0) {
            bitmap[i] = 0;
        }
    }

    void setModelClickability() {
        int i = this.atomCount;
        while (--i >= 0) {
            Atom atom = this.atoms[i];
            if ((atom.shapeVisibilityFlags & this.myVisibilityFlag) == 0 || this.frame.bsHidden.get(i)) continue;
            atom.clickabilityFlags |= this.myVisibilityFlag;
        }
    }

    String getShapeState() {
        if (this.dotsConvexMaps == null) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        Hashtable temp = new Hashtable();
        int atomCount = this.viewer.getAtomCount();
        String type = this.isSurface ? "geoSurface " : "dots ";
        for (int i = 0; i < atomCount; ++i) {
            if (this.dotsConvexMaps[i] == null) continue;
            if (!this.isSurface && this.bsColixSet != null && this.bsColixSet.get(i)) {
                Shape.setStateInfo(temp, i, this.getColorCommand(type, this.paletteIDs[i], this.colixes[i]));
            }
            BitSet bs = new BitSet();
            int[] map = this.dotsConvexMaps[i];
            int iDot = map.length << 5;
            while (--iDot >= 0) {
                if (!Dots.getBit(map, iDot)) continue;
                bs.set(iDot);
            }
            Shape.appendCmd(s, type + i + " radius " + this.getAppropriateRadius(this.atoms[i]) + " " + StateManager.escape(bs));
        }
        if (this.isSurface) {
            Shape.appendCmd(s, this.getColorCommand("geoSurface", this.surfaceColix));
        } else {
            s.append(Shape.getShapeCommands(temp, null, atomCount));
        }
        return s.toString();
    }
}

