/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Logger;
import org.jmol.viewer.Group;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Compiler {
    Viewer viewer;
    String filename;
    String script;
    short[] lineNumbers;
    short[] lineIndices;
    Token[][] aatokenCompiled;
    boolean error;
    String errorMessage;
    String errorLine;
    boolean preDefining;
    boolean isSilent;
    boolean logMessages = false;
    int cchScript;
    short lineCurrent;
    int ichToken;
    int cchToken;
    Token[] atokenCommand;
    int ichCurrentCommand;
    boolean iHaveQuotedString = false;
    String[] loadFormats = new String[]{"alchemy ", "mol2 ", "mopac ", "nmrpdb ", "charmm ", "xyz ", "mdl ", "pdb "};
    boolean bracketsOpen;
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    Token theToken;
    Object theValue;
    boolean residueSpecCodeGenerated;
    int seqcode;

    private void log(String message) {
        if (this.logMessages) {
            Logger.debug(message);
        }
    }

    Compiler(Viewer viewer) {
        this.viewer = viewer;
    }

    static String cleanScriptComments(String script) {
        int pt1;
        int pt;
        while ((pt = script.indexOf("/*")) >= 0 && (pt1 = script.indexOf("*/", pt + 2)) >= 0) {
            script = script.substring(0, pt) + script.substring(pt1 + 2);
        }
        return script;
    }

    boolean compile(String filename, String script, boolean isPredefining, boolean isSilent) {
        this.filename = filename;
        this.isSilent = isSilent;
        this.script = Compiler.cleanScriptComments(script);
        this.logMessages = !isSilent && !isPredefining && Logger.isActiveLevel(0);
        this.lineIndices = null;
        this.lineNumbers = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        boolean bl = this.preDefining = filename == "#predefine";
        if (this.compile0()) {
            return true;
        }
        int icharEnd = script.indexOf(13, this.ichCurrentCommand);
        if (icharEnd == -1 && (icharEnd = script.indexOf(10, this.ichCurrentCommand)) == -1) {
            icharEnd = script.length();
        }
        this.errorLine = script.substring(this.ichCurrentCommand, icharEnd);
        return false;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    short[] getLineIndices() {
        return this.lineIndices;
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    String getErrorMessage() {
        String strError = this.errorMessage;
        strError = strError + " : " + this.errorLine + "\n";
        if (this.filename != null) {
            strError = strError + this.filename;
        }
        strError = strError + " line#" + this.lineCurrent;
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
        }
        return strError;
    }

    /*
     * Unable to fully structure code
     */
    boolean compile0() {
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.lineCurrent = 1;
        lnLength = 8;
        this.lineNumbers = new short[lnLength];
        this.lineIndices = new short[lnLength];
        this.error = false;
        lltoken = new Vector<Token[]>();
        ltoken = new Vector<Token>();
        tokCommand = 0;
        nTokens = 0;
        while (true) {
            block40: {
                block44: {
                    block43: {
                        block42: {
                            block41: {
                                if (this.lookingAtLeadingWhitespace()) break block40;
                                ++nTokens;
                                if (this.lookingAtComment()) break block40;
                                endOfLine = this.lookingAtEndOfLine();
                                if (!endOfLine && !this.lookingAtEndOfStatement()) break block41;
                                if (tokCommand != 0) {
                                    if (!this.compileCommand(ltoken)) {
                                        return false;
                                    }
                                    lltoken.addElement(this.atokenCommand);
                                    iCommand = lltoken.size();
                                    if (iCommand == lnLength) {
                                        lnT = new short[lnLength * 2];
                                        System.arraycopy(this.lineNumbers, 0, lnT, 0, lnLength);
                                        this.lineNumbers = lnT;
                                        lnT = new short[lnLength * 2];
                                        System.arraycopy(this.lineIndices, 0, lnT, 0, lnLength);
                                        this.lineIndices = lnT;
                                        lnLength *= 2;
                                    }
                                    this.lineNumbers[iCommand] = this.lineCurrent;
                                    this.lineIndices[iCommand] = (short)this.ichCurrentCommand;
                                    ltoken.setSize(0);
                                    tokCommand = 0;
                                    this.iHaveQuotedString = false;
                                    nTokens = 0;
                                }
                                if (this.ichToken >= this.cchScript) break;
                                if (endOfLine) {
                                    this.lineCurrent = (short)(this.lineCurrent + 1);
                                }
                                break block40;
                            }
                            if (tokCommand != 0) break block42;
                            this.bracketsOpen = false;
                            ** GOTO lbl-1000
                        }
                        if (!this.lookingAtString()) break block43;
                        if (this.cchToken < 0) {
                            return this.rightParenthesisExpected();
                        }
                        str = tokCommand == 0x200110 && this.iHaveQuotedString == false ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
                        ltoken.addElement(new Token(4, str));
                        this.iHaveQuotedString = true;
                        if (tokCommand == 264) {
                            this.getData(ltoken, str);
                        }
                        break block40;
                    }
                    if (tokCommand != 0x200110) break block44;
                    if (this.lookingAtLoadFormat()) break block40;
                    if (this.iHaveQuotedString || !this.lookingAtSpecialString()) break block44;
                    str = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                    pt = str.indexOf(" ");
                    if (pt > 0) {
                        this.cchToken = pt;
                        str = str.substring(0, pt);
                    }
                    ltoken.addElement(new Token(4, str));
                    this.iHaveQuotedString = true;
                    break block40;
                }
                if (tokCommand != 2349) ** GOTO lbl77
                pt = this.cchToken;
                if (nTokens <= 2 || this.iHaveQuotedString || !this.lookingAtSpecialString()) ** GOTO lbl77
                str = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                if (str.indexOf(" ") < 0) {
                    ltoken.addElement(new Token(4, str));
                    this.iHaveQuotedString = true;
                } else {
                    this.cchToken = pt;
lbl77:
                    // 3 sources

                    if ((tokCommand & 0x100000) != 0 && this.lookingAtSpecialString()) {
                        str = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                        ltoken.addElement(new Token(4, str));
                    } else {
                        value = this.lookingAtExponential();
                        if (!Float.isNaN(value)) {
                            ltoken.addElement(new Token(3, new Float(value)));
                        } else if (this.lookingAtDecimal()) {
                            value = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                            ltoken.addElement(new Token(3, new Float(value)));
                        } else if (this.lookingAtSeqcode()) {
                            ch = this.script.charAt(this.ichToken);
                            seqNum = ch == '*' || ch == '^' ? 0 : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                            insertionCode = this.script.charAt(this.ichToken + this.cchToken - 1);
                            if (insertionCode == '^') {
                                insertionCode = ' ';
                            }
                            seqcode = Group.getSeqcode(seqNum, insertionCode);
                            ltoken.addElement(new Token(5, seqcode, "seqcode"));
                        } else if (this.lookingAtInteger((tokCommand & 0x200000) != 0)) {
                            intString = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            val = Integer.parseInt(intString);
                            ltoken.addElement(new Token(2, val, intString));
                        } else if (this.lookingAtLookupToken()) {
                            ident = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            if (ident.length() == 1) {
                                token = (Token)Token.map.get(ident);
                                if (token == null && (token = (Token)Token.map.get(lowerCaseIdent = ident.toLowerCase())) != null) {
                                    token = new Token(token.tok, token.intValue, ident);
                                }
                            } else {
                                ident = ident.toLowerCase();
                                v0 = token = this.bracketsOpen != false ? null : (Token)Token.map.get(ident);
                            }
                            if (token == null) {
                                token = new Token(1, ident);
                            }
                            tok = token.tok;
                            switch (tokCommand) {
                                case 0: {
                                    this.ichCurrentCommand = this.ichToken;
                                    tokCommand = tok;
                                    if ((tokCommand & 256) != 0) break;
                                    return this.commandExpected(this.script.substring(this.ichCurrentCommand));
                                }
                                case 2106655: {
                                    if (ltoken.size() != 1) break;
                                    if ((tok & 0x400000) != 0) {
                                        tokCommand = tok;
                                        ltoken.removeAllElements();
                                        break;
                                    }
                                    if ((tok & 2048) != 0 || tok == 1) break;
                                    return this.cannotSet(ident);
                                }
                                case 777: {
                                    if (ltoken.size() == 1) {
                                        if (!this.preDefining && tok != 1) {
                                            if ((tok & 294912) != 294912) {
                                                Logger.warn("WARNING: redefining " + ident + "; was " + token);
                                                token.tok = 1;
                                                tok = 1;
                                                Token.map.put(ident, token);
                                                Logger.warn("WARNING: not all commands may continue to be functional for the life of the applet!");
                                            } else {
                                                Logger.warn("WARNING: predefined term '" + ident + "' has been redefined by the user until the next file load.");
                                            }
                                        }
                                        if (tok == 1 || (tok & 294912) == 294912) break;
                                        return this.invalidExpressionToken(ident);
                                    }
                                    if (tok == 1 || tok == 2106655 || (tok & 294912) != 0) break;
                                    return this.invalidExpressionToken(ident);
                                }
                                case 2820: {
                                    if (tok == 1 || tok == 8388627 || (tok & 32768) != 0) break;
                                    return this.invalidExpressionToken(ident);
                                }
                                case 793: 
                                case 798: 
                                case 2923: {
                                    if (tok == 1 || (tok & 32768) != 0) break;
                                    return this.invalidExpressionToken(ident);
                                }
                            }
                            ltoken.addElement(token);
                        } else {
                            if (ltoken.size() == 0) {
                                return this.commandExpected();
                            }
                            return this.unrecognizedToken(this.script);
                        }
                    }
                }
            }
            this.ichToken += this.cchToken;
        }
        this.aatokenCompiled = new Token[lltoken.size()][];
        lltoken.copyInto((Object[])this.aatokenCompiled);
        return true;
    }

    void getData(Vector ltoken, String key) {
        int i;
        this.ichToken += key.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            ++this.ichToken;
        }
        if ((i = this.script.indexOf("end \"" + key + "\"", this.ichToken)) < 0) {
            i = this.script.length();
        }
        String str = this.script.substring(this.ichToken, i);
        ltoken.addElement(new Token(264, str));
        this.cchToken = i - this.ichToken + 6 + key.length();
    }

    private static final boolean isSpaceOrTab(char ch) {
        return ch == ' ' || ch == '\t';
    }

    boolean lookingAtLeadingWhitespace() {
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(ichT)); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        return this.cchToken > 0;
    }

    boolean lookingAtComment() {
        char ch;
        int ichEnd;
        int ichFirstSharp = -1;
        for (ichEnd = this.ichToken; ichEnd < this.cchScript && !this.eol(ch = this.script.charAt(ichEnd)); ++ichEnd) {
            if (ch != '#' || ichFirstSharp != -1) continue;
            ichFirstSharp = ichEnd;
        }
        if (ichFirstSharp == -1) {
            return false;
        }
        if (this.cchScript - ichFirstSharp >= 3 && this.script.charAt(ichFirstSharp + 1) == 'j' && this.script.charAt(ichFirstSharp + 2) == 'c') {
            this.cchToken = ichEnd - this.ichToken;
            return true;
        }
        if (ichFirstSharp != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = ichEnd - this.ichToken;
        return true;
    }

    boolean eol(char ch) {
        return ch == ';' || ch == '\r' || ch == '\n';
    }

    boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT);
        if (ch == '\r') {
            if (++ichT < this.cchScript && this.script.charAt(ichT) == '\n') {
                ++ichT;
            }
        } else if (ch == '\n') {
            ++ichT;
        } else {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';') {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    boolean lookingAtString() {
        char ch;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int ichT = this.ichToken;
        boolean previousCharBackslash = false;
        while (++ichT < this.cchScript && ((ch = this.script.charAt(ichT)) != '\"' || previousCharBackslash)) {
            previousCharBackslash = ch == '\\' ? !previousCharBackslash : false;
        }
        this.cchToken = ichT == this.cchScript ? -1 : ++ichT - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer sb = new StringBuffer(this.cchToken - 2);
        int ichMax = this.ichToken + this.cchToken - 1;
        int ich = this.ichToken + 1;
        while (ich < ichMax) {
            int ch;
            if ((ch = this.script.charAt(ich++)) == 92 && ich < ichMax) {
                ch = this.script.charAt(ich++);
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 114: {
                        ch = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char chT;
                        int hexit;
                        int digitCount;
                        int n = digitCount = ch == 120 ? 2 : 4;
                        if (ich >= ichMax) break;
                        int unicode = 0;
                        int k = digitCount;
                        while (--k >= 0 && ich < ichMax && (hexit = Compiler.getHexitValue(chT = this.script.charAt(ich))) >= 0) {
                            unicode <<= 4;
                            unicode += hexit;
                            ++ich;
                        }
                        ch = (char)unicode;
                    }
                }
            }
            sb.append((char)ch);
        }
        return "" + sb;
    }

    static int getHexitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return 10 + ch - 97;
        }
        if (ch >= 'A' && ch <= 'F') {
            return 10 + ch - 65;
        }
        return -1;
    }

    boolean lookingAtLoadFormat() {
        int i = this.loadFormats.length;
        while (--i >= 0) {
            String strFormat = this.loadFormats[i];
            int cchFormat = strFormat.length();
            if (!this.script.regionMatches(true, this.ichToken, strFormat, 0, cchFormat)) continue;
            this.cchToken = cchFormat - 1;
            return true;
        }
        return false;
    }

    boolean lookingAtSpecialString() {
        int ichT;
        for (ichT = this.ichToken; ichT < this.cchScript && !this.eol(this.script.charAt(ichT)); ++ichT) {
        }
        this.cchToken = ichT - this.ichToken;
        this.log("lookingAtSpecialString cchToken=" + this.cchToken);
        return this.cchToken > 0;
    }

    float lookingAtExponential() {
        boolean isExponential;
        boolean isNegative;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int ichT = this.ichToken;
        boolean bl = isNegative = this.script.charAt(ichT) == '-';
        if (isNegative) {
            ++ichT;
        }
        int pt0 = ichT;
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT < this.cchScript && ch == 46) {
            ++ichT;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            digitSeen = true;
        }
        if (ichT == this.cchScript || !digitSeen) {
            return Float.NaN;
        }
        int ptE = ichT;
        int factor = 1;
        int exp = 0;
        boolean bl2 = isExponential = ch == 69 || ch == 101;
        if (!isExponential || ++ichT == this.cchScript) {
            return Float.NaN;
        }
        ch = this.script.charAt(ichT);
        if (ch == 45 || ch == 43) {
            ++ichT;
            int n = factor = ch == 45 ? -1 : 1;
        }
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT);
            ch = c;
            if (!Character.isDigit(c)) break;
            ++ichT;
            exp = exp * 10 + ch - 48;
        }
        if (exp == 0) {
            return Float.NaN;
        }
        this.cchToken = ichT - this.ichToken;
        double value = Float.valueOf(this.script.substring(pt0, ptE)).doubleValue();
        return (float)(value *= (double)(isNegative ? -1 : 1) * Math.pow(10.0, factor * exp));
    }

    boolean lookingAtDecimal() {
        char ch1;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (this.script.charAt(ichT) == '-') {
            ++ichT;
        }
        boolean digitSeen = false;
        int ch = 88;
        while (ichT < this.cchScript) {
            char c = this.script.charAt(ichT++);
            ch = c;
            if (!Character.isDigit(c)) break;
            digitSeen = true;
        }
        if (ch != 46) {
            return false;
        }
        if (ichT < this.cchScript && !this.eol(ch1 = this.script.charAt(ichT))) {
            if (Character.isLetter(ch1) || ch1 == '?') {
                return false;
            }
            if (ichT + 1 < this.cchScript && (Character.isLetter(ch1 = this.script.charAt(ichT + 1)) || ch1 == '?')) {
                return false;
            }
        }
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
            digitSeen = true;
        }
        this.cchToken = ichT - this.ichToken;
        return digitSeen;
    }

    boolean lookingAtSeqcode() {
        int ichT;
        char ch = ' ';
        if (ichT + 1 < this.cchScript && this.script.charAt(ichT) == '*' && this.script.charAt(ichT + 1) == '^') {
            ch = '^';
            ++ichT;
        } else {
            for (ichT = this.ichToken; ichT < this.cchScript; ++ichT) {
                char c = this.script.charAt(ichT);
                ch = c;
                if (!Character.isDigit(c)) break;
            }
        }
        if (ch != '^') {
            return false;
        }
        if ((ch = ++ichT == this.cchScript ? (char)' ' : (char)this.script.charAt(ichT++)) != ' ' && ch != '*' && ch != '?' && !Character.isLetter(ch)) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtInteger(boolean allowNegative) {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        if (allowNegative && this.script.charAt(this.ichToken) == '-') {
            ++ichT;
        }
        int ichBeginDigits = ichT;
        while (ichT < this.cchScript && Character.isDigit(this.script.charAt(ichT))) {
            ++ichT;
        }
        if (ichBeginDigits == ichT) {
            return false;
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int ichT = this.ichToken;
        char ch = this.script.charAt(ichT++);
        switch (ch) {
            case '$': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case '@': 
            case '{': 
            case '}': {
                break;
            }
            case '[': {
                this.bracketsOpen = true;
                break;
            }
            case ']': {
                this.bracketsOpen = false;
                break;
            }
            case '&': 
            case '|': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != ch) break;
                ++ichT;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (ichT >= this.cchScript || (ch = this.script.charAt(ichT)) != '<' && ch != '=' && ch != '>') break;
                ++ichT;
                break;
            }
            case '!': 
            case '/': {
                if (ichT >= this.cchScript || this.script.charAt(ichT) != '=') break;
                ++ichT;
                break;
            }
            default: {
                if (!Character.isLetter(ch)) {
                    return false;
                }
            }
            case '?': 
            case '_': 
            case '~': {
                while (ichT < this.cchScript && (Character.isLetterOrDigit(ch = this.script.charAt(ichT)) || ch == '_' || ch == '?' || ch == '~') || ch == '^' && ichT > this.ichToken && Character.isDigit(this.script.charAt(ichT - 1))) {
                    ++ichT;
                }
                break block0;
            }
        }
        this.cchToken = ichT - this.ichToken;
        return true;
    }

    private boolean commandExpected() {
        return this.compileError("command expected");
    }

    private boolean commandExpected(String cmd) {
        int i = cmd.indexOf(" ");
        if (i < 0) {
            i = cmd.length();
        }
        return this.compileError("command expected: " + cmd.substring(0, i));
    }

    private boolean cannotSet(String ident) {
        return this.compileError("cannot SET: " + ident);
    }

    private boolean invalidExpressionToken(String ident) {
        return this.compileError("invalid expression token: " + ident);
    }

    private boolean unrecognizedToken(String ident) {
        return this.compileError("unrecognized token: " + ident);
    }

    private boolean badArgumentCount() {
        return this.compileError("bad argument count");
    }

    private boolean endOfExpressionExpected() {
        return this.compileError("end of expression expected");
    }

    private boolean leftParenthesisExpected() {
        return this.compileError("left parenthesis expected");
    }

    private boolean rightParenthesisExpected() {
        return this.compileError("right parenthesis expected");
    }

    private boolean coordinateExpected() {
        return this.compileError("{number, number, number} expected");
    }

    private boolean commaExpected() {
        return this.compileError("comma expected");
    }

    private boolean commaOrCloseExpected() {
        return this.compileError("comma or right parenthesis expected");
    }

    private boolean stringExpected() {
        return this.compileError("double-quoted string expected");
    }

    private boolean unrecognizedExpressionToken() {
        return this.compileError("unrecognized expression token:" + this.valuePeek());
    }

    private boolean comparisonOperatorExpected() {
        return this.compileError("comparison operator expected");
    }

    private boolean equalSignExpected() {
        return this.compileError("equal sign expected");
    }

    private boolean nonnegativeIntegerExpected() {
        return this.compileError("nonnegative integer expected");
    }

    private boolean numberExpected() {
        return this.compileError("number expected");
    }

    private boolean numberOrKeywordExpected() {
        return this.compileError("number or keyword expected");
    }

    private boolean badRGBColor() {
        return this.compileError("bad [R,G,B] color");
    }

    private boolean identifierOrResidueSpecificationExpected() {
        return this.compileError("identifier or residue specification expected");
    }

    private boolean residueSpecificationExpected() {
        return this.compileError("residue specification (ALA, AL?, A*) expected");
    }

    private boolean invalidChainSpecification() {
        return this.compileError("invalid chain specification");
    }

    private boolean invalidModelSpecification() {
        return this.compileError("invalid model specification");
    }

    private boolean invalidAtomSpecification() {
        return this.compileError("invalid atom specification");
    }

    private boolean compileError(String errorMessage) {
        if (!this.isSilent) {
            Logger.error("compileError(" + errorMessage + ")");
        }
        this.error = true;
        this.errorMessage = errorMessage;
        return false;
    }

    private boolean compileCommand(Vector ltoken) {
        int tok;
        Token tokenCommand = (Token)ltoken.firstElement();
        int tokCommand = tokenCommand.tok;
        int size = ltoken.size();
        if ((tokenCommand.intValue & 0x21) == 33 && size == 1) {
            ltoken.addElement(Token.tokenOn);
        }
        if (tokCommand == 2106655 && size < 2) {
            return this.badArgumentCount();
        }
        this.atokenCommand = new Token[ltoken.size()];
        ltoken.copyInto(this.atokenCommand);
        int n = tok = size == 1 ? 0 : this.atokenCommand[1].tok;
        if (this.logMessages) {
            for (int i = 0; i < this.atokenCommand.length; ++i) {
                Logger.debug(i + ": " + this.atokenCommand[i]);
            }
        }
        if ((tokCommand & 0x80000) != 0 && !this.compileColorParam()) {
            return false;
        }
        if ((tok == 32785 || tok == 8388627) && (tokCommand & 0x200400) != 0x200400) {
            return true;
        }
        if ((tokCommand & 0x600) != 0 && !this.compileExpression()) {
            return false;
        }
        if ((tokenCommand.intValue & 0x10) == 0 && (tokenCommand.intValue & 0xF) + 1 != this.atokenCommand.length) {
            return this.badArgumentCount();
        }
        return true;
    }

    private boolean compileExpression() {
        int tokCommand = this.atokenCommand[0].tok;
        boolean isMultipleOK = (tokCommand & 0x400) != 0;
        int expPtr = 1;
        if (tokCommand == 777) {
            expPtr = 2;
        }
        while (expPtr > 0 && expPtr < this.atokenCommand.length) {
            if (isMultipleOK) {
                while (expPtr < this.atokenCommand.length && this.atokenCommand[expPtr].tok != 32768) {
                    ++expPtr;
                }
            }
            if (expPtr >= this.atokenCommand.length || (expPtr = this.compileExpression(expPtr)) <= 0) break;
            if (isMultipleOK) continue;
            return this.endOfExpressionExpected();
        }
        return expPtr == this.atokenCommand.length || expPtr == 0;
    }

    boolean addTokenToPostfix(Token token) {
        if (this.logMessages) {
            this.log("addTokenToPostfix" + token);
        }
        this.ltokenPostfix.addElement(token);
        return true;
    }

    int compileExpression(int itoken) {
        int i;
        int expPtr = 0;
        this.ltokenPostfix = new Vector();
        for (i = 0; i < itoken; ++i) {
            this.addTokenToPostfix(this.atokenCommand[i]);
        }
        this.atokenInfix = this.atokenCommand;
        this.itokenInfix = itoken;
        this.addTokenToPostfix(Token.tokenExpressionBegin);
        if (!this.clauseOr()) {
            return -1;
        }
        this.addTokenToPostfix(Token.tokenExpressionEnd);
        if (this.itokenInfix != this.atokenInfix.length) {
            expPtr = this.ltokenPostfix.size();
            for (i = this.itokenInfix; i < this.atokenInfix.length; ++i) {
                this.addTokenToPostfix(this.atokenCommand[i]);
            }
        }
        this.atokenCommand = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenCommand);
        return expPtr;
    }

    Token tokenNext() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    void returnToken() {
        --this.itokenInfix;
    }

    Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    boolean isToken(int tok) {
        return this.theToken != null && this.theToken.tok == tok;
    }

    float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    boolean tokenNext(int tok) {
        Token token = this.tokenNext();
        return token != null && token.tok == tok;
    }

    Object valuePeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix].value;
    }

    int intPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return Integer.MAX_VALUE;
        }
        return this.atokenInfix[this.itokenInfix].intValue;
    }

    int tokPeek() {
        if (this.itokenInfix == this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    boolean tokPeek(int tok) {
        if (this.itokenInfix == this.atokenInfix.length) {
            return false;
        }
        return this.atokenInfix[this.itokenInfix].tok == tok;
    }

    boolean clauseOr() {
        if (!this.clauseAnd()) {
            return false;
        }
        while (this.tokPeek(32772) || this.tokPeek(32791) || this.tokPeek(32792)) {
            Token tokenOr = this.tokenNext();
            if (!this.clauseAnd()) {
                return false;
            }
            this.addTokenToPostfix(tokenOr);
        }
        return true;
    }

    boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek(32771)) {
            Token tokenAnd = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            this.addTokenToPostfix(tokenAnd);
        }
        return true;
    }

    boolean clauseNot() {
        if (this.tokPeek(32773)) {
            Token tokenNot = this.tokenNext();
            if (!this.clauseNot()) {
                return false;
            }
            return this.addTokenToPostfix(tokenNot);
        }
        return this.clausePrimitive();
    }

    boolean clausePrimitive() {
        int tok = this.tokPeek();
        switch (tok) {
            case 34820: 
            case 44306: {
                return this.clauseSpecial(tok);
            }
            case 98317: {
                return this.clauseCell();
            }
            case 32774: {
                return this.clauseWithin();
            }
            case 32788: {
                return this.clauseConnected();
            }
            case 32784: {
                return this.clauseSubstructure();
            }
            case 1: 
            case 2: 
            case 5: 
            case 32770: 
            case 32777: 
            case 32780: 
            case 32782: 
            case 49181: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if ((tok & 0x18000) == 98304) {
                    return this.clauseComparator();
                }
                if ((tok & 0x48000) != 294912) break;
            }
            case 36875: 
            case 49157: {
                return this.addTokenToPostfix(this.tokenNext());
            }
            case 32768: {
                this.tokenNext();
                if (!this.clauseOr()) {
                    return false;
                }
                if (!this.tokenNext(32769)) {
                    return this.rightParenthesisExpected();
                }
                return true;
            }
            case 32785: {
                return this.bitset();
            }
        }
        return this.unrecognizedExpressionToken();
    }

    boolean bitset() {
        this.getToken();
        int iPrev = -1;
        BitSet bs = new BitSet();
        block5: while (this.getToken() != null) {
            switch (this.theToken.tok) {
                case 36875: 
                case 49157: {
                    bs = null;
                    if (this.tokenNext(32786) && iPrev < 0) break block5;
                    return this.endOfExpressionExpected();
                }
                case 2: 
                case 32786: {
                    if (iPrev >= 0) {
                        bs.set(iPrev);
                    }
                    if (this.theToken.tok == 32786) break block5;
                    iPrev = this.theToken.intValue;
                    continue block5;
                }
                case 32782: {
                    if (iPrev >= 0) {
                        if (this.getToken() == null || !this.isToken(2)) {
                            return this.invalidExpressionToken(this.theToken.toString());
                        }
                        for (int i = this.theToken.intValue; i >= iPrev; --i) {
                            bs.set(i);
                        }
                        continue block5;
                    }
                }
                default: {
                    return this.invalidExpressionToken(this.theToken.toString());
                }
            }
        }
        return this.addTokenToPostfix(new Token(16455, bs));
    }

    boolean clauseComparator() {
        Token tokenAtomProperty = this.tokenNext();
        Token tokenComparator = this.tokenNext();
        if (tokenComparator == null || (tokenComparator.tok & 0x28000) == 0) {
            return this.comparisonOperatorExpected();
        }
        if (this.getToken() == null) {
            return this.numberExpected();
        }
        boolean isNegative = this.isToken(32770);
        if (isNegative && this.getToken() == null) {
            return this.numberExpected();
        }
        int val = 0;
        switch (this.theToken.tok) {
            case 2: {
                val = this.theToken.intValue;
                switch (tokenAtomProperty.tok) {
                    case 98308: 
                    case 98321: 
                    case 98324: 
                    case 98325: 
                    case 98326: {
                        val *= 100;
                    }
                }
                break;
            }
            case 3: {
                float vf = this.floatValue() * 100.0f;
                if (tokenAtomProperty.tok == 100355) {
                    vf = (float)((double)vf * 2.5);
                }
                val = (int)vf;
                break;
            }
            default: {
                return this.numberExpected();
            }
        }
        return this.addTokenToPostfix(new Token(tokenComparator.tok, tokenAtomProperty.tok, new Integer(val * (isNegative ? -1 : 1))));
    }

    boolean clauseCell() {
        Point3f cell = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(163844)) {
            return this.equalSignExpected();
        }
        if (this.getToken() == null) {
            return this.coordinateExpected();
        }
        if (this.isToken(2)) {
            int nnn = this.theToken.intValue;
            cell.x = nnn / 100 - 4;
            cell.y = nnn % 100 / 10 - 4;
            cell.z = nnn % 10 - 4;
            return this.addTokenToPostfix(new Token(98317, cell));
        }
        if (!this.isToken(32785) || !this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        cell.x = this.floatValue();
        if (this.tokPeek(32772)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.coordinateExpected();
        }
        cell.y = this.floatValue();
        if (this.tokPeek(32772)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(32786)) {
            return this.coordinateExpected();
        }
        cell.z = this.floatValue();
        return this.addTokenToPostfix(new Token(98317, cell));
    }

    boolean clauseSpecial(int tok) {
        if (this.itokenInfix != 1) {
            return this.invalidExpressionToken(this.tokenNext().toString());
        }
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        this.addTokenToPostfix(new Token(tok));
        if (!this.bitset()) {
            return false;
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        if (this.tokenNext() != null) {
            return this.endOfExpressionExpected();
        }
        return true;
    }

    boolean clauseWithin() {
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        Object distance = null;
        if (this.getToken() == null) {
            return this.numberOrKeywordExpected();
        }
        switch (this.theToken.tok) {
            case 2: {
                distance = new Float((float)(this.theToken.intValue * 4) / 1000.0f);
                break;
            }
            case 3: 
            case 4: 
            case 36868: 
            case 36869: 
            case 98318: 
            case 98319: 
            case 98565: 
            case 98572: {
                distance = this.theToken.value;
                break;
            }
            default: {
                return this.numberOrKeywordExpected();
            }
        }
        if (!this.tokenNext(32772)) {
            return this.commaExpected();
        }
        if (this.tokPeek(32785)) {
            return this.addTokenToPostfix(new Token(32774, new Float(Float.NaN)));
        }
        if (!this.clauseOr()) {
            return false;
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32774, distance));
    }

    boolean clauseConnected() {
        int min = 1;
        int max = 100;
        boolean iHaveExpression = false;
        this.tokenNext();
        while (!iHaveExpression && this.tokPeek(32768)) {
            this.tokenNext();
            this.getToken();
            if (this.isToken(2)) {
                min = max = this.theToken.intValue;
                if (max < 0) {
                    return this.nonnegativeIntegerExpected();
                }
                if (this.getToken() == null || !this.isToken(32769) && !this.isToken(32772)) {
                    return this.commaOrCloseExpected();
                }
                if (this.isToken(32769)) break;
                this.getToken();
                if (this.isToken(2)) {
                    max = this.theToken.intValue;
                    if (max < 0) {
                        return this.nonnegativeIntegerExpected();
                    }
                    if (this.getToken() == null || !this.isToken(32769) && !this.isToken(32772)) {
                        return this.commaOrCloseExpected();
                    }
                    if (this.isToken(32769)) break;
                    this.getToken();
                }
            }
            if (this.isToken(32769)) break;
            this.returnToken();
            if (!this.clauseOr()) {
                return false;
            }
            if (!this.tokenNext(32769)) {
                return this.rightParenthesisExpected();
            }
            iHaveExpression = true;
        }
        if (!iHaveExpression) {
            this.addTokenToPostfix(new Token(36875));
        }
        return this.addTokenToPostfix(new Token(32788, min, new Integer(max)));
    }

    boolean clauseSubstructure() {
        this.tokenNext();
        if (!this.tokenNext(32768)) {
            return this.leftParenthesisExpected();
        }
        if (this.getToken() == null || !this.isToken(4)) {
            return this.stringExpected();
        }
        if (!this.tokenNext(32769)) {
            return this.rightParenthesisExpected();
        }
        return this.addTokenToPostfix(new Token(32784, this.theValue));
    }

    boolean generateResidueSpecCode(Token token) {
        this.addTokenToPostfix(token);
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.residueSpecCodeGenerated = true;
        return true;
    }

    boolean clauseResidueSpec() {
        boolean specSeen = false;
        this.residueSpecCodeGenerated = false;
        int tok = this.tokPeek();
        if (tok == 32777 || tok == 32780 || tok == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32777 || tok == 32770 || tok == 2 || tok == 5) {
            if (!this.clauseResNumSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32777 || tok == 1 || tok == 2) {
            if (!this.clauseChainSpec(tok)) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32779) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 49181) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (tok == 32782 || tok == 32783) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            specSeen = true;
            tok = this.tokPeek();
        }
        if (!specSeen) {
            return this.residueSpecificationExpected();
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    boolean clauseResNameSpec() {
        this.getToken();
        if (this.isToken(32777) || this.isToken(0)) {
            return !this.isToken(0);
        }
        if (this.isToken(32780)) {
            int pt;
            String strSpec = "";
            while (this.getToken() != null && !this.isToken(32781)) {
                strSpec = strSpec + this.theValue;
            }
            if (!this.isToken(32781)) {
                return false;
            }
            if (strSpec == "") {
                return true;
            }
            if (strSpec.length() > 0 && (pt = strSpec.indexOf("*")) >= 0 && pt != strSpec.length() - 1) {
                return this.residueSpecificationExpected();
            }
            strSpec = strSpec.toUpperCase();
            return this.generateResidueSpecCode(new Token(16406, strSpec));
        }
        if (!this.isToken(1)) {
            return this.identifierOrResidueSpecificationExpected();
        }
        if (this.tokPeek(32777)) {
            String res = this.theValue + "*";
            this.getToken();
            return this.generateResidueSpecCode(new Token(1, res));
        }
        return this.generateResidueSpecCode(this.theToken);
    }

    boolean clauseResNumSpec() {
        this.log("clauseResNumSpec()");
        if (this.tokPeek(32777)) {
            return this.getToken() != null;
        }
        return this.clauseSequenceRange();
    }

    boolean clauseSequenceRange() {
        if (!this.clauseSequenceCode()) {
            return false;
        }
        int tok = this.tokPeek();
        if (tok == 32770 || tok == 2 && this.intPeek() < 0) {
            if (tok == 32770) {
                this.tokenNext();
            }
            int seqcodeA = this.seqcode;
            if (!this.clauseSequenceCode()) {
                this.seqcode = Integer.MAX_VALUE;
            }
            return this.generateResidueSpecCode(new Token(16408, seqcodeA, new Integer(this.seqcode)));
        }
        return this.generateResidueSpecCode(new Token(16407, this.seqcode, "seqcode"));
    }

    boolean clauseSequenceCode() {
        boolean negative = false;
        int tokPeek = this.tokPeek();
        if (tokPeek == 32770) {
            this.tokenNext();
            negative = true;
            tokPeek = this.tokPeek();
        }
        if (tokPeek == 5) {
            this.seqcode = this.tokenNext().intValue;
        } else if (tokPeek == 2) {
            int val = this.tokenNext().intValue;
            this.seqcode = Group.getSeqcode(Math.abs(val), ' ');
        } else {
            return false;
        }
        if (negative) {
            this.seqcode = -this.seqcode;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    boolean clauseChainSpec(int tok) {
        void var2_3;
        if (tok == 32782) {
            this.tokenNext();
            tok = this.tokPeek();
            if (this.isSpecTerminator(tok)) {
                return this.generateResidueSpecCode(new Token(16409, 0, "spec_chain"));
            }
        }
        if (tok == 32777) {
            return this.getToken() != null;
        }
        switch (tok) {
            case 2: {
                this.getToken();
                int val = this.theToken.intValue;
                if (val < 0 || val > 9) {
                    return this.invalidChainSpecification();
                }
                char chain = (char)(48 + val);
                break;
            }
            case 1: {
                String strChain = (String)this.getToken().value;
                if (strChain.length() != 1) {
                    return this.invalidChainSpecification();
                }
                char chain = strChain.charAt(0);
                if (chain != '?') break;
                return true;
            }
            default: {
                return this.invalidChainSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16409, (int)var2_3, "spec_chain"));
    }

    boolean isSpecTerminator(int tok) {
        switch (tok) {
            case 0: 
            case 32769: 
            case 32771: 
            case 32772: 
            case 32773: 
            case 32783: 
            case 49181: {
                return true;
            }
        }
        return false;
    }

    boolean clauseAlternateSpec() {
        this.tokenNext();
        int tok = this.tokPeek();
        if (this.isSpecTerminator(tok)) {
            return this.generateResidueSpecCode(new Token(16410, null));
        }
        String alternate = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 32777: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16410, alternate));
    }

    boolean clauseModelSpec() {
        this.getToken();
        if (this.isToken(32782) || this.isToken(32783)) {
            this.getToken();
        }
        if (this.isToken(32777)) {
            return true;
        }
        if (this.isToken(0) || this.theToken == null) {
            return this.invalidModelSpecification();
        }
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                return this.invalidModelSpecification();
            }
        }
        return this.generateResidueSpecCode(new Token(16411, this.theValue));
    }

    boolean clauseAtomSpec() {
        if (!this.tokenNext(32779)) {
            return this.invalidAtomSpecification();
        }
        if (this.getToken() == null) {
            return true;
        }
        String atomSpec = "";
        if (this.isToken(2)) {
            atomSpec = atomSpec + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.invalidAtomSpecification();
            }
        }
        switch (this.theToken.tok) {
            case 32777: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.invalidAtomSpecification();
            }
        }
        atomSpec = atomSpec + this.theValue;
        if (this.tokPeek(32777)) {
            this.tokenNext();
            atomSpec = atomSpec + "*";
        }
        return this.generateResidueSpecCode(new Token(16412, atomSpec));
    }

    boolean compileColorParam() {
        for (int i = 1; i < this.atokenCommand.length; ++i) {
            String id;
            int argb;
            this.theToken = this.atokenCommand[i];
            if (this.isToken(32780)) {
                if (this.compileRGB(i)) continue;
                return false;
            }
            if (this.isToken(8388627)) {
                ++i;
                continue;
            }
            if (!this.isToken(1) || (argb = Graphics3D.getArgbFromString(id = (String)this.theToken.value)) == 0) continue;
            this.theToken.tok = 540692;
            this.theToken.intValue = argb;
        }
        return true;
    }

    boolean compileRGB(int i) {
        String hex;
        Token[] atoken = this.atokenCommand;
        if (atoken.length >= i + 7 && atoken[i].tok == 32780 && atoken[i + 1].tok == 2 && atoken[i + 2].tok == 32772 && atoken[i + 3].tok == 2 && atoken[i + 4].tok == 32772 && atoken[i + 5].tok == 2 && atoken[i + 6].tok == 32781) {
            int argb = 0xFF000000 | atoken[i + 1].intValue << 16 | atoken[i + 3].intValue << 8 | atoken[i + 5].intValue;
            atoken[i++] = new Token(540692, argb, "[R,G,B]");
            for (int ipt = i + 6; ipt < atoken.length; ++ipt) {
                atoken[i++] = atoken[ipt];
            }
            Token[] atokenNew = new Token[i];
            System.arraycopy(atoken, 0, atokenNew, 0, i);
            this.atokenCommand = atokenNew;
            return true;
        }
        if (atoken.length >= i + 3 && atoken[i].tok == 32780 && atoken[i + 1].tok == 1 && atoken[i + 2].tok == 32781 && (hex = (String)atoken[i + 1].value).length() == 7 && hex.charAt(0) == 'x') {
            try {
                int argb = 0xFF000000 | Integer.parseInt(hex.substring(1), 16);
                atoken[i++] = new Token(540692, argb, "[xRRGGBB]");
                for (int ipt = i + 2; ipt < atoken.length; ++ipt) {
                    atoken[i++] = atoken[ipt];
                }
                Token[] atokenNew = new Token[i];
                System.arraycopy(atoken, 0, atokenNew, 0, i);
                this.atokenCommand = atokenNew;
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return this.badRGBColor();
    }
}

