/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Backbone;
import org.jmol.viewer.Mps;
import org.jmol.viewer.MpsRenderer;

class BackboneRenderer
extends MpsRenderer {
    BackboneRenderer() {
    }

    void renderMpspolymer(Mps.MpsShape mpspolymer) {
        this.renderBackboneChain((Backbone.Bbpolymer)mpspolymer);
    }

    void renderBackboneChain(Backbone.Bbpolymer bbpolymer) {
        this.render1();
    }

    void render1() {
        int i = this.monomerCount - 1;
        while (--i >= 0) {
            if (!this.bsVisible.get(i)) continue;
            Atom atomA = this.frame.getAtomAt(this.leadAtomIndices[i]);
            Atom atomB = this.frame.getAtomAt(this.leadAtomIndices[i + 1]);
            if (atomA.nBackbonesDisplayed == 0 || atomB.nBackbonesDisplayed == 0 || this.frame.bsHidden.get(atomB.atomIndex)) continue;
            int xA = atomA.screenX;
            int yA = atomA.screenY;
            int zA = atomA.screenZ;
            int xB = atomB.screenX;
            int yB = atomB.screenY;
            int zB = atomB.screenZ;
            short colixA = Graphics3D.getColixInherited(this.colixes[i], atomA.colixAtom);
            short colixB = Graphics3D.getColixInherited(this.colixes[i + 1], atomB.colixAtom);
            if (this.mads[i] < 0) {
                this.g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
                continue;
            }
            short width = this.viewer.scaleToScreen((zA + zB) / 2, this.mads[i]);
            this.g3d.fillCylinder(colixA, colixB, (byte)3, width, xA, yA, zA, xB, yB, zB);
        }
    }
}

