/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.FontLineShape;

class Axes
extends FontLineShape {
    static final Point3f[] unitAxisPoints = new Point3f[]{new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, 1.0f), new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f)};
    float scale = 1.0f;
    final Point3f originPoint = new Point3f();
    final Point3f[] axisPoints = new Point3f[6];
    static final float MIN_AXIS_LEN = 1.5f;

    Axes() {
        int i = 6;
        while (--i >= 0) {
            this.axisPoints[i] = new Point3f();
        }
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("scale" == propertyName) {
            this.setScale(((Float)value).floatValue());
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    void initShape() {
        this.myType = "axes";
        this.font3d = this.g3d.getFont3D(14);
        int axesMode = this.viewer.getAxesMode();
        if (axesMode == 2 && this.frame.cellInfos != null) {
            UnitCell unitcell = this.viewer.getCurrentUnitCell();
            if (unitcell == null) {
                return;
            }
            Point3f[] vectors = unitcell.getVertices();
            Point3f offset = unitcell.getCartesianOffset();
            this.originPoint.set(offset);
            this.axisPoints[0].add(offset, vectors[4]);
            this.axisPoints[1].add(offset, vectors[2]);
            this.axisPoints[2].add(offset, vectors[1]);
            return;
        }
        if (axesMode == 1) {
            this.originPoint.set(0.0f, 0.0f, 0.0f);
        } else {
            this.originPoint.set(this.viewer.getBoundBoxCenter());
        }
        Vector3f corner = this.viewer.getBoundBoxCornerVector();
        int i = 6;
        while (--i >= 0) {
            Point3f axisPoint = this.axisPoints[i];
            axisPoint.set(unitAxisPoints[i]);
            if (corner.x < 1.5f) {
                corner.x = 1.5f;
            }
            if (corner.y < 1.5f) {
                corner.y = 1.5f;
            }
            if (corner.z < 1.5f) {
                corner.z = 1.5f;
            }
            axisPoint.x *= corner.x * this.scale;
            axisPoint.y *= corner.y * this.scale;
            axisPoint.z *= corner.z * this.scale;
            axisPoint.add(this.originPoint);
        }
    }

    void setScale(float angstroms) {
        this.scale = angstroms;
        this.initShape();
    }

    String getShapeState() {
        return super.getShapeState() + "set axes scale " + this.scale + ";\n";
    }
}

