/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Line3D;
import org.jmol.g3d.Rgb16;

class Triangle3D {
    final Graphics3D g3d;
    final Line3D line3d;
    final int[] ax = new int[3];
    final int[] ay = new int[3];
    final int[] az = new int[3];
    Rgb16[] rgb16sGouraud;
    private static final boolean VERIFY = false;
    final Rgb16 rgb16t1 = new Rgb16();
    final Rgb16 rgb16t2 = new Rgb16();
    private static final int DEFAULT = 64;
    int[] axW = new int[64];
    int[] azW = new int[64];
    int[] axE = new int[64];
    int[] azE = new int[64];
    Rgb16[] rgb16sW = new Rgb16[64];
    Rgb16[] rgb16sE = new Rgb16[64];
    private static int bar;

    Triangle3D(Graphics3D g3d) {
        int i = 64;
        while (--i >= 0) {
            this.rgb16sW[i] = new Rgb16();
            this.rgb16sE[i] = new Rgb16();
        }
        this.g3d = g3d;
        this.line3d = g3d.line3d;
        this.rgb16sGouraud = new Rgb16[3];
        i = 3;
        while (--i >= 0) {
            this.rgb16sGouraud[i] = new Rgb16();
        }
    }

    Rgb16[] reallocRgb16s(Rgb16[] rgb16s, int n) {
        Rgb16[] t = new Rgb16[n];
        System.arraycopy(rgb16s, 0, t, 0, rgb16s.length);
        for (int i = rgb16s.length; i < n; ++i) {
            t[i] = new Rgb16();
        }
        return t;
    }

    void setGouraud(int rgbA, int rgbB, int rgbC) {
        this.rgb16sGouraud[0].set(rgbA);
        this.rgb16sGouraud[1].set(rgbB);
        this.rgb16sGouraud[2].set(rgbC);
    }

    void drawfillTriangle(int xA, int yA, int zA, int xB, int yB, int zB, int xC, int yC, int zC, boolean useGouraud) {
        this.ax[0] = xA;
        this.ax[1] = xB;
        this.ax[2] = xC;
        this.ay[0] = yA;
        this.ay[1] = yB;
        this.ay[2] = yC;
        this.az[0] = zA;
        this.az[1] = zB;
        this.az[2] = zC;
        this.fillTriangle(useGouraud);
    }

    void fillTriangle(int xScreenA, int yScreenA, int zScreenA, int xScreenB, int yScreenB, int zScreenB, int xScreenC, int yScreenC, int zScreenC, boolean useGouraud) {
        this.ax[0] = xScreenA;
        this.ax[1] = xScreenB;
        this.ax[2] = xScreenC;
        this.ay[0] = yScreenA;
        this.ay[1] = yScreenB;
        this.ay[2] = yScreenC;
        this.az[0] = zScreenA;
        this.az[1] = zScreenB;
        this.az[2] = zScreenC;
        this.fillTriangle(useGouraud);
    }

    void fillTriangle(Point3i screenA, Point3i screenB, Point3i screenC, boolean useGouraud) {
        this.ax[0] = screenA.x;
        this.ax[1] = screenB.x;
        this.ax[2] = screenC.x;
        this.ay[0] = screenA.y;
        this.ay[1] = screenB.y;
        this.ay[2] = screenC.y;
        this.az[0] = screenA.z;
        this.az[1] = screenB.z;
        this.az[2] = screenC.z;
        this.fillTriangle(useGouraud);
    }

    void fillTriangle(Point3f screenA, Point3f screenB, Point3f screenC, boolean useGouraud) {
        this.ax[0] = (int)screenA.x;
        this.ax[1] = (int)screenB.x;
        this.ax[2] = (int)screenC.x;
        this.ay[0] = (int)screenA.y;
        this.ay[1] = (int)screenB.y;
        this.ay[2] = (int)screenC.y;
        this.az[0] = (int)screenA.z;
        this.az[1] = (int)screenB.z;
        this.az[2] = (int)screenC.z;
        this.fillTriangle(useGouraud);
    }

    void fillTriangle(Point3i screenA, Point3i screenB, Point3i screenC, float factor, boolean useGouraud) {
        this.ax[0] = screenA.x;
        this.ax[1] = screenB.x;
        this.ax[2] = screenC.x;
        this.ay[0] = screenA.y;
        this.ay[1] = screenB.y;
        this.ay[2] = screenC.y;
        this.az[0] = screenA.z;
        this.az[1] = screenB.z;
        this.az[2] = screenC.z;
        this.adjustVertex(this.ax, factor);
        this.adjustVertex(this.ay, factor);
        this.adjustVertex(this.az, factor);
        this.fillTriangle(useGouraud);
    }

    private void adjustVertex(int[] t, float factor) {
        float av = (float)(t[0] + t[1] + t[2]) / 3.0f;
        for (int i = 0; i < 3; ++i) {
            int n = i;
            t[n] = (int)((float)t[n] + factor * (av - (float)t[i]));
        }
    }

    void fillTriangle(boolean useGouraud) {
        int iMaxY;
        int iMidY;
        int cc2;
        int cc1;
        boolean isClipped;
        int cc0 = this.line3d.clipCode(this.ax[0], this.ay[0], this.az[0]);
        boolean bl = isClipped = (cc0 | (cc1 = this.line3d.clipCode(this.ax[1], this.ay[1], this.az[1])) | (cc2 = this.line3d.clipCode(this.ax[2], this.ay[2], this.az[2]))) != 0;
        if (isClipped && (cc0 & cc1 & cc2) != 0) {
            return;
        }
        int iMinY = 0;
        if (this.ay[1] < this.ay[0]) {
            iMinY = 1;
        }
        if (this.ay[2] < this.ay[iMinY]) {
            iMinY = 2;
        }
        if (this.ay[iMidY = (iMinY + 1) % 3] > this.ay[iMaxY = (iMinY + 2) % 3]) {
            int t = iMidY;
            iMidY = iMaxY;
            iMaxY = t;
        }
        int yMin = this.ay[iMinY];
        int yMid = this.ay[iMidY];
        int yMax = this.ay[iMaxY];
        int nLines = yMax - yMin + 1;
        if (nLines > this.g3d.height * 3) {
            return;
        }
        if (nLines > this.axW.length) {
            this.reallocRasterArrays(nLines);
        }
        Rgb16[] gouraudW = useGouraud ? this.rgb16sW : null;
        Rgb16[] gouraudE = useGouraud ? this.rgb16sE : null;
        int dyMidMin = yMid - yMin;
        if (dyMidMin == 0) {
            if (this.ax[iMidY] < this.ax[iMinY]) {
                int t = iMidY;
                iMidY = iMinY;
                iMinY = t;
            }
            this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0, gouraudW);
            this.generateRaster(nLines, iMidY, iMaxY, this.axE, this.azE, 0, gouraudE);
        } else if (yMid == yMax) {
            if (this.ax[iMaxY] < this.ax[iMidY]) {
                int t = iMidY;
                iMidY = iMaxY;
                iMaxY = t;
            }
            this.generateRaster(nLines, iMinY, iMidY, this.axW, this.azW, 0, gouraudW);
            this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0, gouraudE);
        } else {
            int axSplit;
            int dxMaxMin = this.ax[iMaxY] - this.ax[iMinY];
            int roundFactor = nLines / 2;
            if (dxMaxMin < 0) {
                roundFactor = -roundFactor;
            }
            if ((axSplit = this.ax[iMinY] + (dxMaxMin * dyMidMin + roundFactor) / nLines) < this.ax[iMidY]) {
                this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0, gouraudW);
                this.generateRaster(dyMidMin, iMinY, iMidY, this.axE, this.azE, 0, gouraudE);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axE, this.azE, dyMidMin, gouraudE);
            } else {
                this.generateRaster(dyMidMin, iMinY, iMidY, this.axW, this.azW, 0, gouraudW);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axW, this.azW, dyMidMin, gouraudW);
                this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0, gouraudE);
            }
        }
        this.fillRaster(yMin, nLines, useGouraud, isClipped);
    }

    private void reallocRasterArrays(int n) {
        n = n + 31 & 0xFFFFFFE0;
        this.axW = new int[n];
        this.azW = new int[n];
        this.axE = new int[n];
        this.azE = new int[n];
        this.rgb16sW = this.reallocRgb16s(this.rgb16sW, n);
        this.rgb16sE = this.reallocRgb16s(this.rgb16sE, n);
    }

    private void generateRaster(int dy, int iN, int iS, int[] axRaster, int[] azRaster, int iRaster, Rgb16[] gouraud) {
        int xMajorError;
        int xMajorIncrement;
        int errorTerm;
        int width;
        int xIncrement;
        int xN = this.ax[iN];
        int zN = this.az[iN];
        int xS = this.ax[iS];
        int zS = this.az[iS];
        int dx = xS - xN;
        int dz = zS - zN;
        int xCurrent = xN;
        if (dx >= 0) {
            xIncrement = 1;
            width = dx;
            errorTerm = 0;
        } else {
            xIncrement = -1;
            width = -dx;
            errorTerm = -dy + 1;
        }
        int zCurrentScaled = (zN << 10) + 512;
        int roundingFactor = dy / 2;
        if (dz < 0) {
            roundingFactor = -roundingFactor;
        }
        int zIncrementScaled = ((dz << 10) + roundingFactor) / dy;
        if (dy >= width) {
            xMajorIncrement = 0;
            xMajorError = width;
        } else {
            xMajorIncrement = dx / dy;
            xMajorError = width % dy;
        }
        int i = iRaster;
        for (int y = 0; y < dy; ++y) {
            axRaster[i] = xCurrent;
            azRaster[i] = zCurrentScaled >> 10;
            xCurrent += xMajorIncrement;
            if ((errorTerm += xMajorError) > 0) {
                xCurrent += xIncrement;
                errorTerm -= dy;
            }
            zCurrentScaled += zIncrementScaled;
            ++i;
        }
        if (gouraud != null) {
            Rgb16 rgb16Base = this.rgb16t1;
            rgb16Base.set(this.rgb16sGouraud[iN]);
            Rgb16 rgb16Increment = this.rgb16t2;
            rgb16Increment.diffDiv(this.rgb16sGouraud[iS], rgb16Base, dy);
            int iMax = iRaster + dy;
            for (int i2 = iRaster; i2 < iMax; ++i2) {
                gouraud[i2].setAndIncrement(rgb16Base, rgb16Increment);
            }
            Rgb16 north = this.rgb16sGouraud[iN];
            Rgb16 generated = gouraud[iRaster];
        }
    }

    private void fillRaster(int y, int numLines, boolean useGouraud, boolean isClipped) {
        int i = 0;
        ++bar;
        if (y < 0) {
            numLines += y;
            i -= y;
            y = 0;
        }
        if (y + numLines > this.g3d.height) {
            numLines = this.g3d.height - y;
        }
        if (isClipped) {
            while (--numLines >= 0) {
                int xW = this.axW[i];
                int pixelCount = this.axE[i] - xW + 1;
                if (pixelCount > 0) {
                    this.g3d.plotPixelsClipped(pixelCount, xW, y, this.azW[i], this.azE[i], useGouraud ? this.rgb16sW[i] : null, useGouraud ? this.rgb16sE[i] : null);
                }
                ++y;
                ++i;
            }
        } else {
            while (--numLines >= 0) {
                int xW = this.axW[i];
                int pixelCount = this.axE[i] - xW + 1;
                if (pixelCount > 0) {
                    this.g3d.plotPixelsUnclipped(pixelCount, xW, y, this.azW[i], this.azE[i], useGouraud ? this.rgb16sW[i] : null, useGouraud ? this.rgb16sE[i] : null);
                }
                ++y;
                ++i;
            }
        }
    }
}

