/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;

class Hermite3D {
    Graphics3D g3d;
    final Point3i[] pLeft = new Point3i[16];
    final Point3i[] pRight = new Point3i[16];
    final float[] sLeft = new float[16];
    final float[] sRight = new float[16];
    int sp;
    final Point3f[] pTopLeft = new Point3f[16];
    final Point3f[] pTopRight = new Point3f[16];
    final Point3f[] pBotLeft = new Point3f[16];
    final Point3f[] pBotRight = new Point3f[16];
    final boolean[] needToFill = new boolean[16];
    Point3f a1;
    Point3f a2;
    Point3f b1;
    Point3f b2;
    Point3f c1;
    Point3f c2;
    Point3f d1;
    Point3f d2;
    Vector3f depth1;
    Vector3f T1;
    Vector3f T2;

    Hermite3D(Graphics3D g3d) {
        int i = 16;
        while (--i >= 0) {
            this.pLeft[i] = new Point3i();
            this.pRight[i] = new Point3i();
            this.pTopLeft[i] = new Point3f();
            this.pTopRight[i] = new Point3f();
            this.pBotLeft[i] = new Point3f();
            this.pBotRight[i] = new Point3f();
        }
        this.a1 = new Point3f();
        this.a2 = new Point3f();
        this.b1 = new Point3f();
        this.b2 = new Point3f();
        this.c1 = new Point3f();
        this.c2 = new Point3f();
        this.d1 = new Point3f();
        this.d2 = new Point3f();
        this.depth1 = new Vector3f();
        this.T1 = new Vector3f();
        this.T2 = new Vector3f();
        this.g3d = g3d;
    }

    void render(boolean tFill, short colix, int tension, int diameterBeg, int diameterMid, int diameterEnd, Point3i p0, Point3i p1, Point3i p2, Point3i p3) {
        if (p0.z == 1 || p1.z == 1 || p2.z == 1 || p3.z == 1) {
            return;
        }
        int x1 = p1.x;
        int y1 = p1.y;
        int z1 = p1.z;
        int x2 = p2.x;
        int y2 = p2.y;
        int z2 = p2.z;
        int xT1 = (x2 - p0.x) * tension / 8;
        int yT1 = (y2 - p0.y) * tension / 8;
        int zT1 = (z2 - p0.z) * tension / 8;
        int xT2 = (p3.x - x1) * tension / 8;
        int yT2 = (p3.y - y1) * tension / 8;
        int zT2 = (p3.z - z1) * tension / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(p1);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(p2);
        this.sp = 0;
        int n = 0;
        int dDiameterFirstHalf = 0;
        int dDiameterSecondHalf = 0;
        if (tFill) {
            dDiameterFirstHalf = 2 * (diameterMid - diameterBeg);
            dDiameterSecondHalf = 2 * (diameterEnd - diameterMid);
        } else {
            this.g3d.setColix(colix);
        }
        do {
            int dy;
            Point3i a = this.pLeft[this.sp];
            Point3i b = this.pRight[this.sp];
            int dx = b.x - a.x;
            if (dx >= -1 && dx <= 1 && (dy = b.y - a.y) >= -1 && dy <= 1) {
                ++n;
                float s = this.sLeft[this.sp];
                if (tFill) {
                    int d = s < 0.5f ? diameterBeg + (int)((float)dDiameterFirstHalf * s) : diameterMid + (int)((float)dDiameterSecondHalf * (s - 0.5f));
                    this.g3d.fillSphereCentered(colix, d, a);
                } else {
                    this.g3d.plotPixelClipped(a);
                }
                --this.sp;
                continue;
            }
            double s = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            if (this.sp >= 15) break;
            Point3i pMid = this.pRight[this.sp + 1];
            pMid.x = (int)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
            pMid.y = (int)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
            pMid.z = (int)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
            this.pRight[this.sp + 1] = this.pRight[this.sp];
            this.sRight[this.sp + 1] = this.sRight[this.sp];
            this.pRight[this.sp] = pMid;
            this.sRight[this.sp] = (float)s;
            ++this.sp;
            this.pLeft[this.sp].set(pMid);
            this.sLeft[this.sp] = (float)s;
        } while (this.sp >= 0);
    }

    void render2x(boolean fill, short colix, int tension, Point3i p0, Point3i p1, Point3i p2, Point3i p3, Point3i p4, Point3i p5, Point3i p6, Point3i p7) {
        Point3i[] endPoints = new Point3i[]{p2, p1, p6, p5};
        Vector<Point3i> points = new Vector<Point3i>(10);
        int whichPoint = 0;
        int numTopStrandPoints = 2;
        float numPointsPerSegment = 5.0f;
        if (fill) {
            numPointsPerSegment = 10.0f;
        }
        float interval = 1.0f / numPointsPerSegment;
        float currentInt = 0.0f;
        int x1 = p1.x;
        int y1 = p1.y;
        int z1 = p1.z;
        int x2 = p2.x;
        int y2 = p2.y;
        int z2 = p2.z;
        int xT1 = (x2 - p0.x) * tension / 8;
        int yT1 = (y2 - p0.y) * tension / 8;
        int zT1 = (z2 - p0.z) * tension / 8;
        int xT2 = (p3.x - x1) * tension / 8;
        int yT2 = (p3.y - y1) * tension / 8;
        int zT2 = (p3.z - z1) * tension / 8;
        this.sLeft[0] = 0.0f;
        this.pLeft[0].set(p1);
        this.sRight[0] = 1.0f;
        this.pRight[0].set(p2);
        this.sp = 0;
        this.g3d.setColix(colix);
        for (int strands = 2; strands > 0; --strands) {
            if (strands == 1) {
                x1 = p5.x;
                y1 = p5.y;
                z1 = p5.z;
                x2 = p6.x;
                y2 = p6.y;
                z2 = p6.z;
                xT1 = (x2 - p4.x) * tension / 8;
                yT1 = (y2 - p4.y) * tension / 8;
                zT1 = (z2 - p4.z) * tension / 8;
                xT2 = (p7.x - x1) * tension / 8;
                yT2 = (p7.y - y1) * tension / 8;
                zT2 = (p7.z - z1) * tension / 8;
                this.sLeft[0] = 0.0f;
                this.pLeft[0].set(p5);
                this.sRight[0] = 1.0f;
                this.pRight[0].set(p6);
                this.sp = 0;
            }
            points.addElement(endPoints[whichPoint++]);
            currentInt = interval;
            do {
                Point3i a = this.pLeft[this.sp];
                Point3i b = this.pRight[this.sp];
                int dx = b.x - a.x;
                int dy = b.y - a.y;
                int dist2 = dx * dx + dy * dy;
                if (dist2 <= 2) {
                    float s = this.sLeft[this.sp];
                    this.g3d.fillSphereCentered(colix, 3, a);
                    if (s < 1.0f - currentInt) {
                        Point3i temp = new Point3i();
                        temp.set(a);
                        points.addElement(temp);
                        currentInt += interval;
                        if (strands == 2) {
                            ++numTopStrandPoints;
                        }
                    }
                    --this.sp;
                    continue;
                }
                double s = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
                double s2 = s * s;
                double s3 = s2 * s;
                double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
                double h2 = -2.0 * s3 + 3.0 * s2;
                double h3 = s3 - 2.0 * s2 + s;
                double h4 = s3 - s2;
                if (this.sp >= 15) break;
                Point3i pMid = this.pRight[this.sp + 1];
                pMid.x = (int)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
                pMid.y = (int)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
                pMid.z = (int)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
                this.pRight[this.sp + 1] = this.pRight[this.sp];
                this.sRight[this.sp + 1] = this.sRight[this.sp];
                this.pRight[this.sp] = pMid;
                this.sRight[this.sp] = (float)s;
                ++this.sp;
                this.pLeft[this.sp].set(pMid);
                this.sLeft[this.sp] = (float)s;
            } while (this.sp >= 0);
            points.addElement(endPoints[whichPoint++]);
        }
        int size = points.size();
        if (fill) {
            Point3i t1 = null;
            Point3i b1 = null;
            Point3i t2 = null;
            Point3i b2 = null;
            for (int top = 1; top < numTopStrandPoints && top + numTopStrandPoints < size; ++top) {
                t1 = (Point3i)points.elementAt(top - 1);
                b1 = (Point3i)points.elementAt(numTopStrandPoints + (top - 1));
                t2 = (Point3i)points.elementAt(top);
                b2 = (Point3i)points.elementAt(numTopStrandPoints + top);
                this.g3d.fillTriangle(t1, b1, t2);
                this.g3d.fillTriangle(b2, t2, b1);
            }
            if (numTopStrandPoints * 2 != size) {
                this.g3d.fillTriangle(p1, p5, t2);
                this.g3d.fillTriangle(b2, t2, p5);
            }
        } else {
            for (int top = 0; top < numTopStrandPoints && top + numTopStrandPoints < size; ++top) {
                this.g3d.drawLine((Point3i)points.elementAt(top), (Point3i)points.elementAt(top + numTopStrandPoints));
            }
        }
    }

    static void set(Point3f p3f, Point3i p3i) {
        p3f.x = p3i.x;
        p3f.y = p3i.y;
        p3f.z = p3i.z;
    }

    public void render2(boolean fill, boolean border, short colix, int tension, Point3i p0, Point3i p1, Point3i p2, Point3i p3, Point3i p4, Point3i p5, Point3i p6, Point3i p7, int aspectRatio) {
        if (p0.z == 1 || p1.z == 1 || p2.z == 1 || p3.z == 1 || p4.z == 1 || p5.z == 1 || p6.z == 1 || p7.z == 1) {
            return;
        }
        if (!fill) {
            this.render2x(fill, colix, tension, p0, p1, p2, p3, p4, p5, p6, p7);
            return;
        }
        float ratio = 1.0f / (float)aspectRatio;
        int x1 = p1.x;
        int y1 = p1.y;
        int z1 = p1.z;
        int x2 = p2.x;
        int y2 = p2.y;
        int z2 = p2.z;
        int xT1 = (x2 - p0.x) * tension / 8;
        int yT1 = (y2 - p0.y) * tension / 8;
        int zT1 = (z2 - p0.z) * tension / 8;
        int xT2 = (p3.x - x1) * tension / 8;
        int yT2 = (p3.y - y1) * tension / 8;
        int zT2 = (p3.z - z1) * tension / 8;
        Hermite3D.set(this.pTopLeft[0], p1);
        Hermite3D.set(this.pTopRight[0], p2);
        int x5 = p5.x;
        int y5 = p5.y;
        int z5 = p5.z;
        int x6 = p6.x;
        int y6 = p6.y;
        int z6 = p6.z;
        int xT5 = (x6 - p4.x) * tension / 8;
        int yT5 = (y6 - p4.y) * tension / 8;
        int zT5 = (z6 - p4.z) * tension / 8;
        int xT6 = (p7.x - x5) * tension / 8;
        int yT6 = (p7.y - y5) * tension / 8;
        int zT6 = (p7.z - z5) * tension / 8;
        Hermite3D.set(this.pBotLeft[0], p5);
        Hermite3D.set(this.pBotRight[0], p6);
        this.sLeft[0] = 0.0f;
        this.sRight[0] = 1.0f;
        this.needToFill[0] = true;
        this.sp = 0;
        boolean closeEnd = false;
        do {
            double dyTop;
            double dyTop2;
            Point3f a = this.pTopLeft[this.sp];
            Point3f b = this.pTopRight[this.sp];
            double dxTop = b.x - a.x;
            double dxTop2 = dxTop * dxTop;
            if (dxTop2 < 10.0 && (dyTop2 = (dyTop = (double)(b.y - a.y)) * dyTop) < 10.0) {
                double dyBot;
                double dyBot2;
                Point3f c = this.pBotLeft[this.sp];
                Point3f d = this.pBotRight[this.sp];
                double dxBot = d.x - c.x;
                double dxBot2 = dxBot * dxBot;
                if (dxBot2 < 8.0 && (dyBot2 = (dyBot = (double)(d.y - c.y)) * dyBot) < 8.0) {
                    if (border) {
                        this.g3d.fillSphereCentered(colix, 3, a);
                        this.g3d.fillSphereCentered(colix, 3, c);
                    }
                    if (this.needToFill[this.sp]) {
                        if (aspectRatio > 0) {
                            this.setDepth(this.depth1, c, a, b, ratio);
                            this.setPoint(this.a1, a, this.depth1, 1);
                            this.setPoint(this.a2, a, this.depth1, -1);
                            this.setPoint(this.b1, b, this.depth1, 1);
                            this.setPoint(this.b2, b, this.depth1, -1);
                            this.setPoint(this.c1, c, this.depth1, 1);
                            this.setPoint(this.c2, c, this.depth1, -1);
                            this.setPoint(this.d1, d, this.depth1, 1);
                            this.setPoint(this.d2, d, this.depth1, -1);
                            this.g3d.fillQuadrilateral(colix, this.a1, this.b1, this.d1, this.c1);
                            this.g3d.fillQuadrilateral(colix, this.a2, this.b2, this.d2, this.c2);
                            this.g3d.fillQuadrilateral(colix, this.a1, this.b1, this.b2, this.a2);
                            this.g3d.fillQuadrilateral(colix, this.c1, this.d1, this.d2, this.c2);
                            closeEnd = true;
                        } else {
                            this.g3d.fillQuadrilateral(colix, a, b, d, c);
                        }
                        this.needToFill[this.sp] = false;
                    }
                    if (dxTop2 + dyTop2 < 2.0 && dxBot2 + dyBot2 < 2.0) {
                        --this.sp;
                        continue;
                    }
                }
            }
            double s = (this.sLeft[this.sp] + this.sRight[this.sp]) / 2.0f;
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            if (this.sp >= 15) break;
            int spNext = this.sp + 1;
            Point3f pMidTop = this.pTopRight[spNext];
            pMidTop.x = (float)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
            pMidTop.y = (float)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
            pMidTop.z = (float)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
            Point3f pMidBot = this.pBotRight[spNext];
            pMidBot.x = (float)(h1 * (double)x5 + h2 * (double)x6 + h3 * (double)xT5 + h4 * (double)xT6);
            pMidBot.y = (float)(h1 * (double)y5 + h2 * (double)y6 + h3 * (double)yT5 + h4 * (double)yT6);
            pMidBot.z = (float)(h1 * (double)z5 + h2 * (double)z6 + h3 * (double)zT5 + h4 * (double)zT6);
            this.pTopRight[spNext] = this.pTopRight[this.sp];
            this.pTopRight[this.sp] = pMidTop;
            this.pBotRight[spNext] = this.pBotRight[this.sp];
            this.pBotRight[this.sp] = pMidBot;
            this.sRight[spNext] = this.sRight[this.sp];
            this.sRight[this.sp] = (float)s;
            this.needToFill[spNext] = this.needToFill[this.sp];
            this.pTopLeft[spNext].set(pMidTop);
            this.pBotLeft[spNext].set(pMidBot);
            this.sLeft[spNext] = (float)s;
            ++this.sp;
        } while (this.sp >= 0);
        if (closeEnd) {
            this.a1.z += 1.0f;
            this.c1.z += 1.0f;
            this.c2.z += 1.0f;
            this.a2.z += 1.0f;
            this.g3d.fillQuadrilateral(colix, this.a1, this.c1, this.c2, this.a2);
        }
    }

    private void setDepth(Vector3f depth, Point3f c, Point3f a, Point3f b, float ratio) {
        this.T1.sub(a, c);
        this.T1.scale(ratio);
        this.T2.sub(a, b);
        depth.cross(this.T1, this.T2);
        depth.scale(this.T1.length() / depth.length());
    }

    private void setPoint(Point3f a1, Point3f a, Vector3f depth, int direction) {
        a1.set(a);
        if (direction == 1) {
            a1.add(depth);
        } else {
            a1.sub(depth);
        }
    }

    static void getHermiteList(int tension, Tuple3f p0, Tuple3f p1, Tuple3f p2, Tuple3f p3, Tuple3f p4, Tuple3f[] list, int n) {
        int nPoints = n + 1;
        float fnPoints = n - 1;
        float x1 = p1.x;
        float y1 = p1.y;
        float z1 = p1.z;
        float x2 = p2.x;
        float y2 = p2.y;
        float z2 = p2.z;
        float xT1 = (x2 - p0.x) * (float)tension / 8.0f;
        float yT1 = (y2 - p0.y) * (float)tension / 8.0f;
        float zT1 = (z2 - p0.z) * (float)tension / 8.0f;
        float xT2 = (p3.x - x1) * (float)tension / 8.0f;
        float yT2 = (p3.y - y1) * (float)tension / 8.0f;
        float zT2 = (p3.z - z1) * (float)tension / 8.0f;
        float xT3 = (p4.x - x2) * (float)tension / 8.0f;
        float yT3 = (p4.y - y2) * (float)tension / 8.0f;
        float zT3 = (p4.z - z2) * (float)tension / 8.0f;
        list[0] = p1;
        for (int i = 0; i < nPoints; ++i) {
            double s = (float)i / fnPoints;
            if (i == nPoints - 1) {
                x1 = x2;
                y1 = y2;
                z1 = z2;
                x2 = p3.x;
                y2 = p3.y;
                z2 = p3.z;
                xT1 = xT2;
                yT1 = yT2;
                zT1 = zT2;
                xT2 = xT3;
                yT2 = yT3;
                zT2 = zT3;
                s -= 1.0;
            }
            double s2 = s * s;
            double s3 = s2 * s;
            double h1 = 2.0 * s3 - 3.0 * s2 + 1.0;
            double h2 = -2.0 * s3 + 3.0 * s2;
            double h3 = s3 - 2.0 * s2 + s;
            double h4 = s3 - s2;
            float x = (float)(h1 * (double)x1 + h2 * (double)x2 + h3 * (double)xT1 + h4 * (double)xT2);
            float y = (float)(h1 * (double)y1 + h2 * (double)y2 + h3 * (double)yT1 + h4 * (double)yT2);
            float z = (float)(h1 * (double)z1 + h2 * (double)z2 + h3 * (double)zT1 + h4 * (double)zT2);
            list[i] = list instanceof Point3f[] ? new Point3f(x, y, z) : new Vector3f(x, y, z);
        }
    }
}

