/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.XmlReader;
import org.xml.sax.XMLReader;

class XmlChem3dReader
extends XmlReader {
    String[] chem3dImplementedAttributes = new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatDat", "calcPartialCharges", "calcAtoms"};
    String modelName = null;
    String formula = null;
    String phase = null;

    XmlChem3dReader(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        this.logger = parent.logger;
        new Chem3dHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    XmlChem3dReader(XmlReader parent, AtomSetCollection atomSetCollection, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.chem3dImplementedAttributes;
        new Chem3dHandler().walkDOMTree(DOMNode);
    }

    void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        String[] tokens;
        this.logger.log("xmlchem3d: start " + localName);
        if ("model".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.atom = new Atom();
            this.atom.atomName = (String)atts.get("id");
            this.atom.elementSymbol = (String)atts.get("symbol");
            if (atts.containsKey("cartCoords")) {
                String xyz = (String)atts.get("cartCoords");
                String[] tokens2 = this.getTokens(xyz);
                this.atom.x = this.parseFloat(tokens2[0]);
                this.atom.y = this.parseFloat(tokens2[1]);
                this.atom.z = this.parseFloat(tokens2[2]);
            }
            return;
        }
        if ("bond".equals(localName)) {
            String atom1 = (String)atts.get("bondAtom1");
            String atom2 = (String)atts.get("bondAtom2");
            int order = 1;
            if (atts.containsKey("bondOrder")) {
                order = this.parseInt((String)atts.get("bondOrder"));
            }
            this.atomSetCollection.addNewBond(atom1, atom2, order);
            return;
        }
        if ("electronicStructureCalculation".equals(localName)) {
            tokens = this.getTokens((String)atts.get("calcPartialCharges"));
            String[] tokens2 = this.getTokens((String)atts.get("calcAtoms"));
            int i = this.parseInt(tokens[0]);
            while (--i >= 0) {
                this.atomSetCollection.mapPartialCharge(tokens2[i + 1], this.parseFloat(tokens[i + 1]));
            }
        }
        if ("gridData".equals(localName)) {
            int y;
            int nPointsX = this.parseInt((String)atts.get("gridDatXDim"));
            int nPointsY = this.parseInt((String)atts.get("gridDatYDim"));
            int nPointsZ = this.parseInt((String)atts.get("gridDatZDim"));
            float xStep = this.parseFloat((String)atts.get("gridDatXSize")) / (float)nPointsX;
            float yStep = this.parseFloat((String)atts.get("gridDatYSize")) / (float)nPointsY;
            float zStep = this.parseFloat((String)atts.get("gridDatZSize")) / (float)nPointsZ;
            String xyz = (String)atts.get("gridDatOrigin");
            tokens = this.getTokens(xyz);
            float originX = this.parseFloat(tokens[0]);
            float originY = this.parseFloat(tokens[1]);
            float originZ = this.parseFloat(tokens[2]);
            tokens = this.getTokens((String)atts.get("gridDatData"));
            int nData = this.parseInt(tokens[0]);
            int pt = 1;
            float[][][] voxelData = new float[nPointsX][][];
            for (int x = 0; x < nPointsX; ++x) {
                voxelData[x] = new float[nPointsY][];
                for (y = 0; y < nPointsY; ++y) {
                    voxelData[x][y] = new float[nPointsZ];
                }
            }
            for (int z = 0; z < nPointsZ; ++z) {
                for (y = 0; y < nPointsY; ++y) {
                    for (int x = 0; x < nPointsX; ++x) {
                        voxelData[x][y][z] = this.parseFloat(tokens[pt++]);
                    }
                }
            }
            int[] voxelCounts = new int[]{nPointsX, nPointsY, nPointsZ};
            Point3f volumetricOrigin = new Point3f(originX, originY, originZ);
            Vector3f[] volumetricVectors = new Vector3f[]{new Vector3f(xStep, 0.0f, 0.0f), new Vector3f(0.0f, yStep, 0.0f), new Vector3f(0.0f, 0.0f, zStep)};
            Hashtable<String, Object> surfaceInfo = new Hashtable<String, Object>();
            surfaceInfo.put("surfaceDataType", "mo");
            surfaceInfo.put("volumetricOrigin", volumetricOrigin);
            surfaceInfo.put("voxelCounts", voxelCounts);
            surfaceInfo.put("volumetricVectors", volumetricVectors);
            surfaceInfo.put("nCubeData", new Integer(nData));
            surfaceInfo.put("voxelData", voxelData);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("jmolSurfaceInfo", surfaceInfo);
            this.logger.log("Chem3D molecular orbital data displayable using:  isosurface sign \"\" ");
            return;
        }
    }

    void processEndElement(String uri, String localName, String qName) {
        this.logger.log("xmlchem3d: end " + localName);
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class Chem3dHandler
    extends XmlReader.JmolXmlHandler {
        Chem3dHandler() {
            super(XmlChem3dReader.this);
        }

        Chem3dHandler(XMLReader xmlReader) {
            super(XmlChem3dReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

