/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.util.Logger;

class OdysseyReader
extends AtomSetCollectionReader {
    String modelName = "Odyssey file";
    int atomCount;
    int bondCount;
    Hashtable moData = new Hashtable();

    OdysseyReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("odyssey)");
        try {
            this.readHeader();
            this.discardLinesUntilContains("0 1");
            if (this.line == null) {
                return this.atomSetCollection;
            }
            this.readAtoms();
            this.discardLinesUntilContains("ATOMLABELS");
            if (this.line != null) {
                this.readAtomNames();
            }
            this.discardLinesUntilContains("HESSIAN");
            if (this.line != null) {
                this.readBonds();
            }
        }
        catch (Exception ex) {
            Logger.error("Could not read file", ex);
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        } else {
            this.atomSetCollection.setAtomSetName(this.modelName);
        }
        return this.atomSetCollection;
    }

    void readHeader() throws Exception {
        while (this.readLine() != null && !this.line.startsWith(" ")) {
        }
        this.readLine();
        this.modelName = this.line + ";";
        this.modelName = this.modelName.substring(0, this.modelName.indexOf(";")).trim();
    }

    void readAtoms() throws Exception {
        this.atomCount = 0;
        while (this.readLine() != null && !this.line.startsWith("ENDCART")) {
            String[] tokens = this.getTokens(this.line);
            int elementNumber = this.parseInt(tokens[0]);
            String elementSymbol = AtomSetCollectionReader.getElementSymbol(elementNumber);
            float x = this.parseFloat(tokens[1]);
            float y = this.parseFloat(tokens[2]);
            float z = this.parseFloat(tokens[3]);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = elementSymbol;
            atom.x = x;
            atom.y = y;
            atom.z = z;
            ++this.atomCount;
        }
    }

    void readAtomNames() throws Exception {
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomSetCollection.atoms[i].atomName = this.line.substring(1, this.line.length() - 1);
        }
    }

    void readBonds() throws Exception {
        int nAtoms = this.atomCount;
        while (this.readLine() != null && !this.line.startsWith("ENDHESS")) {
            String[] tokens = this.getTokens(this.line);
            if (nAtoms == 0) {
                int sourceIndex = this.parseInt(tokens[0]) - 1;
                int targetIndex = this.parseInt(tokens[1]) - 1;
                int bondOrder = this.parseInt(tokens[2]);
                if (bondOrder <= 0) continue;
                this.atomSetCollection.addBond(new Bond(sourceIndex, targetIndex, bondOrder < 4 ? bondOrder : 1));
                ++this.bondCount;
                continue;
            }
            nAtoms -= tokens.length;
        }
        this.logger.log(this.bondCount + " bonds read");
    }
}

